/*
 * Decompiled with CFR 0.152.
 */
package de.dafuqs.spectrum.entity.type_specific_predicates;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import de.dafuqs.spectrum.entity.SpectrumTypeSpecificPredicates;
import de.dafuqs.spectrum.entity.entity.KindlingEntity;
import de.dafuqs.spectrum.entity.variants.KindlingVariant;
import de.dafuqs.spectrum.registries.SpectrumRegistries;
import java.util.Optional;
import net.minecraft.class_1297;
import net.minecraft.class_243;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_7376;
import org.jetbrains.annotations.Nullable;

public class KindlingPredicate
implements class_7376 {
    private static final String CLIPPED_KEY = "clipped";
    private static final String ANGRY_KEY = "angry";
    private static final String VARIANT_KEY = "variant";
    private final Optional<Boolean> clipped;
    private final Optional<Boolean> angry;
    private final Optional<KindlingVariant> variant;

    private KindlingPredicate(Optional<Boolean> clipped, Optional<Boolean> angry, Optional<KindlingVariant> variant) {
        this.clipped = clipped;
        this.angry = angry;
        this.variant = variant;
    }

    public static KindlingPredicate of(Optional<Boolean> clipped, Optional<Boolean> angry, Optional<KindlingVariant> variant) {
        return new KindlingPredicate(clipped, angry, variant);
    }

    public static KindlingPredicate fromJson(JsonObject json) {
        JsonElement clippedElement = json.get(CLIPPED_KEY);
        Optional<Boolean> clippedOptional = clippedElement == null ? Optional.empty() : Optional.of(clippedElement.getAsBoolean());
        JsonElement angryElement = json.get(ANGRY_KEY);
        Optional<Boolean> angryOptional = angryElement == null ? Optional.empty() : Optional.of(angryElement.getAsBoolean());
        JsonElement variantElement = json.get(VARIANT_KEY);
        Optional variantOptional = variantElement == null ? Optional.empty() : SpectrumRegistries.KINDLING_VARIANT.method_17966(class_2960.method_12829((String)variantElement.getAsString()));
        return new KindlingPredicate(clippedOptional, angryOptional, variantOptional);
    }

    public JsonObject method_22494() {
        JsonObject jsonObject = new JsonObject();
        this.clipped.ifPresent(clipped -> jsonObject.add(CLIPPED_KEY, (JsonElement)new JsonPrimitive(clipped)));
        this.angry.ifPresent(angry -> jsonObject.add(ANGRY_KEY, (JsonElement)new JsonPrimitive(angry)));
        this.variant.ifPresent(variant -> jsonObject.add(VARIANT_KEY, (JsonElement)new JsonPrimitive(SpectrumRegistries.KINDLING_VARIANT.method_10221(variant).toString())));
        return jsonObject;
    }

    public class_7376.class_7377 method_43099() {
        return SpectrumTypeSpecificPredicates.KINDLING;
    }

    public boolean method_22497(class_1297 entity, class_3218 world, @Nullable class_243 pos) {
        if (!(entity instanceof KindlingEntity)) {
            return false;
        }
        KindlingEntity kindling = (KindlingEntity)entity;
        return !(!this.clipped.isEmpty() && this.clipped.get().booleanValue() != kindling.isClipped() || !this.angry.isEmpty() && (this.angry.get() != (kindling.method_29507() == 0) || !this.variant.isEmpty() && this.variant.get() != kindling.getKindlingVariant()));
    }
}

