/*
 * Decompiled with CFR 0.152.
 */
package de.dafuqs.spectrum.events.listeners;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import net.minecraft.class_1937;
import net.minecraft.class_243;
import net.minecraft.class_3218;
import net.minecraft.class_5712;
import net.minecraft.class_5714;
import net.minecraft.class_5716;

public abstract class EventQueue<D>
implements class_5714 {
    protected final class_5716 positionSource;
    protected final int range;
    protected final Callback<D> callback;
    protected final Map<D, Integer> eventQueue;

    public EventQueue(class_5716 positionSource, int range, Callback<D> listener) {
        this.positionSource = positionSource;
        this.range = range;
        this.callback = listener;
        this.eventQueue = new HashMap<D, Integer>();
    }

    public void tick(class_1937 world) {
        for (D key : new HashSet<D>(this.eventQueue.keySet())) {
            Integer tickCounter = this.eventQueue.get(key);
            if (tickCounter >= 1) {
                this.eventQueue.put(key, tickCounter - 1);
                continue;
            }
            this.callback.triggerEvent(world, this, key);
            this.eventQueue.remove(key);
        }
    }

    public class_5716 method_32946() {
        return this.positionSource;
    }

    public int method_32948() {
        return this.range;
    }

    public int getQueuedEventCount() {
        return this.eventQueue.size();
    }

    public boolean method_32947(class_3218 world, class_5712 event, class_5712.class_7397 emitter, class_243 emitterPos) {
        Optional positionSourcePosOptional = this.positionSource.method_32956((class_1937)world);
        if (positionSourcePosOptional.isEmpty()) {
            return false;
        }
        if (!this.callback.canAcceptEvent((class_1937)world, this, new class_5712.class_7447(event, emitterPos, emitter, (class_5714)this, (class_243)positionSourcePosOptional.get()), (class_243)positionSourcePosOptional.get())) {
            return false;
        }
        this.acceptEvent((class_1937)world, new class_5712.class_7447(event, emitterPos, emitter, (class_5714)this, (class_243)positionSourcePosOptional.get()), (class_243)positionSourcePosOptional.get());
        return true;
    }

    protected abstract void acceptEvent(class_1937 var1, class_5712.class_7447 var2, class_243 var3);

    protected void schedule(D object, int delay) {
        this.eventQueue.put(object, delay);
    }

    public static interface Callback<D> {
        public boolean canAcceptEvent(class_1937 var1, class_5714 var2, class_5712.class_7447 var3, class_243 var4);

        public void triggerEvent(class_1937 var1, class_5714 var2, D var3);
    }
}

