/*
 * Decompiled with CFR 0.152.
 */
package de.dafuqs.spectrum.explosion;

import de.dafuqs.spectrum.SpectrumCommon;
import de.dafuqs.spectrum.explosion.ExplosionArchetype;
import de.dafuqs.spectrum.explosion.ExplosionModifier;
import de.dafuqs.spectrum.explosion.ExplosionModifierType;
import de.dafuqs.spectrum.explosion.ExplosionShape;
import de.dafuqs.spectrum.explosion.modifier.DamageChangingModifier;
import de.dafuqs.spectrum.explosion.modifier.EnchantmentAddingModifier;
import de.dafuqs.spectrum.explosion.modifier.FireModifier;
import de.dafuqs.spectrum.explosion.modifier.KillZoneModifier;
import de.dafuqs.spectrum.explosion.modifier.LightPlacingModifier;
import de.dafuqs.spectrum.explosion.modifier.MoreBoomModifier;
import de.dafuqs.spectrum.explosion.modifier.ParticleAddingModifier;
import de.dafuqs.spectrum.explosion.modifier.PrimordialFireModifier;
import de.dafuqs.spectrum.particle.SpectrumParticleTypes;
import de.dafuqs.spectrum.registries.SpectrumDamageTypes;
import de.dafuqs.spectrum.registries.SpectrumEnchantments;
import de.dafuqs.spectrum.registries.SpectrumRegistries;
import java.util.Optional;
import net.minecraft.class_1282;
import net.minecraft.class_1309;
import net.minecraft.class_1893;
import net.minecraft.class_2378;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_2960;
import org.jetbrains.annotations.Nullable;

public class ExplosionModifiers {
    public static final ExplosionModifierType GENERIC = ExplosionModifiers.registerModifierType("generic", new ExplosionModifierType(ExplosionArchetype.ALL, Integer.MAX_VALUE));
    public static final ExplosionModifierType DAMAGE_TYPE = ExplosionModifiers.registerModifierType("damage_type", new ExplosionModifierType(ExplosionArchetype.DAMAGE_ENTITIES, 1));
    public static final ExplosionModifierType DAMAGE_MODIFICATION = ExplosionModifiers.registerModifierType("damage_modification", new ExplosionModifierType(ExplosionArchetype.DAMAGE_ENTITIES, Integer.MAX_VALUE));
    public static final ExplosionModifierType DESTRUCTION_SHAPE = ExplosionModifiers.registerModifierType("destruction_shape", new ExplosionModifierType(ExplosionArchetype.DESTROY_BLOCKS, 1));
    public static final ExplosionModifierType DESTRUCTION_MODIFICATION = ExplosionModifiers.registerModifierType("destruction_modification", new ExplosionModifierType(ExplosionArchetype.DESTROY_BLOCKS, Integer.MAX_VALUE));
    public static final ExplosionModifier EXPLOSION_BOOST = ExplosionModifiers.registerModifier("explosion_boost", new MoreBoomModifier(GENERIC, 16760640));
    public static final ExplosionModifier FIRE = ExplosionModifiers.registerModifier("fire", new FireModifier(DAMAGE_TYPE, (class_2394)class_2398.field_11240, 11531243));
    public static final ExplosionModifier PRIMORDIAL_FIRE = ExplosionModifiers.registerModifier("primordial_fire", new PrimordialFireModifier(DAMAGE_TYPE, (class_2394)SpectrumParticleTypes.PRIMORDIAL_FLAME_SMALL, 7742797));
    public static final ExplosionModifier LIGHTNING = ExplosionModifiers.registerModifier("lightning_damage", new DamageChangingModifier(DAMAGE_TYPE, (class_2394)SpectrumParticleTypes.WHITE_EXPLOSION, 15790669){

        @Override
        public Optional<class_1282> getDamageSource(@Nullable class_1309 owner) {
            if (owner == null) {
                return Optional.empty();
            }
            return Optional.of(owner.method_48923().method_48809());
        }
    });
    public static final ExplosionModifier MAGIC = ExplosionModifiers.registerModifier("magic_damage", new DamageChangingModifier(DAMAGE_TYPE, (class_2394)SpectrumParticleTypes.PURPLE_CRAFTING, 5518245){

        @Override
        public Optional<class_1282> getDamageSource(@Nullable class_1309 owner) {
            if (owner == null) {
                return Optional.empty();
            }
            return Optional.of(owner.method_48923().method_48831());
        }
    });
    public static final ExplosionModifier INCANDESCENCE = ExplosionModifiers.registerModifier("incandescence", new DamageChangingModifier(DAMAGE_TYPE, (class_2394)class_2398.field_11215, 0xFF59FF){

        @Override
        public Optional<class_1282> getDamageSource(@Nullable class_1309 owner) {
            if (owner == null) {
                return Optional.empty();
            }
            return Optional.of(SpectrumDamageTypes.incandescence(owner.method_37908()));
        }
    });
    public static final ExplosionModifier KILL_ZONE = ExplosionModifiers.registerModifier("kill_zone", new KillZoneModifier(DAMAGE_MODIFICATION, 0.5f, 20.0f, 11763739));
    public static final ExplosionModifier SHAPE_SQUARE = ExplosionModifiers.registerModifier("shape_square", new ExplosionModifier(DESTRUCTION_SHAPE, 5518245){

        @Override
        public Optional<ExplosionShape> getShape() {
            return Optional.of(ExplosionShape.SQUARE);
        }
    });
    public static final ExplosionModifier FORTUNE = ExplosionModifiers.registerModifier("fortune", new EnchantmentAddingModifier(DESTRUCTION_MODIFICATION, class_1893.field_9130, 3, (class_2394)class_2398.field_11215, 5518245));
    public static final ExplosionModifier SILK_TOUCH = ExplosionModifiers.registerModifier("silk_touch", new EnchantmentAddingModifier(DESTRUCTION_MODIFICATION, class_1893.field_9099, 1, (class_2394)class_2398.field_11215, 5518245));
    public static final ExplosionModifier INVENTORY_INSERTION = ExplosionModifiers.registerModifier("inventory_insertion", new EnchantmentAddingModifier(DESTRUCTION_MODIFICATION, SpectrumEnchantments.INVENTORY_INSERTION, 1, (class_2394)class_2398.field_11215, 5518245));
    public static final ExplosionModifier STARRY = ExplosionModifiers.registerModifier("starry", new ParticleAddingModifier(GENERIC, (class_2394)class_2398.field_11207, 12830932));
    public static final ExplosionModifier LIGHT = ExplosionModifiers.registerModifier("light", new LightPlacingModifier(GENERIC, (class_2394)SpectrumParticleTypes.SHIMMERSTONE_SPARKLE, 16447610));

    private static <T extends ExplosionModifier> T registerModifier(String name, T modifier) {
        return (T)((ExplosionModifier)class_2378.method_10230(SpectrumRegistries.EXPLOSION_MODIFIERS, (class_2960)SpectrumCommon.locate(name), modifier));
    }

    private static ExplosionModifierType registerModifierType(String name, ExplosionModifierType type) {
        return (ExplosionModifierType)class_2378.method_10230(SpectrumRegistries.EXPLOSION_MODIFIER_TYPES, (class_2960)SpectrumCommon.locate(name), (Object)type);
    }

    public static void register() {
    }
}

