/*
 * Decompiled with CFR 0.152.
 */
package de.dafuqs.spectrum.explosion;

import com.mojang.datafixers.util.Pair;
import de.dafuqs.spectrum.compat.claims.GenericClaimModsCompat;
import de.dafuqs.spectrum.explosion.ExplosionArchetype;
import de.dafuqs.spectrum.explosion.ExplosionModifier;
import de.dafuqs.spectrum.explosion.ExplosionShape;
import de.dafuqs.spectrum.helpers.Orientation;
import de.dafuqs.spectrum.mixin.accessors.ExplosionAccessor;
import de.dafuqs.spectrum.particle.SpectrumParticleTypes;
import de.dafuqs.spectrum.registries.SpectrumEnchantments;
import de.dafuqs.spectrum.registries.SpectrumItems;
import de.dafuqs.spectrum.registries.SpectrumSoundEvents;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import net.fabricmc.fabric.api.tag.convention.v1.ConventionalEntityTypeTags;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1542;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_181;
import net.minecraft.class_1887;
import net.minecraft.class_1890;
import net.minecraft.class_1927;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_2382;
import net.minecraft.class_2394;
import net.minecraft.class_243;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_3218;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3532;
import net.minecraft.class_5819;
import net.minecraft.class_8567;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ModularExplosion {
    public static void explode(@NotNull class_3218 world, class_2338 pos, @Nullable class_1657 owner, double baseBlastRadius, float baseDamage, ExplosionArchetype archetype, List<ExplosionModifier> modifiers) {
        class_1282 damageSource = world.method_48963().method_48807(null);
        float damageMod = 1.0f;
        float killzoneDamageMod = 1.0f;
        double blastRadius = baseBlastRadius;
        double killZoneRadius = 0.0;
        ExplosionShape shape = ExplosionShape.DEFAULT;
        class_1799 miningStack = new class_1799((class_1935)SpectrumItems.BEDROCK_PICKAXE);
        for (ExplosionModifier explosionEffect : modifiers) {
            Optional<ExplosionShape> optionalExplosionShape;
            damageMod += explosionEffect.getDamageModifier();
            killzoneDamageMod += explosionEffect.getKillZoneDamageModifier();
            blastRadius += (double)explosionEffect.getBlastRadiusModifier();
            killZoneRadius += (double)explosionEffect.getKillZoneRadius();
            Optional<class_1282> effectDamage = explosionEffect.getDamageSource((class_1309)owner);
            if (effectDamage.isPresent()) {
                damageSource = effectDamage.get();
            }
            if ((optionalExplosionShape = explosionEffect.getShape()).isPresent()) {
                shape = optionalExplosionShape.get();
            }
            explosionEffect.addEnchantments(miningStack);
        }
        float blastDamage = baseDamage * damageMod;
        float killZoneDamage = baseDamage * killzoneDamageMod;
        class_243 center = class_243.method_24953((class_2382)pos);
        world.method_43128(null, center.method_10216(), center.method_10214(), center.method_10215(), SpectrumSoundEvents.BLOCK_MODULAR_EXPLOSIVE_EXPLODE, class_3419.field_15245, 1.0f, 0.8f + world.method_8409().method_43057() * 0.3f);
        ModularExplosion.playVisualEffects(world, center, modifiers, blastRadius);
        class_238 blastBox = class_238.method_30048((class_243)center, (double)(blastRadius * 2.0), (double)(blastRadius * 2.0), (double)(blastRadius * 2.0));
        if (archetype.affectsEntities) {
            double finalBlastRadius = blastRadius;
            List<class_1297> affectedEntities = world.method_8335(null, blastBox).stream().filter(entity -> entity.method_19538().method_1022(center) < finalBlastRadius).toList();
            for (class_1297 entity2 : affectedEntities) {
                double distance = Math.max(entity2.method_19538().method_1022(center) - (double)(entity2.method_17681() / 2.0f), 0.0);
                if (distance <= killZoneRadius) {
                    entity2.method_5643(damageSource, entity2.method_5864().method_20210(ConventionalEntityTypeTags.BOSSES) ? killZoneDamage / 25.0f : killZoneDamage);
                } else {
                    double finalDamage = class_3532.method_16436((double)(distance / blastRadius), (double)blastDamage, (double)(blastDamage / 2.0f));
                    entity2.method_5643(damageSource, (float)finalDamage);
                }
                if (!entity2.method_5805()) continue;
                for (ExplosionModifier explosionEffect : modifiers) {
                    explosionEffect.applyToEntity(entity2, distance);
                }
            }
        }
        if (archetype.affectsBlocks) {
            List<class_2338> affectedBlocks = ModularExplosion.processExplosion(world, owner, pos, shape, blastRadius, miningStack);
            for (ExplosionModifier explosionEffect : modifiers) {
                explosionEffect.applyToBlocks((class_1937)world, affectedBlocks);
            }
        }
    }

    private static void playVisualEffects(class_3218 world, class_243 pos, List<ExplosionModifier> effectModifiers, double blastRadius) {
        world.method_43128(null, pos.method_10216(), pos.method_10214(), pos.method_10215(), class_3417.field_14803, class_3419.field_15254, 1.0f, 0.8f + world.field_9229.method_43057() * 0.4f);
        class_5819 random = world.method_8409();
        ArrayList<class_2394> types = new ArrayList<class_2394>(effectModifiers.stream().map(ExplosionModifier::getParticleEffects).filter(Optional::isPresent).map(Optional::get).toList());
        types.add((class_2394)SpectrumParticleTypes.PRIMORDIAL_SMOKE);
        world.method_14199((class_2394)SpectrumParticleTypes.PRIMORDIAL_FLAME, pos.method_10216(), pos.method_10214(), pos.method_10215(), 30, (double)random.method_43057() * 0.5 - 0.25, (double)random.method_43057() * 0.5 - 0.25, (double)random.method_43057() * 0.5 - 0.25, 0.0);
        double particleCount = blastRadius * blastRadius + (double)random.method_43048((int)(blastRadius * 2.0)) * ((double)((float)types.size() / 2.0f) + 0.5);
        int i = 0;
        while ((double)i < particleCount) {
            double r = random.method_43058() * blastRadius;
            Orientation orientation = Orientation.create(random.method_43058() * Math.PI * 2.0, random.method_43058() * Math.PI * 2.0);
            class_243 particle = orientation.toVector(r).method_1019(pos);
            Collections.shuffle(types);
            world.method_14199(types.get(0), particle.method_10216(), particle.method_10214(), particle.method_10215(), 1, 0.0, 0.0, 0.0, 0.0);
            ++i;
        }
    }

    private static List<class_2338> processExplosion(@NotNull class_3218 world, @Nullable class_1657 owner, class_2338 center, ExplosionShape shape, double blastRadius, class_1799 miningStack) {
        class_1927 explosion = new class_1927((class_1937)world, (class_1297)owner, (double)center.method_10263(), (double)center.method_10264(), (double)center.method_10260(), (float)blastRadius, false, class_1927.class_4179.field_18687);
        ObjectArrayList drops = new ObjectArrayList();
        ArrayList<class_2338> affectedBlocks = new ArrayList<class_2338>();
        int radius = (int)blastRadius / 2;
        for (class_2338 p : class_2338.method_25996((class_2338)center, (int)radius, (int)radius, (int)radius)) {
            if (!GenericClaimModsCompat.canBreak((class_1937)world, p, (class_1297)owner) || !shape.isAffected(center, p) || !ModularExplosion.processBlock(world, (class_1297)owner, world.field_9229, center, p, (ObjectArrayList<Pair<class_1799, class_2338>>)drops, miningStack, explosion)) continue;
            affectedBlocks.add(new class_2338(p.method_10263(), p.method_10264(), p.method_10260()));
        }
        boolean hasInventoryInsertion = class_1890.method_8225((class_1887)SpectrumEnchantments.INVENTORY_INSERTION, (class_1799)miningStack) > 0;
        for (Pair stackPosPair : drops) {
            if (owner != null && hasInventoryInsertion) {
                owner.method_31548().method_7398((class_1799)stackPosPair.getFirst());
                continue;
            }
            class_2248.method_9577((class_1937)world, (class_2338)((class_2338)stackPosPair.getSecond()), (class_1799)((class_1799)stackPosPair.getFirst()));
        }
        return affectedBlocks;
    }

    private static boolean processBlock(@NotNull class_3218 world, @Nullable class_1297 owner, class_5819 random, class_2338 center, class_2338 pos, ObjectArrayList<Pair<class_1799, class_2338>> drops, class_1799 miningStack, class_1927 explosion) {
        class_2586 blockEntity;
        class_2680 state = world.method_8320(pos);
        class_2248 block = state.method_26204();
        class_2586 class_25862 = blockEntity = state.method_31709() ? world.method_8321(pos) : null;
        if (state.method_26204().method_9520() <= 9.0f) {
            if (random.method_43057() < 0.15f) {
                world.method_43128(null, (double)center.method_10263(), (double)center.method_10264(), (double)center.method_10260(), block.method_9573(state).method_10595(), class_3419.field_15245, 2.0f, 0.8f + random.method_43057() * 0.5f);
            }
            if (block.method_9533(explosion)) {
                class_8567.class_8568 builder = new class_8567.class_8568(world).method_51874(class_181.field_24424, (Object)class_243.method_24953((class_2382)pos)).method_51874(class_181.field_1229, (Object)miningStack).method_51877(class_181.field_1228, (Object)blockEntity).method_51877(class_181.field_1226, (Object)owner);
                builder.method_51874(class_181.field_1225, (Object)Float.valueOf(((ExplosionAccessor)explosion).getPower()));
                state.method_26180(world, pos, miningStack, true);
                state.method_26189(builder).forEach(stack -> ModularExplosion.tryMergeStack(drops, stack, pos.method_10062()));
            }
            world.method_8650(pos, false);
            block.method_9586((class_1937)world, pos, explosion);
            return true;
        }
        return false;
    }

    private static void tryMergeStack(ObjectArrayList<Pair<class_1799, class_2338>> stacks, class_1799 stack, class_2338 pos) {
        int i = stacks.size();
        for (int j = 0; j < i; ++j) {
            Pair pair = (Pair)stacks.get(j);
            class_1799 itemStack = (class_1799)pair.getFirst();
            if (!class_1542.method_24017((class_1799)itemStack, (class_1799)stack)) continue;
            class_1799 itemStack2 = class_1542.method_24018((class_1799)itemStack, (class_1799)stack, (int)16);
            stacks.set(j, (Object)Pair.of((Object)itemStack2, (Object)((class_2338)pair.getSecond())));
            if (!stack.method_7960()) continue;
            return;
        }
        stacks.add((Object)Pair.of((Object)stack, (Object)pos));
    }
}

