/*
 * Decompiled with CFR 0.152.
 */
package de.dafuqs.spectrum.helpers;

import net.minecraft.class_1937;
import org.jetbrains.annotations.NotNull;

public class TimeHelper {
    public static final long EPOCH_DAY_MILLIS = 86400000L;

    public static TimeOfDay getTimeOfDay(@NotNull class_1937 world) {
        return TimeHelper.getTimeOfDay(world.method_8532());
    }

    public static TimeOfDay getTimeOfDay(long timeOfDay) {
        long timeMod = timeOfDay % 24000L;
        if (timeMod >= 6000L && timeMod < 7000L) {
            return TimeOfDay.NOON;
        }
        if (timeMod >= 0L && timeMod < 12000L) {
            return TimeOfDay.DAY;
        }
        if (timeMod >= 12000L && timeMod < 13000L) {
            return TimeOfDay.SUNSET;
        }
        if (timeMod >= 23000L) {
            return TimeOfDay.SUNRISE;
        }
        if (timeMod >= 18000L && timeMod < 19000L) {
            return TimeOfDay.MIDNIGHT;
        }
        return TimeOfDay.NIGHT;
    }

    public static boolean isBrightSunlight(class_1937 world) {
        TimeOfDay timeOfDay = TimeHelper.getTimeOfDay(world);
        return timeOfDay.isDay() && !world.method_8419();
    }

    public static long getDay(long time) {
        return time / 24000L % Integer.MAX_VALUE;
    }

    public static float minecraftDaysFromSeconds(long seconds) {
        return (float)seconds / 1200.0f;
    }

    public static long secondsFromMinecraftDays(int minecraftDays) {
        return (long)minecraftDays * 1200L;
    }

    public static enum TimeOfDay {
        DAY,
        NOON,
        NIGHT,
        SUNRISE,
        SUNSET,
        MIDNIGHT;


        public boolean isNight() {
            return this == NIGHT || this == MIDNIGHT;
        }

        public boolean isDay() {
            return this == DAY || this == NOON;
        }
    }
}

