/*
 * Decompiled with CFR 0.152.
 */
package de.dafuqs.spectrum.items.map;

import de.dafuqs.spectrum.SpectrumCommon;
import java.util.List;
import java.util.concurrent.Semaphore;
import java.util.concurrent.atomic.AtomicInteger;
import net.minecraft.class_140;
import net.minecraft.class_1923;
import net.minecraft.class_1936;
import net.minecraft.class_2378;
import net.minecraft.class_2791;
import net.minecraft.class_2806;
import net.minecraft.class_2810;
import net.minecraft.class_2960;
import net.minecraft.class_3195;
import net.minecraft.class_3218;
import net.minecraft.class_3449;
import net.minecraft.class_3738;
import net.minecraft.class_4076;
import net.minecraft.class_5138;
import net.minecraft.class_6833;
import net.minecraft.class_6871;
import net.minecraft.class_6874;
import net.minecraft.class_6880;
import net.minecraft.class_7869;
import net.minecraft.class_7924;
import net.minecraft.server.MinecraftServer;
import org.jetbrains.annotations.Nullable;

public class StructureLocatorAsync {
    private final MinecraftServer server;
    private final class_3218 world;
    private final Acceptor acceptor;
    private final class_2960 targetId;
    private final int maxRadius;
    private class_1923 center;
    private class_6880<class_3195> registryEntry;
    @Nullable
    private LocatorThread thread;
    private int radius;

    public StructureLocatorAsync(class_3218 world, Acceptor acceptor, class_2960 targetId, class_1923 center, int maxRadius) {
        this.server = world.method_8503();
        this.world = world;
        this.acceptor = acceptor;
        this.targetId = targetId;
        this.center = center;
        this.maxRadius = maxRadius;
        this.thread = null;
        this.radius = 1;
        this.start();
    }

    private void start() {
        this.thread = new LocatorThread();
        this.thread.start();
    }

    public void move(int deltaX, int deltaZ) {
        if (deltaX == 0 && deltaZ == 0) {
            return;
        }
        this.cancel();
        this.radius -= Math.max(Math.abs(deltaX), Math.abs(deltaZ));
        if (this.radius < 1) {
            this.radius = 1;
        }
        this.center = new class_1923(this.center.field_9181 + deltaX, this.center.field_9180 + deltaZ);
        this.start();
    }

    public void cancel() {
        if (this.thread == null) {
            return;
        }
        this.thread.stopRunning();
        this.thread.interrupt();
        while (true) {
            try {
                this.thread.join();
            }
            catch (InterruptedException ignored) {
                continue;
            }
            break;
        }
        this.thread = null;
    }

    public static interface Acceptor {
        public void accept(class_1936 var1, class_1923 var2);
    }

    private class LocatorThread
    extends Thread {
        private static final int MAX_RUNNING_TASKS = 32;
        private static final AtomicInteger currentRunningThreads = new AtomicInteger(0);
        private final Semaphore semaphore;
        private boolean running;
        private boolean ringHadTargets;

        public LocatorThread() {
            super("Structure Locator #" + currentRunningThreads.getAndIncrement());
            this.setUncaughtExceptionHandler((Thread.UncaughtExceptionHandler)new class_140(SpectrumCommon.LOGGER));
            this.semaphore = new Semaphore(32);
        }

        public void stopRunning() {
            this.running = false;
        }

        @Override
        public void run() {
            this.running = true;
            this.ringHadTargets = false;
            StructureLocatorAsync.this.registryEntry = this.getRegistryEntry();
            if (StructureLocatorAsync.this.registryEntry == null) {
                return;
            }
            this.checkConcentricRingsStructures();
            while (this.running && !this.ringHadTargets && StructureLocatorAsync.this.radius <= StructureLocatorAsync.this.maxRadius) {
                for (int i = 0; this.running && i < StructureLocatorAsync.this.radius * 2; ++i) {
                    this.searchChunk(StructureLocatorAsync.this.center.field_9181 - StructureLocatorAsync.this.radius + i, StructureLocatorAsync.this.center.field_9180 + StructureLocatorAsync.this.radius);
                    this.searchChunk(StructureLocatorAsync.this.center.field_9181 + StructureLocatorAsync.this.radius, StructureLocatorAsync.this.center.field_9180 + StructureLocatorAsync.this.radius - i);
                    this.searchChunk(StructureLocatorAsync.this.center.field_9181 + StructureLocatorAsync.this.radius - i, StructureLocatorAsync.this.center.field_9180 - StructureLocatorAsync.this.radius);
                    this.searchChunk(StructureLocatorAsync.this.center.field_9181 - StructureLocatorAsync.this.radius, StructureLocatorAsync.this.center.field_9180 - StructureLocatorAsync.this.radius + i);
                }
                ++StructureLocatorAsync.this.radius;
            }
        }

        private class_6880<class_3195> getRegistryEntry() {
            class_2378 registry = StructureLocatorAsync.this.world.method_30349().method_33310(class_7924.field_41246).orElse(null);
            if (registry == null) {
                return null;
            }
            class_3195 structure = (class_3195)registry.method_10223(StructureLocatorAsync.this.targetId);
            if (structure == null) {
                return null;
            }
            return registry.method_47983((Object)structure);
        }

        private void checkConcentricRingsStructures() {
            class_7869 calculator = StructureLocatorAsync.this.world.method_14178().method_46642();
            double minDistance = Double.MAX_VALUE;
            class_1923 concentricStart = null;
            for (class_6874 placement : calculator.method_46708(StructureLocatorAsync.this.registryEntry)) {
                class_6871 concentricRingsStructurePlacement;
                List positions;
                if (!(placement instanceof class_6871) || (positions = calculator.method_46707(concentricRingsStructurePlacement = (class_6871)placement)) == null) continue;
                for (class_1923 pos : positions) {
                    double dx = (double)pos.field_9181 - (double)StructureLocatorAsync.this.center.field_9181;
                    double dz = (double)pos.field_9180 - (double)StructureLocatorAsync.this.center.field_9180;
                    double distance = dx * dx + dz * dz;
                    if (!(distance < minDistance)) continue;
                    minDistance = distance;
                    concentricStart = pos;
                }
            }
            if (concentricStart != null) {
                this.acceptTarget(concentricStart);
            }
        }

        private void searchChunk(int x, int z) {
            while (this.running) {
                try {
                    this.semaphore.acquire();
                }
                catch (InterruptedException ignored) {
                    continue;
                }
                StructureLocatorAsync.this.server.method_18858((Runnable)new class_3738(StructureLocatorAsync.this.server.method_3780(), () -> {
                    class_1923 chunkPos = new class_1923(x, z);
                    class_3449 target = this.locateStructureAtChunk(chunkPos);
                    if (target != null) {
                        this.acceptTarget(chunkPos);
                    }
                    this.semaphore.release();
                }));
                break;
            }
        }

        @Nullable
        private class_3449 locateStructureAtChunk(class_1923 pos) {
            class_3195 structure;
            class_5138 accessor = StructureLocatorAsync.this.world.method_27056();
            class_6833 presence = accessor.method_39783(pos, structure = (class_3195)StructureLocatorAsync.this.registryEntry.comp_349(), false);
            if (presence == class_6833.field_36240) {
                return null;
            }
            class_2791 chunk = StructureLocatorAsync.this.world.method_22342(pos.field_9181, pos.field_9180, class_2806.field_16423);
            return accessor.method_26975(class_4076.method_33705((class_2791)chunk), structure, (class_2810)chunk);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void acceptTarget(class_1923 target) {
            LocatorThread locatorThread = this;
            synchronized (locatorThread) {
                if (this.running) {
                    this.ringHadTargets = true;
                    StructureLocatorAsync.this.acceptor.accept((class_1936)StructureLocatorAsync.this.world, target);
                }
            }
        }
    }
}

