/*
 * Decompiled with CFR 0.152.
 */
package de.dafuqs.spectrum.items.tools;

import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import de.dafuqs.spectrum.api.item.ExtendedEnchantable;
import de.dafuqs.spectrum.api.item.Preenchanted;
import de.dafuqs.spectrum.api.item.SlotReservingItem;
import de.dafuqs.spectrum.api.item.SplittableItem;
import de.dafuqs.spectrum.api.render.ExtendedItemBarProvider;
import de.dafuqs.spectrum.api.render.SlotBackgroundEffectProvider;
import de.dafuqs.spectrum.entity.entity.DraconicTwinswordEntity;
import de.dafuqs.spectrum.registries.SpectrumEnchantments;
import de.dafuqs.spectrum.registries.SpectrumItems;
import de.dafuqs.spectrum.registries.SpectrumSoundEvents;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.minecraft.class_124;
import net.minecraft.class_1268;
import net.minecraft.class_1271;
import net.minecraft.class_1297;
import net.minecraft.class_1304;
import net.minecraft.class_1309;
import net.minecraft.class_1320;
import net.minecraft.class_1322;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1665;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1829;
import net.minecraft.class_1832;
import net.minecraft.class_1836;
import net.minecraft.class_1839;
import net.minecraft.class_1887;
import net.minecraft.class_1890;
import net.minecraft.class_1893;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_3222;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3532;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DraconicTwinswordItem
extends class_1829
implements SplittableItem,
SlotReservingItem,
Preenchanted,
ExtendedEnchantable,
ExtendedItemBarProvider,
SlotBackgroundEffectProvider {
    public static final float MAX_CHARGE_TIME = 60.0f;
    private final Multimap<class_1320, class_1322> phantomModifiers;

    public DraconicTwinswordItem(class_1832 toolMaterial, int attackDamage, float attackSpeed, class_1792.class_1793 settings) {
        super(toolMaterial, attackDamage, attackSpeed, settings);
        ImmutableMultimap.Builder phantom = ImmutableMultimap.builder();
        this.phantomModifiers = phantom.build();
    }

    public Multimap<class_1320, class_1322> getAttributeModifiers(class_1799 stack, class_1304 slot) {
        if (slot != class_1304.field_6173) {
            return super.method_7844(slot);
        }
        class_2487 nbt = stack.method_7948();
        if (nbt.method_10577("cooldown") || this.isReservingSlot(stack)) {
            return this.phantomModifiers;
        }
        return super.method_7844(slot);
    }

    public void method_7840(class_1799 stack, class_1937 world, class_1309 user, int remainingUseTicks) {
        if (this.isReservingSlot(stack) || remainingUseTicks == 0) {
            return;
        }
        float strength = Math.min((float)Math.abs(remainingUseTicks - this.method_7881(stack)), 60.0f) / 60.0f;
        DraconicTwinswordEntity twinsword = DraconicTwinswordItem.initiateTwinswordEntity(stack, world, user, strength);
        world.method_8649((class_1297)twinsword);
        class_3414 soundEvent = class_3417.field_15001;
        world.method_43129(null, (class_1297)twinsword, soundEvent, class_3419.field_15248, 0.5f + strength / 2.0f, 1.0f);
        class_2487 nbt = stack.method_7948();
        this.markReserved(stack, true);
        nbt.method_25927("lastTwinsword", twinsword.method_5667());
        if (!world.method_8608()) {
            stack.method_7956(1, user, p -> p.method_20236(user.method_6058()));
        }
        super.method_7840(stack, world, user, remainingUseTicks);
    }

    @NotNull
    private static DraconicTwinswordEntity initiateTwinswordEntity(class_1799 stack, class_1937 world, class_1309 user, float strength) {
        DraconicTwinswordEntity twinsword = new DraconicTwinswordEntity(world);
        twinsword.method_7432((class_1297)user);
        twinsword.setStack(stack);
        float yaw = user.method_36454();
        float pitch = user.method_36455();
        float f = -class_3532.method_15374((float)(yaw * ((float)Math.PI / 180))) * class_3532.method_15362((float)(pitch * ((float)Math.PI / 180)));
        float h = class_3532.method_15362((float)(yaw * ((float)Math.PI / 180))) * class_3532.method_15362((float)(pitch * ((float)Math.PI / 180)));
        twinsword.method_30634(user.method_23317() + (double)f * 1.334, user.method_23320() - 0.2, user.method_23321() + (double)h * 1.334);
        twinsword.method_18800(0.0, strength, 0.0);
        twinsword.setMaxPierce(class_1890.method_8225((class_1887)class_1893.field_9132, (class_1799)stack));
        twinsword.field_6007 = true;
        twinsword.field_6037 = true;
        twinsword.field_7572 = class_1665.class_1666.field_7592;
        return twinsword;
    }

    public int method_7881(class_1799 stack) {
        return 200;
    }

    public class_1271<class_1799> method_7836(class_1937 world, class_1657 user, class_1268 hand) {
        user.method_6019(hand);
        return class_1271.method_22428((Object)user.method_5998(hand));
    }

    public class_1839 method_7853(class_1799 stack) {
        return class_1839.field_8949;
    }

    public void method_7851(class_1799 stack, @Nullable class_1937 world, List<class_2561> tooltip, class_1836 context) {
        tooltip.add((class_2561)class_2561.method_43471((String)"item.spectrum.draconic_twinsword.tooltip").method_27692(class_124.field_1080));
        tooltip.add((class_2561)class_2561.method_43471((String)"item.spectrum.draconic_twinsword.tooltip2").method_27692(class_124.field_1080));
        tooltip.add((class_2561)class_2561.method_43471((String)"item.spectrum.draconic_twinsword.tooltip3").method_27692(class_124.field_1080));
    }

    public void method_7888(class_1799 stack, class_1937 world, class_1297 entity, int slot, boolean selected) {
        if (entity instanceof class_1657) {
            class_1657 player = (class_1657)entity;
            class_2487 nbt = stack.method_7948();
            if (player.method_7357().method_7904(stack.method_7909())) {
                if (!nbt.method_10577("cooldown")) {
                    nbt.method_10556("cooldown", true);
                }
            } else if (nbt.method_10545("cooldown")) {
                nbt.method_10551("cooldown");
            }
        }
    }

    @Override
    public boolean acceptsEnchantment(class_1887 enchantment) {
        return enchantment == class_1893.field_9117 || enchantment == class_1893.field_9132 || enchantment == SpectrumEnchantments.INERTIA;
    }

    public boolean method_7886(class_1799 stack) {
        return super.method_7886(stack) && !this.isReservingSlot(stack);
    }

    @Override
    public class_1799 getResult(class_3222 player, class_1799 parent) {
        class_1799 result = new class_1799((class_1935)SpectrumItems.DRAGON_TALON);
        int durability = parent.method_7919();
        if (this.isReservingSlot(parent)) {
            durability += player.method_31549().field_7477 ? 0 : 500;
            player.method_7357().method_7906(result.method_7909(), 400);
        }
        class_2487 nbt = parent.method_7948();
        nbt.method_10551("lastTwinsword");
        nbt.method_10551("cooldown");
        nbt.method_10551("reserved");
        result.method_7980(parent.method_7969());
        result.method_7974(durability);
        this.sign(player, result);
        return result;
    }

    @Override
    public boolean canSplit(class_3222 player, class_1268 occupiedHand, class_1799 stack) {
        if (player.method_7357().method_7904(stack.method_7909())) {
            return false;
        }
        return switch (occupiedHand) {
            default -> throw new IncompatibleClassChangeError();
            case class_1268.field_5808 -> player.method_5998(class_1268.field_5810).method_7960();
            case class_1268.field_5810 -> player.method_5998(class_1268.field_5808).method_7960();
        };
    }

    @Override
    public void playSound(class_3222 player) {
        player.method_17356(SpectrumSoundEvents.METALLIC_UNSHEATHE, class_3419.field_15248, 0.5f, 0.8f + player.method_6051().method_43057() * 0.4f);
    }

    @Override
    public boolean isReservingSlot(class_1799 stack) {
        return stack.method_7948().method_10577("reserved");
    }

    @Override
    public void markReserved(class_1799 stack, boolean reserved) {
        stack.method_7948().method_10556("reserved", reserved);
    }

    public static class_1799 findThrownStack(class_1657 player, UUID id) {
        class_1661 inventory = player.method_31548();
        for (int i = 0; i < inventory.method_5439(); ++i) {
            class_1799 stack = inventory.method_5438(i);
            class_2487 nbt = stack.method_7969();
            if (nbt == null || !nbt.method_25928("lastTwinsword") || !nbt.method_25926("lastTwinsword").equals(id)) continue;
            return stack;
        }
        return class_1799.field_8037;
    }

    @Override
    public Map<class_1887, Integer> getDefaultEnchantments() {
        return Map.of(class_1893.field_9115, 5);
    }

    @Override
    public int barCount(class_1799 stack) {
        return 1;
    }

    @Override
    public boolean allowVanillaDurabilityBarRendering(@Nullable class_1657 player, class_1799 stack) {
        if (player == null || this.isReservingSlot(stack) || player.method_5998(player.method_6058()) != stack) {
            return true;
        }
        return !player.method_6115();
    }

    @Override
    public ExtendedItemBarProvider.BarSignature getSignature(@Nullable class_1657 player, @NotNull class_1799 stack, int index) {
        if (player == null || this.isReservingSlot(stack) || !player.method_6115()) {
            return ExtendedItemBarProvider.PASS;
        }
        class_1799 activeStack = player.method_5998(player.method_6058());
        if (activeStack != stack) {
            return ExtendedItemBarProvider.PASS;
        }
        int progress = Math.round(class_3532.method_37166((float)0.0f, (float)13.0f, (float)((float)player.method_6048() / 60.0f)));
        return new ExtendedItemBarProvider.BarSignature(2, 13, 13, progress, 1, -1184512, 2, -16777216);
    }

    @Override
    public SlotBackgroundEffectProvider.SlotEffect backgroundType(@Nullable class_1657 player, class_1799 stack) {
        return SlotBackgroundEffectProvider.SlotEffect.BORDER_FADE;
    }

    @Override
    public int getBackgroundColor(@Nullable class_1657 player, class_1799 stack, float tickDelta) {
        return -1184512;
    }
}

