/*
 * Decompiled with CFR 0.152.
 */
package de.dafuqs.spectrum.items.tools;

import de.dafuqs.spectrum.api.item.SplitDamageItem;
import de.dafuqs.spectrum.cca.MiscPlayerDataComponent;
import de.dafuqs.spectrum.items.tools.ParryingSwordItem;
import de.dafuqs.spectrum.registries.SpectrumDamageTypes;
import de.dafuqs.spectrum.registries.SpectrumSoundEvents;
import net.minecraft.class_1282;
import net.minecraft.class_1291;
import net.minecraft.class_1293;
import net.minecraft.class_1294;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1832;
import net.minecraft.class_1890;
import net.minecraft.class_1893;
import net.minecraft.class_1937;
import net.minecraft.class_243;
import net.minecraft.class_3532;
import net.minecraft.class_8103;

public class LightGreatswordItem
extends ParryingSwordItem
implements SplitDamageItem {
    private final int barColor;

    public LightGreatswordItem(class_1832 material, int attackDamage, float attackSpeed, float crit, float reach, int barColor, class_1792.class_1793 settings) {
        super(material, attackDamage, attackSpeed, crit, reach, settings);
        this.barColor = barColor;
    }

    @Override
    public float getBlockingMultiplier(class_1282 source, class_1799 stack, class_1309 entity, int usedTime) {
        if (source.method_48789(class_8103.field_42247)) {
            return 0.0f;
        }
        if (this.canPerfectParry(stack, entity, usedTime)) {
            return 0.05f;
        }
        if (this.canBluffParry(stack, entity, usedTime)) {
            return 0.2f;
        }
        if ((float)usedTime <= (float)this.getMaxShieldingTime(entity, stack) / 2.0f) {
            return 0.5f;
        }
        return 0.75f;
    }

    @Override
    public void method_7840(class_1799 stack, class_1937 world, class_1309 user, int remainingUseTicks) {
        super.method_7840(stack, world, user, remainingUseTicks);
        if (!(user instanceof class_1657)) {
            return;
        }
        class_1657 player = (class_1657)user;
        int maxShieldTime = this.getMaxShieldingTime(user, stack);
        if (!player.method_24828() && maxShieldTime - remainingUseTicks > 5) {
            float yaw = player.method_36454();
            float pitch = player.method_36455();
            int roll = player.method_6003();
            float f = -class_3532.method_15374((float)(yaw * ((float)Math.PI / 180))) * class_3532.method_15362((float)(pitch * ((float)Math.PI / 180)));
            float g = -class_3532.method_15374((float)((pitch + (float)roll) * ((float)Math.PI / 180)));
            float h = class_3532.method_15362((float)(yaw * ((float)Math.PI / 180))) * class_3532.method_15362((float)(pitch * ((float)Math.PI / 180)));
            float chargeStrength = Math.min((float)(maxShieldTime - remainingUseTicks) / (float)maxShieldTime + 0.2f, 1.0f);
            player.method_45319(new class_243((double)f, (double)g, (double)h).method_1029().method_1021((double)(this.getLungeSpeed() * chargeStrength)));
            player.method_5783(SpectrumSoundEvents.LUNGE, 2.0f, 0.8f + player.method_6051().method_43057() * 0.2f);
            MiscPlayerDataComponent.get(player).initiateLungeState();
        }
    }

    public float getLungeSpeed() {
        return 1.0f;
    }

    @Override
    public int getBarColor() {
        return this.barColor;
    }

    protected void applyLungeHitEffects(class_1799 stack, class_1309 target, class_1309 attacker) {
        if (target.method_5864() == class_1299.field_6091) {
            return;
        }
        class_1291 effect = target.method_5999() ? class_1294.field_5924 : class_1294.field_5899;
        int sharpness = class_1890.method_8222((class_1799)stack).getOrDefault(class_1893.field_9118, 0);
        target.method_6092(new class_1293(effect, 20 * (5 + sharpness), 1));
    }

    public boolean method_7873(class_1799 stack, class_1309 target, class_1309 attacker) {
        class_1657 player;
        if (attacker instanceof class_1657 && MiscPlayerDataComponent.get(player = (class_1657)attacker).isLunging()) {
            MiscPlayerDataComponent.get(player).endLunge();
            target.method_5783(SpectrumSoundEvents.LUNGE_CRIT, 1.0f, 0.9f + target.method_6051().method_43057() * 0.2f);
            this.applyLungeHitEffects(stack, target, attacker);
        }
        return super.method_7873(stack, target, attacker);
    }

    @Override
    public SplitDamageItem.DamageComposition getDamageComposition(class_1309 attacker, class_1309 target, class_1799 stack, float damage) {
        class_1657 player;
        SplitDamageItem.DamageComposition composition = new SplitDamageItem.DamageComposition();
        class_1282 source = composition.getPlayerOrEntity(attacker);
        if (attacker instanceof class_1657 && MiscPlayerDataComponent.get(player = (class_1657)attacker).isLunging()) {
            source = SpectrumDamageTypes.impaling(player.method_37908(), (class_1297)player);
        }
        composition.add(source, damage);
        return composition;
    }
}

