/*
 * Decompiled with CFR 0.152.
 */
package de.dafuqs.spectrum.loot;

import de.dafuqs.spectrum.SpectrumCommon;
import de.dafuqs.spectrum.api.energy.color.InkColor;
import de.dafuqs.spectrum.api.energy.color.InkColors;
import de.dafuqs.spectrum.blocks.mob_head.SpectrumSkullBlock;
import de.dafuqs.spectrum.blocks.mob_head.SpectrumSkullType;
import de.dafuqs.spectrum.compat.gofish.GoFishCompat;
import de.dafuqs.spectrum.entity.type_specific_predicates.LizardPredicate;
import de.dafuqs.spectrum.entity.type_specific_predicates.ShulkerPredicate;
import de.dafuqs.spectrum.loot.conditions.RandomChanceWithTreasureHunterLootCondition;
import de.dafuqs.spectrum.registries.SpectrumBlocks;
import de.dafuqs.spectrum.registries.SpectrumItems;
import de.dafuqs.spectrum.registries.SpectrumLootTables;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import net.fabricmc.fabric.api.loot.v2.LootTableEvents;
import net.minecraft.class_1438;
import net.minecraft.class_1453;
import net.minecraft.class_1767;
import net.minecraft.class_1792;
import net.minecraft.class_1802;
import net.minecraft.class_1935;
import net.minecraft.class_2048;
import net.minecraft.class_215;
import net.minecraft.class_2960;
import net.minecraft.class_4019;
import net.minecraft.class_44;
import net.minecraft.class_47;
import net.minecraft.class_4965;
import net.minecraft.class_55;
import net.minecraft.class_5658;
import net.minecraft.class_5762;
import net.minecraft.class_7106;
import net.minecraft.class_7376;
import net.minecraft.class_77;
import net.minecraft.class_79;
import net.minecraft.class_83;
import org.jetbrains.annotations.Nullable;

public class SpectrumLootPoolModifiers {
    private static final Map<class_2960, TreasureHunterDropDefinition> treasureHunterLootPools = new HashMap<class_2960, TreasureHunterDropDefinition>(){
        {
            this.put(new class_2960("entities/creeper"), new TreasureHunterDropDefinition(class_1802.field_8681, 0.02f));
            this.put(new class_2960("entities/skeleton"), new TreasureHunterDropDefinition(class_1802.field_8398, 0.02f));
            this.put(new class_2960("entities/wither_skeleton"), new TreasureHunterDropDefinition(class_1802.field_8791, 0.1f));
            this.put(new class_2960("entities/zombie"), new TreasureHunterDropDefinition(class_1802.field_8470, 0.02f));
            this.put(new class_2960("entities/piglin"), new TreasureHunterDropDefinition(class_1802.field_41304, 0.02f));
            this.put(new class_2960("entities/piglin_brute"), new TreasureHunterDropDefinition(class_1802.field_41304, 0.02f));
            this.put(new class_2960("entities/ender_dragon"), new TreasureHunterDropDefinition(class_1802.field_8712, 0.35f));
            this.put(new class_2960("entities/sheep"), new TreasureHunterDropDefinition(SpectrumSkullBlock.getBlock(SpectrumSkullType.SHEEP).get().method_8389(), 0.02f));
            this.put(new class_2960("entities/bat"), new TreasureHunterDropDefinition(SpectrumSkullBlock.getBlock(SpectrumSkullType.BAT).get().method_8389(), 0.02f));
            this.put(new class_2960("entities/blaze"), new TreasureHunterDropDefinition(SpectrumSkullBlock.getBlock(SpectrumSkullType.BLAZE).get().method_8389(), 0.02f));
            this.put(new class_2960("entities/cat"), new TreasureHunterDropDefinition(SpectrumSkullBlock.getBlock(SpectrumSkullType.CAT).get().method_8389(), 0.02f));
            this.put(new class_2960("entities/cave_spider"), new TreasureHunterDropDefinition(SpectrumSkullBlock.getBlock(SpectrumSkullType.CAVE_SPIDER).get().method_8389(), 0.02f));
            this.put(new class_2960("entities/chicken"), new TreasureHunterDropDefinition(SpectrumSkullBlock.getBlock(SpectrumSkullType.CHICKEN).get().method_8389(), 0.02f));
            this.put(new class_2960("entities/cow"), new TreasureHunterDropDefinition(SpectrumSkullBlock.getBlock(SpectrumSkullType.COW).get().method_8389(), 0.02f));
            this.put(new class_2960("entities/donkey"), new TreasureHunterDropDefinition(SpectrumSkullBlock.getBlock(SpectrumSkullType.DONKEY).get().method_8389(), 0.02f));
            this.put(new class_2960("entities/drowned"), new TreasureHunterDropDefinition(SpectrumSkullBlock.getBlock(SpectrumSkullType.DROWNED).get().method_8389(), 0.02f));
            this.put(new class_2960("entities/elder_guardian"), new TreasureHunterDropDefinition(SpectrumSkullBlock.getBlock(SpectrumSkullType.ELDER_GUARDIAN).get().method_8389(), 0.02f));
            this.put(new class_2960("entities/enderman"), new TreasureHunterDropDefinition(SpectrumSkullBlock.getBlock(SpectrumSkullType.ENDERMAN).get().method_8389(), 0.02f));
            this.put(new class_2960("entities/endermite"), new TreasureHunterDropDefinition(SpectrumSkullBlock.getBlock(SpectrumSkullType.ENDERMITE).get().method_8389(), 0.02f));
            this.put(new class_2960("entities/evoker"), new TreasureHunterDropDefinition(SpectrumSkullBlock.getBlock(SpectrumSkullType.EVOKER).get().method_8389(), 0.02f));
            this.put(new class_2960("entities/ghast"), new TreasureHunterDropDefinition(SpectrumSkullBlock.getBlock(SpectrumSkullType.GHAST).get().method_8389(), 0.02f));
            this.put(new class_2960("entities/guardian"), new TreasureHunterDropDefinition(SpectrumSkullBlock.getBlock(SpectrumSkullType.GUARDIAN).get().method_8389(), 0.02f));
            this.put(new class_2960("entities/hoglin"), new TreasureHunterDropDefinition(SpectrumSkullBlock.getBlock(SpectrumSkullType.HOGLIN).get().method_8389(), 0.02f));
            this.put(new class_2960("entities/horse"), new TreasureHunterDropDefinition(SpectrumSkullBlock.getBlock(SpectrumSkullType.HORSE).get().method_8389(), 0.02f));
            this.put(new class_2960("entities/husk"), new TreasureHunterDropDefinition(SpectrumSkullBlock.getBlock(SpectrumSkullType.HUSK).get().method_8389(), 0.02f));
            this.put(new class_2960("entities/illusioner"), new TreasureHunterDropDefinition(SpectrumSkullBlock.getBlock(SpectrumSkullType.ILLUSIONER).get().method_8389(), 0.02f));
            this.put(new class_2960("entities/iron_golem"), new TreasureHunterDropDefinition(SpectrumSkullBlock.getBlock(SpectrumSkullType.IRON_GOLEM).get().method_8389(), 0.02f));
            this.put(new class_2960("entities/llama"), new TreasureHunterDropDefinition(SpectrumSkullBlock.getBlock(SpectrumSkullType.LLAMA).get().method_8389(), 0.02f));
            this.put(new class_2960("entities/magma_cube"), new TreasureHunterDropDefinition(SpectrumSkullBlock.getBlock(SpectrumSkullType.MAGMA_CUBE).get().method_8389(), 0.02f));
            this.put(new class_2960("entities/mule"), new TreasureHunterDropDefinition(SpectrumSkullBlock.getBlock(SpectrumSkullType.MULE).get().method_8389(), 0.02f));
            this.put(new class_2960("entities/ocelot"), new TreasureHunterDropDefinition(SpectrumSkullBlock.getBlock(SpectrumSkullType.OCELOT).get().method_8389(), 0.02f));
            this.put(new class_2960("entities/panda"), new TreasureHunterDropDefinition(SpectrumSkullBlock.getBlock(SpectrumSkullType.PANDA).get().method_8389(), 0.02f));
            this.put(new class_2960("entities/phantom"), new TreasureHunterDropDefinition(SpectrumSkullBlock.getBlock(SpectrumSkullType.PHANTOM).get().method_8389(), 0.02f));
            this.put(new class_2960("entities/pig"), new TreasureHunterDropDefinition(SpectrumSkullBlock.getBlock(SpectrumSkullType.PIG).get().method_8389(), 0.02f));
            this.put(new class_2960("entities/polar_bear"), new TreasureHunterDropDefinition(SpectrumSkullBlock.getBlock(SpectrumSkullType.POLAR_BEAR).get().method_8389(), 0.02f));
            this.put(new class_2960("entities/pufferfish"), new TreasureHunterDropDefinition(SpectrumSkullBlock.getBlock(SpectrumSkullType.PUFFERFISH).get().method_8389(), 0.02f));
            this.put(new class_2960("entities/rabbit"), new TreasureHunterDropDefinition(SpectrumSkullBlock.getBlock(SpectrumSkullType.RABBIT).get().method_8389(), 0.02f));
            this.put(new class_2960("entities/ravager"), new TreasureHunterDropDefinition(SpectrumSkullBlock.getBlock(SpectrumSkullType.RAVAGER).get().method_8389(), 0.02f));
            this.put(new class_2960("entities/salmon"), new TreasureHunterDropDefinition(SpectrumSkullBlock.getBlock(SpectrumSkullType.SALMON).get().method_8389(), 0.02f));
            this.put(new class_2960("entities/silverfish"), new TreasureHunterDropDefinition(SpectrumSkullBlock.getBlock(SpectrumSkullType.SILVERFISH).get().method_8389(), 0.02f));
            this.put(new class_2960("entities/slime"), new TreasureHunterDropDefinition(SpectrumSkullBlock.getBlock(SpectrumSkullType.SLIME).get().method_8389(), 0.02f));
            this.put(new class_2960("entities/snow_golem"), new TreasureHunterDropDefinition(SpectrumSkullBlock.getBlock(SpectrumSkullType.SNOW_GOLEM).get().method_8389(), 0.02f));
            this.put(new class_2960("entities/spider"), new TreasureHunterDropDefinition(SpectrumSkullBlock.getBlock(SpectrumSkullType.SPIDER).get().method_8389(), 0.02f));
            this.put(new class_2960("entities/squid"), new TreasureHunterDropDefinition(SpectrumSkullBlock.getBlock(SpectrumSkullType.SQUID).get().method_8389(), 0.02f));
            this.put(new class_2960("entities/stray"), new TreasureHunterDropDefinition(SpectrumSkullBlock.getBlock(SpectrumSkullType.STRAY).get().method_8389(), 0.02f));
            this.put(new class_2960("entities/strider"), new TreasureHunterDropDefinition(SpectrumSkullBlock.getBlock(SpectrumSkullType.STRIDER).get().method_8389(), 0.02f));
            this.put(new class_2960("entities/trader_llama"), new TreasureHunterDropDefinition(SpectrumSkullBlock.getBlock(SpectrumSkullType.LLAMA).get().method_8389(), 0.02f));
            this.put(new class_2960("entities/turtle"), new TreasureHunterDropDefinition(SpectrumSkullBlock.getBlock(SpectrumSkullType.TURTLE).get().method_8389(), 0.02f));
            this.put(new class_2960("entities/vex"), new TreasureHunterDropDefinition(SpectrumSkullBlock.getBlock(SpectrumSkullType.VEX).get().method_8389(), 0.02f));
            this.put(new class_2960("entities/villager"), new TreasureHunterDropDefinition(SpectrumSkullBlock.getBlock(SpectrumSkullType.VILLAGER).get().method_8389(), 0.02f));
            this.put(new class_2960("entities/vindicator"), new TreasureHunterDropDefinition(SpectrumSkullBlock.getBlock(SpectrumSkullType.VINDICATOR).get().method_8389(), 0.02f));
            this.put(new class_2960("entities/wandering_trader"), new TreasureHunterDropDefinition(SpectrumSkullBlock.getBlock(SpectrumSkullType.WANDERING_TRADER).get().method_8389(), 0.02f));
            this.put(new class_2960("entities/witch"), new TreasureHunterDropDefinition(SpectrumSkullBlock.getBlock(SpectrumSkullType.WITCH).get().method_8389(), 0.02f));
            this.put(new class_2960("entities/wither"), new TreasureHunterDropDefinition(SpectrumSkullBlock.getBlock(SpectrumSkullType.WITHER).get().method_8389(), 0.15f));
            this.put(new class_2960("entities/wolf"), new TreasureHunterDropDefinition(SpectrumSkullBlock.getBlock(SpectrumSkullType.WOLF).get().method_8389(), 0.02f));
            this.put(new class_2960("entities/zoglin"), new TreasureHunterDropDefinition(SpectrumSkullBlock.getBlock(SpectrumSkullType.ZOGLIN).get().method_8389(), 0.02f));
            this.put(new class_2960("entities/zombie_villager"), new TreasureHunterDropDefinition(SpectrumSkullBlock.getBlock(SpectrumSkullType.ZOMBIE_VILLAGER).get().method_8389(), 0.02f));
            this.put(new class_2960("entities/zombified_piglin"), new TreasureHunterDropDefinition(SpectrumSkullBlock.getBlock(SpectrumSkullType.ZOMBIFIED_PIGLIN).get().method_8389(), 0.02f));
            this.put(new class_2960("entities/bee"), new TreasureHunterDropDefinition(SpectrumSkullBlock.getBlock(SpectrumSkullType.BEE).get().method_8389(), 0.02f));
            this.put(new class_2960("entities/tropical_fish"), new TreasureHunterDropDefinition(SpectrumSkullBlock.getBlock(SpectrumSkullType.TROPICAL_FISH).get().method_8389(), 0.02f));
            this.put(new class_2960("entities/goat"), new TreasureHunterDropDefinition(SpectrumSkullBlock.getBlock(SpectrumSkullType.GOAT).get().method_8389(), 0.02f));
            this.put(new class_2960("entities/glow_squid"), new TreasureHunterDropDefinition(SpectrumSkullBlock.getBlock(SpectrumSkullType.GLOW_SQUID).get().method_8389(), 0.02f));
            this.put(new class_2960("entities/warden"), new TreasureHunterDropDefinition(SpectrumSkullBlock.getBlock(SpectrumSkullType.WARDEN).get().method_8389(), 0.2f));
            this.put(new class_2960("entities/tadpole"), new TreasureHunterDropDefinition(SpectrumSkullBlock.getBlock(SpectrumSkullType.TADPOLE).get().method_8389(), 0.02f));
            this.put(new class_2960("entities/allay"), new TreasureHunterDropDefinition(SpectrumSkullBlock.getBlock(SpectrumSkullType.ALLAY).get().method_8389(), 0.02f));
            this.put(new class_2960("entities/camel"), new TreasureHunterDropDefinition(SpectrumSkullBlock.getBlock(SpectrumSkullType.CAMEL).get().method_8389(), 0.02f));
            this.put(new class_2960("entities/sniffer"), new TreasureHunterDropDefinition(SpectrumSkullBlock.getBlock(SpectrumSkullType.SNIFFER).get().method_8389(), 0.02f));
            this.put(new class_2960("entities/skeleton_horse"), new TreasureHunterDropDefinition(SpectrumSkullBlock.getBlock(SpectrumSkullType.SKELETON_HORSE).get().method_8389(), 0.02f));
            this.put(new class_2960("entities/zombie_horse"), new TreasureHunterDropDefinition(SpectrumSkullBlock.getBlock(SpectrumSkullType.ZOMBIE_HORSE).get().method_8389(), 0.02f));
            this.put(new class_2960("entities/dolphin"), new TreasureHunterDropDefinition(SpectrumSkullBlock.getBlock(SpectrumSkullType.DOLPHIN).get().method_8389(), 0.02f));
            this.put(new class_2960("entities/pillager"), new TreasureHunterDropDefinition(SpectrumSkullBlock.getBlock(SpectrumSkullType.PILLAGER).get().method_8389(), 0.02f));
            this.put(new class_2960("spectrum:entities/egg_laying_wooly_pig"), new TreasureHunterDropDefinition(SpectrumSkullBlock.getBlock(SpectrumSkullType.EGG_LAYING_WOOLY_PIG).get().method_8389(), 0.1f));
            this.put(new class_2960("spectrum:entities/kindling"), new TreasureHunterDropDefinition(SpectrumSkullBlock.getBlock(SpectrumSkullType.KINDLING).get().method_8389(), 0.1f));
            this.put(new class_2960("spectrum:entities/preservation_turret"), new TreasureHunterDropDefinition(SpectrumSkullBlock.getBlock(SpectrumSkullType.PRESERVATION_TURRET).get().method_8389(), 0.1f));
            this.put(new class_2960("spectrum:entities/monstrosity"), new TreasureHunterDropDefinition(SpectrumSkullBlock.getBlock(SpectrumSkullType.MONSTROSITY).get().method_8389(), 0.1f));
            this.put(new class_2960("spectrum:entities/eraser"), new TreasureHunterDropDefinition(SpectrumSkullBlock.getBlock(SpectrumSkullType.ERASER).get().method_8389(), 0.1f));
        }
    };

    public static void setup() {
        LootTableEvents.MODIFY.register((resourceManager, lootManager, id, tableBuilder, source) -> {
            if (treasureHunterLootPools.containsKey(id)) {
                TreasureHunterDropDefinition treasureHunterDropDefinition = treasureHunterLootPools.get(id);
                tableBuilder.pool(SpectrumLootPoolModifiers.getLootPool(treasureHunterDropDefinition));
            } else if (id.equals((Object)new class_2960("archaeology/ocean_ruin_cold")) || id.equals((Object)new class_2960("archaeology/ocean_ruin_warm")) || id.equals((Object)new class_2960("archaeology/trail_ruins_common")) || id.equals((Object)new class_2960("archaeology/desert_pyramid")) || id.equals((Object)new class_2960("archaeology/desert_well"))) {
                tableBuilder.modifyPools(builder -> builder.method_351((class_79.class_80)class_77.method_411((class_1935)SpectrumItems.NIGHTDEW_SPROUT).method_437(2).method_436(-1)));
            } else if (id.equals((Object)new class_2960("archaeology/trail_ruins_rare"))) {
                tableBuilder.modifyPools(builder -> builder.method_351((class_79.class_80)class_77.method_411((class_1935)SpectrumItems.NIGHTDEW_SPROUT).method_437(3).method_436(-1)));
            } else if (id.equals((Object)new class_2960("gameplay/sniffer_digging"))) {
                tableBuilder.modifyPools(builder -> {
                    builder.method_351((class_79.class_80)class_77.method_411((class_1935)SpectrumBlocks.WEEPING_GALA_SPRIG).method_437(1));
                    builder.method_351((class_79.class_80)class_77.method_411((class_1935)SpectrumItems.NIGHTDEW_SPROUT).method_437(2));
                });
            } else if (id.equals((Object)new class_2960("entities/fox"))) {
                tableBuilder.pool(SpectrumLootPoolModifiers.getFoxLootPool(class_4019.class_4039.field_17996, SpectrumSkullBlock.getBlock(SpectrumSkullType.FOX).get().method_8389(), 0.02f));
                tableBuilder.pool(SpectrumLootPoolModifiers.getFoxLootPool(class_4019.class_4039.field_17997, SpectrumSkullBlock.getBlock(SpectrumSkullType.FOX_ARCTIC).get().method_8389(), 0.02f));
            } else if (id.equals((Object)new class_2960("entities/mooshroom"))) {
                tableBuilder.pool(SpectrumLootPoolModifiers.getMooshroomLootPool(class_1438.class_4053.field_18110, SpectrumSkullBlock.getBlock(SpectrumSkullType.MOOSHROOM_BROWN).get().method_8389(), 0.02f));
                tableBuilder.pool(SpectrumLootPoolModifiers.getMooshroomLootPool(class_1438.class_4053.field_18109, SpectrumSkullBlock.getBlock(SpectrumSkullType.MOOSHROOM_RED).get().method_8389(), 0.02f));
            } else if (id.equals((Object)new class_2960("entities/shulker"))) {
                tableBuilder.pool(SpectrumLootPoolModifiers.getShulkerLootPool(null, SpectrumSkullBlock.getBlock(SpectrumSkullType.SHULKER).get().method_8389(), 0.05f));
                tableBuilder.pool(SpectrumLootPoolModifiers.getShulkerLootPool(class_1767.field_7963, SpectrumSkullBlock.getBlock(SpectrumSkullType.SHULKER_BLACK).get().method_8389(), 0.05f));
                tableBuilder.pool(SpectrumLootPoolModifiers.getShulkerLootPool(class_1767.field_7966, SpectrumSkullBlock.getBlock(SpectrumSkullType.SHULKER_BLUE).get().method_8389(), 0.05f));
                tableBuilder.pool(SpectrumLootPoolModifiers.getShulkerLootPool(class_1767.field_7957, SpectrumSkullBlock.getBlock(SpectrumSkullType.SHULKER_BROWN).get().method_8389(), 0.05f));
                tableBuilder.pool(SpectrumLootPoolModifiers.getShulkerLootPool(class_1767.field_7955, SpectrumSkullBlock.getBlock(SpectrumSkullType.SHULKER_CYAN).get().method_8389(), 0.05f));
                tableBuilder.pool(SpectrumLootPoolModifiers.getShulkerLootPool(class_1767.field_7944, SpectrumSkullBlock.getBlock(SpectrumSkullType.SHULKER_GRAY).get().method_8389(), 0.05f));
                tableBuilder.pool(SpectrumLootPoolModifiers.getShulkerLootPool(class_1767.field_7942, SpectrumSkullBlock.getBlock(SpectrumSkullType.SHULKER_GREEN).get().method_8389(), 0.05f));
                tableBuilder.pool(SpectrumLootPoolModifiers.getShulkerLootPool(class_1767.field_7951, SpectrumSkullBlock.getBlock(SpectrumSkullType.SHULKER_LIGHT_BLUE).get().method_8389(), 0.05f));
                tableBuilder.pool(SpectrumLootPoolModifiers.getShulkerLootPool(class_1767.field_7967, SpectrumSkullBlock.getBlock(SpectrumSkullType.SHULKER_LIGHT_GRAY).get().method_8389(), 0.05f));
                tableBuilder.pool(SpectrumLootPoolModifiers.getShulkerLootPool(class_1767.field_7961, SpectrumSkullBlock.getBlock(SpectrumSkullType.SHULKER_LIME).get().method_8389(), 0.05f));
                tableBuilder.pool(SpectrumLootPoolModifiers.getShulkerLootPool(class_1767.field_7958, SpectrumSkullBlock.getBlock(SpectrumSkullType.SHULKER_MAGENTA).get().method_8389(), 0.05f));
                tableBuilder.pool(SpectrumLootPoolModifiers.getShulkerLootPool(class_1767.field_7946, SpectrumSkullBlock.getBlock(SpectrumSkullType.SHULKER_ORANGE).get().method_8389(), 0.05f));
                tableBuilder.pool(SpectrumLootPoolModifiers.getShulkerLootPool(class_1767.field_7954, SpectrumSkullBlock.getBlock(SpectrumSkullType.SHULKER_PINK).get().method_8389(), 0.05f));
                tableBuilder.pool(SpectrumLootPoolModifiers.getShulkerLootPool(class_1767.field_7945, SpectrumSkullBlock.getBlock(SpectrumSkullType.SHULKER_PURPLE).get().method_8389(), 0.05f));
                tableBuilder.pool(SpectrumLootPoolModifiers.getShulkerLootPool(class_1767.field_7964, SpectrumSkullBlock.getBlock(SpectrumSkullType.SHULKER_RED).get().method_8389(), 0.05f));
                tableBuilder.pool(SpectrumLootPoolModifiers.getShulkerLootPool(class_1767.field_7952, SpectrumSkullBlock.getBlock(SpectrumSkullType.SHULKER_WHITE).get().method_8389(), 0.05f));
                tableBuilder.pool(SpectrumLootPoolModifiers.getShulkerLootPool(class_1767.field_7947, SpectrumSkullBlock.getBlock(SpectrumSkullType.SHULKER_YELLOW).get().method_8389(), 0.05f));
            } else if (id.equals((Object)SpectrumCommon.locate("entities/lizard"))) {
                tableBuilder.pool(SpectrumLootPoolModifiers.getLizardLootPool(InkColors.BLACK, SpectrumSkullBlock.getBlock(SpectrumSkullType.LIZARD_BLACK).get().method_8389(), 0.05f));
                tableBuilder.pool(SpectrumLootPoolModifiers.getLizardLootPool(InkColors.BLUE, SpectrumSkullBlock.getBlock(SpectrumSkullType.LIZARD_BLUE).get().method_8389(), 0.05f));
                tableBuilder.pool(SpectrumLootPoolModifiers.getLizardLootPool(InkColors.BROWN, SpectrumSkullBlock.getBlock(SpectrumSkullType.LIZARD_BROWN).get().method_8389(), 0.05f));
                tableBuilder.pool(SpectrumLootPoolModifiers.getLizardLootPool(InkColors.CYAN, SpectrumSkullBlock.getBlock(SpectrumSkullType.LIZARD_CYAN).get().method_8389(), 0.05f));
                tableBuilder.pool(SpectrumLootPoolModifiers.getLizardLootPool(InkColors.GRAY, SpectrumSkullBlock.getBlock(SpectrumSkullType.LIZARD_GRAY).get().method_8389(), 0.05f));
                tableBuilder.pool(SpectrumLootPoolModifiers.getLizardLootPool(InkColors.GREEN, SpectrumSkullBlock.getBlock(SpectrumSkullType.LIZARD_GREEN).get().method_8389(), 0.05f));
                tableBuilder.pool(SpectrumLootPoolModifiers.getLizardLootPool(InkColors.LIGHT_BLUE, SpectrumSkullBlock.getBlock(SpectrumSkullType.LIZARD_LIGHT_BLUE).get().method_8389(), 0.05f));
                tableBuilder.pool(SpectrumLootPoolModifiers.getLizardLootPool(InkColors.LIGHT_GRAY, SpectrumSkullBlock.getBlock(SpectrumSkullType.LIZARD_LIGHT_GRAY).get().method_8389(), 0.05f));
                tableBuilder.pool(SpectrumLootPoolModifiers.getLizardLootPool(InkColors.LIME, SpectrumSkullBlock.getBlock(SpectrumSkullType.LIZARD_LIME).get().method_8389(), 0.05f));
                tableBuilder.pool(SpectrumLootPoolModifiers.getLizardLootPool(InkColors.MAGENTA, SpectrumSkullBlock.getBlock(SpectrumSkullType.LIZARD_MAGENTA).get().method_8389(), 0.05f));
                tableBuilder.pool(SpectrumLootPoolModifiers.getLizardLootPool(InkColors.ORANGE, SpectrumSkullBlock.getBlock(SpectrumSkullType.LIZARD_ORANGE).get().method_8389(), 0.05f));
                tableBuilder.pool(SpectrumLootPoolModifiers.getLizardLootPool(InkColors.PINK, SpectrumSkullBlock.getBlock(SpectrumSkullType.LIZARD_PINK).get().method_8389(), 0.05f));
                tableBuilder.pool(SpectrumLootPoolModifiers.getLizardLootPool(InkColors.PURPLE, SpectrumSkullBlock.getBlock(SpectrumSkullType.LIZARD_PURPLE).get().method_8389(), 0.05f));
                tableBuilder.pool(SpectrumLootPoolModifiers.getLizardLootPool(InkColors.RED, SpectrumSkullBlock.getBlock(SpectrumSkullType.LIZARD_RED).get().method_8389(), 0.05f));
                tableBuilder.pool(SpectrumLootPoolModifiers.getLizardLootPool(InkColors.WHITE, SpectrumSkullBlock.getBlock(SpectrumSkullType.LIZARD_WHITE).get().method_8389(), 0.05f));
                tableBuilder.pool(SpectrumLootPoolModifiers.getLizardLootPool(InkColors.YELLOW, SpectrumSkullBlock.getBlock(SpectrumSkullType.LIZARD_YELLOW).get().method_8389(), 0.05f));
            } else if (id.equals((Object)new class_2960("entities/axolotl"))) {
                tableBuilder.pool(SpectrumLootPoolModifiers.getAxolotlLootPool(class_5762.class_5767.field_28345, SpectrumSkullBlock.getBlock(SpectrumSkullType.AXOLOTL_BLUE).get().method_8389(), 0.02f));
                tableBuilder.pool(SpectrumLootPoolModifiers.getAxolotlLootPool(class_5762.class_5767.field_28344, SpectrumSkullBlock.getBlock(SpectrumSkullType.AXOLOTL_CYAN).get().method_8389(), 0.02f));
                tableBuilder.pool(SpectrumLootPoolModifiers.getAxolotlLootPool(class_5762.class_5767.field_28343, SpectrumSkullBlock.getBlock(SpectrumSkullType.AXOLOTL_GOLD).get().method_8389(), 0.02f));
                tableBuilder.pool(SpectrumLootPoolModifiers.getAxolotlLootPool(class_5762.class_5767.field_28341, SpectrumSkullBlock.getBlock(SpectrumSkullType.AXOLOTL_LEUCISTIC).get().method_8389(), 0.02f));
                tableBuilder.pool(SpectrumLootPoolModifiers.getAxolotlLootPool(class_5762.class_5767.field_28342, SpectrumSkullBlock.getBlock(SpectrumSkullType.AXOLOTL_WILD).get().method_8389(), 0.02f));
            } else if (id.equals((Object)new class_2960("entities/parrot"))) {
                tableBuilder.pool(SpectrumLootPoolModifiers.getParrotLootPool(class_1453.class_7989.field_41550, SpectrumSkullBlock.getBlock(SpectrumSkullType.PARROT_RED).get().method_8389(), 0.02f));
                tableBuilder.pool(SpectrumLootPoolModifiers.getParrotLootPool(class_1453.class_7989.field_41551, SpectrumSkullBlock.getBlock(SpectrumSkullType.PARROT_BLUE).get().method_8389(), 0.02f));
                tableBuilder.pool(SpectrumLootPoolModifiers.getParrotLootPool(class_1453.class_7989.field_41552, SpectrumSkullBlock.getBlock(SpectrumSkullType.PARROT_GREEN).get().method_8389(), 0.02f));
                tableBuilder.pool(SpectrumLootPoolModifiers.getParrotLootPool(class_1453.class_7989.field_41553, SpectrumSkullBlock.getBlock(SpectrumSkullType.PARROT_CYAN).get().method_8389(), 0.02f));
                tableBuilder.pool(SpectrumLootPoolModifiers.getParrotLootPool(class_1453.class_7989.field_41554, SpectrumSkullBlock.getBlock(SpectrumSkullType.PARROT_GRAY).get().method_8389(), 0.02f));
            } else if (id.equals((Object)new class_2960("entities/frog"))) {
                tableBuilder.pool(SpectrumLootPoolModifiers.getFrogLootPool(class_7106.field_37462, SpectrumSkullBlock.getBlock(SpectrumSkullType.FROG_TEMPERATE).get().method_8389(), 0.02f));
                tableBuilder.pool(SpectrumLootPoolModifiers.getFrogLootPool(class_7106.field_37464, SpectrumSkullBlock.getBlock(SpectrumSkullType.FROG_COLD).get().method_8389(), 0.02f));
                tableBuilder.pool(SpectrumLootPoolModifiers.getFrogLootPool(class_7106.field_37463, SpectrumSkullBlock.getBlock(SpectrumSkullType.FROG_WARM).get().method_8389(), 0.02f));
            } else if (GoFishCompat.isLoaded()) {
                if (id.equals((Object)SpectrumLootTables.LAVA_FISHING)) {
                    tableBuilder.modifyPools(builder -> builder.with(class_83.method_428((class_2960)GoFishCompat.NETHER_FISH_LOOT_TABLE_ID).method_437(80).method_436(-1).method_419()));
                    tableBuilder.modifyPools(builder -> builder.method_351(class_83.method_428((class_2960)GoFishCompat.NETHER_CRATES_LOOT_TABLE_ID).method_437(5).method_436(2).method_421(class_215.method_27865((class_47.class_50)class_47.class_50.field_935, (class_2048)new class_2048.class_2049().method_43094((class_7376)class_4965.method_26095((boolean)true)).method_8920()))));
                } else if (id.equals((Object)SpectrumLootTables.END_FISHING)) {
                    tableBuilder.modifyPools(builder -> builder.with(class_83.method_428((class_2960)GoFishCompat.END_FISH_LOOT_TABLE_ID).method_437(90).method_436(-1).method_419()));
                    tableBuilder.modifyPools(builder -> builder.method_351(class_83.method_428((class_2960)GoFishCompat.END_CRATES_LOOT_TABLE_ID).method_437(5).method_436(2).method_421(class_215.method_27865((class_47.class_50)class_47.class_50.field_935, (class_2048)new class_2048.class_2049().method_43094((class_7376)class_4965.method_26095((boolean)true)).method_8920()))));
                } else if (id.equals((Object)SpectrumLootTables.DEEPER_DOWN_FISHING)) {
                    tableBuilder.modifyPools(builder -> builder.method_351(class_83.method_428((class_2960)GoFishCompat.DEFAULT_CRATES_LOOT_TABLE_ID).method_437(5).method_436(2).method_421(class_215.method_27865((class_47.class_50)class_47.class_50.field_935, (class_2048)new class_2048.class_2049().method_43094((class_7376)class_4965.method_26095((boolean)true)).method_8920()))));
                } else if (id.equals((Object)SpectrumLootTables.MUD_FISHING)) {
                    tableBuilder.modifyPools(builder -> builder.method_351(class_83.method_428((class_2960)GoFishCompat.DEFAULT_CRATES_LOOT_TABLE_ID).method_437(5).method_436(2).method_421(class_215.method_27865((class_47.class_50)class_47.class_50.field_935, (class_2048)new class_2048.class_2049().method_43094((class_7376)class_4965.method_26095((boolean)true)).method_8920()))));
                } else if (id.equals((Object)SpectrumLootTables.LIQUID_CRYSTAL_FISHING)) {
                    tableBuilder.modifyPools(builder -> builder.method_351(class_83.method_428((class_2960)GoFishCompat.DEFAULT_CRATES_LOOT_TABLE_ID).method_437(5).method_436(2).method_421(class_215.method_27865((class_47.class_50)class_47.class_50.field_935, (class_2048)new class_2048.class_2049().method_43094((class_7376)class_4965.method_26095((boolean)true)).method_8920()))));
                } else if (id.equals((Object)SpectrumLootTables.MIDNIGHT_SOLUTION_FISHING)) {
                    tableBuilder.modifyPools(builder -> builder.method_351(class_83.method_428((class_2960)GoFishCompat.DEFAULT_CRATES_LOOT_TABLE_ID).method_437(5).method_436(2).method_421(class_215.method_27865((class_47.class_50)class_47.class_50.field_935, (class_2048)new class_2048.class_2049().method_43094((class_7376)class_4965.method_26095((boolean)true)).method_8920()))));
                }
            }
        });
    }

    private static class_55 getLootPool(TreasureHunterDropDefinition treasureHunterDropDefinition) {
        class_1792 dropItem = treasureHunterDropDefinition.skullItem;
        float chance = treasureHunterDropDefinition.treasureHunterMultiplier;
        return new class_55.class_56().method_352((class_5658)class_44.method_32448((float)1.0f)).conditionally(RandomChanceWithTreasureHunterLootCondition.builder(chance, dropItem).build()).with(class_77.method_411((class_1935)dropItem).method_419()).method_355();
    }

    private static class_55 getFoxLootPool(class_4019.class_4039 foxType, class_1792 item, float chance) {
        return new class_55.class_56().method_352((class_5658)class_44.method_32448((float)1.0f)).conditionally(RandomChanceWithTreasureHunterLootCondition.builder(chance, item).build()).conditionally(class_215.method_27865((class_47.class_50)class_47.class_50.field_935, (class_2048)class_2048.class_2049.method_8916().method_43094(class_7376.class_7378.field_41536.method_43117((Object)foxType)).method_8920()).build()).with(class_77.method_411((class_1935)item).method_419()).method_355();
    }

    private static class_55 getMooshroomLootPool(class_1438.class_4053 mooshroomType, class_1792 item, float chance) {
        return new class_55.class_56().method_352((class_5658)class_44.method_32448((float)1.0f)).conditionally(RandomChanceWithTreasureHunterLootCondition.builder(chance, item).build()).conditionally(class_215.method_27865((class_47.class_50)class_47.class_50.field_935, (class_2048)class_2048.class_2049.method_8916().method_43094(class_7376.class_7378.field_41537.method_43117((Object)mooshroomType)).method_8920()).build()).with(class_77.method_411((class_1935)item).method_419()).method_355();
    }

    private static class_55 getShulkerLootPool(@Nullable class_1767 dyeColor, class_1792 item, float chance) {
        Optional<Object> c = dyeColor == null ? Optional.empty() : Optional.of(dyeColor);
        return new class_55.class_56().method_352((class_5658)class_44.method_32448((float)1.0f)).conditionally(RandomChanceWithTreasureHunterLootCondition.builder(chance, item).build()).conditionally(class_215.method_27865((class_47.class_50)class_47.class_50.field_935, (class_2048)class_2048.class_2049.method_8916().method_43094((class_7376)ShulkerPredicate.of(c.orElse(null))).method_8920()).build()).with(class_77.method_411((class_1935)item).method_419()).method_355();
    }

    private static class_55 getLizardLootPool(InkColor linkColor, class_1792 item, float chance) {
        return new class_55.class_56().method_352((class_5658)class_44.method_32448((float)1.0f)).conditionally(RandomChanceWithTreasureHunterLootCondition.builder(chance, item).build()).conditionally(class_215.method_27865((class_47.class_50)class_47.class_50.field_935, (class_2048)class_2048.class_2049.method_8916().method_43094((class_7376)LizardPredicate.of(Optional.of(linkColor), Optional.empty(), Optional.empty())).method_8920()).build()).with(class_77.method_411((class_1935)item).method_419()).method_355();
    }

    private static class_55 getAxolotlLootPool(class_5762.class_5767 variant, class_1792 item, float chance) {
        return new class_55.class_56().method_352((class_5658)class_44.method_32448((float)1.0f)).conditionally(RandomChanceWithTreasureHunterLootCondition.builder(chance, item).build()).conditionally(class_215.method_27865((class_47.class_50)class_47.class_50.field_935, (class_2048)class_2048.class_2049.method_8916().method_43094(class_7376.class_7378.field_41534.method_43117((Object)variant)).method_8920()).build()).with(class_77.method_411((class_1935)item).method_419()).method_355();
    }

    private static class_55 getFrogLootPool(class_7106 variant, class_1792 item, float chance) {
        return new class_55.class_56().method_352((class_5658)class_44.method_32448((float)1.0f)).conditionally(RandomChanceWithTreasureHunterLootCondition.builder(chance, item).build()).conditionally(class_215.method_27865((class_47.class_50)class_47.class_50.field_935, (class_2048)class_2048.class_2049.method_8916().method_43094(class_7376.method_43096((class_7106)variant)).method_8920()).build()).with(class_77.method_411((class_1935)item).method_419()).method_355();
    }

    private static class_55 getParrotLootPool(class_1453.class_7989 variant, class_1792 item, float chance) {
        return new class_55.class_56().method_352((class_5658)class_44.method_32448((float)1.0f)).conditionally(RandomChanceWithTreasureHunterLootCondition.builder(chance, item).build()).conditionally(class_215.method_27865((class_47.class_50)class_47.class_50.field_935, (class_2048)class_2048.class_2049.method_8916().method_43094(class_7376.class_7378.field_41543.method_43117((Object)variant)).method_8920()).build()).with(class_77.method_411((class_1935)item).method_419()).method_355();
    }

    private static class TreasureHunterDropDefinition {
        public final class_1792 skullItem;
        public final float treasureHunterMultiplier;

        public TreasureHunterDropDefinition(class_1792 skullItem, float trophyHunterChance) {
            this.skullItem = skullItem;
            this.treasureHunterMultiplier = trophyHunterChance;
        }
    }
}

