/*
 * Decompiled with CFR 0.152.
 */
package de.dafuqs.spectrum.loot.functions;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSerializationContext;
import de.dafuqs.spectrum.SpectrumCommon;
import de.dafuqs.spectrum.helpers.TimeHelper;
import de.dafuqs.spectrum.loot.SpectrumLootFunctionTypes;
import de.dafuqs.spectrum.mixin.accessors.BiomeAccessor;
import de.dafuqs.spectrum.recipe.titration_barrel.FermentationData;
import de.dafuqs.spectrum.recipe.titration_barrel.TitrationBarrelRecipe;
import java.util.Optional;
import net.minecraft.class_120;
import net.minecraft.class_1799;
import net.minecraft.class_181;
import net.minecraft.class_1959;
import net.minecraft.class_2338;
import net.minecraft.class_2374;
import net.minecraft.class_2960;
import net.minecraft.class_3518;
import net.minecraft.class_47;
import net.minecraft.class_5339;
import net.minecraft.class_5341;
import net.minecraft.class_5658;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FermentRandomlyLootFunction
extends class_120 {
    @Nullable
    final class_2960 fermentationRecipeIdentifier;
    @Nullable
    final FermentationData fermentationData;
    final class_5658 daysFermented;
    final class_5658 thickness;

    public FermentRandomlyLootFunction(class_5341[] conditions, @NotNull class_2960 fermentationRecipeIdentifier, class_5658 daysFermented, class_5658 thickness) {
        super(conditions);
        this.fermentationRecipeIdentifier = fermentationRecipeIdentifier;
        this.fermentationData = null;
        this.daysFermented = daysFermented;
        this.thickness = thickness;
    }

    public FermentRandomlyLootFunction(class_5341[] conditions, @NotNull FermentationData fermentationData, class_5658 daysFermented, class_5658 thickness) {
        super(conditions);
        this.fermentationRecipeIdentifier = null;
        this.fermentationData = fermentationData;
        this.daysFermented = daysFermented;
        this.thickness = thickness;
    }

    public class_5339 method_29321() {
        return SpectrumLootFunctionTypes.FERMENT_RANDOMLY;
    }

    public class_1799 method_522(class_1799 stack, class_47 context) {
        FermentationData fermentationData = null;
        if (this.fermentationRecipeIdentifier != null) {
            Object t;
            Optional recipe = SpectrumCommon.minecraftServer.method_3772().method_8130(this.fermentationRecipeIdentifier);
            if (recipe.isPresent() && (t = recipe.get()) instanceof TitrationBarrelRecipe) {
                TitrationBarrelRecipe titrationBarrelRecipe = (TitrationBarrelRecipe)t;
                fermentationData = titrationBarrelRecipe.getFermentationData();
            } else {
                SpectrumCommon.logError("A 'spectrum:ferment_randomly' loot function has set an invalid 'fermentation_recipe_id': " + String.valueOf(this.fermentationRecipeIdentifier) + " It has to match an existing Titration Barrel recipe.");
            }
        }
        if (fermentationData == null) {
            fermentationData = this.fermentationData;
        }
        if (fermentationData != null) {
            class_2338 pos = class_2338.method_49638((class_2374)((class_2374)context.method_296(class_181.field_24424)));
            class_1959 biome = (class_1959)context.method_299().method_23753(pos).comp_349();
            float downfall = ((BiomeAccessor)biome).getWeather().comp_846();
            return TitrationBarrelRecipe.getFermentedStack(fermentationData, this.thickness.method_366(context), TimeHelper.secondsFromMinecraftDays(this.daysFermented.method_366(context)), downfall, stack);
        }
        return stack;
    }

    public static class_120.class_121<?> builder(FermentationData fermentationData, class_5658 daysFermented, class_5658 thickness) {
        return FermentRandomlyLootFunction.method_520(conditions -> new FermentRandomlyLootFunction((class_5341[])conditions, fermentationData, daysFermented, thickness));
    }

    public static class_120.class_121<?> builder(class_2960 fermentationRecipeIdentifier, class_5658 daysFermented, class_5658 thickness) {
        return FermentRandomlyLootFunction.method_520(conditions -> new FermentRandomlyLootFunction((class_5341[])conditions, fermentationRecipeIdentifier, daysFermented, thickness));
    }

    public static class Serializer
    extends class_120.class_123<FermentRandomlyLootFunction> {
        private static final String FERMENTATION_RECIPE_ID_STRING = "fermentation_recipe_id";
        private static final String FERMENTATION_DATA_STRING = "fermentation_data";
        private static final String DAYS_FERMENTED_STRING = "days_fermented";
        private static final String THICKNESS_STRING = "thickness";

        public void toJson(JsonObject jsonObject, FermentRandomlyLootFunction lootFunction, JsonSerializationContext jsonSerializationContext) {
            super.method_529(jsonObject, (class_120)lootFunction, jsonSerializationContext);
            if (lootFunction.fermentationRecipeIdentifier != null) {
                jsonObject.addProperty(FERMENTATION_RECIPE_ID_STRING, lootFunction.fermentationRecipeIdentifier.toString());
            } else {
                jsonObject.add(FERMENTATION_DATA_STRING, (JsonElement)lootFunction.fermentationData.toJson());
            }
            jsonObject.add(DAYS_FERMENTED_STRING, jsonSerializationContext.serialize((Object)lootFunction.daysFermented));
            jsonObject.add(THICKNESS_STRING, jsonSerializationContext.serialize((Object)lootFunction.thickness));
        }

        public FermentRandomlyLootFunction fromJson(JsonObject jsonObject, JsonDeserializationContext jsonDeserializationContext, class_5341[] lootConditions) {
            class_5658 daysFermented = (class_5658)class_3518.method_15272((JsonObject)jsonObject, (String)DAYS_FERMENTED_STRING, (JsonDeserializationContext)jsonDeserializationContext, class_5658.class);
            class_5658 thickness = (class_5658)class_3518.method_15272((JsonObject)jsonObject, (String)THICKNESS_STRING, (JsonDeserializationContext)jsonDeserializationContext, class_5658.class);
            if (jsonObject.has(FERMENTATION_RECIPE_ID_STRING)) {
                class_2960 fermentationRecipeIdentifier = class_2960.method_12829((String)jsonObject.get(FERMENTATION_RECIPE_ID_STRING).getAsString());
                return new FermentRandomlyLootFunction(lootConditions, fermentationRecipeIdentifier, daysFermented, thickness);
            }
            if (jsonObject.has(FERMENTATION_DATA_STRING)) {
                FermentationData fermentationData = FermentationData.fromJson(jsonObject.get(FERMENTATION_DATA_STRING).getAsJsonObject());
                return new FermentRandomlyLootFunction(lootConditions, fermentationData, daysFermented, thickness);
            }
            throw new JsonParseException("A 'ferment_randomly' loot function always needs to have either 'fermentation_data' or 'fermentation_recipe_id' set.");
        }
    }
}

