/*
 * Decompiled with CFR 0.152.
 */
package de.dafuqs.spectrum.mixin.client;

import de.dafuqs.spectrum.SpectrumCommon;
import de.dafuqs.spectrum.api.status_effect.Incurable;
import de.dafuqs.spectrum.registries.SpectrumStatusEffectTags;
import de.dafuqs.spectrum.registries.SpectrumStatusEffects;
import net.minecraft.class_1291;
import net.minecraft.class_1293;
import net.minecraft.class_2960;
import net.minecraft.class_485;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyArg;
import org.spongepowered.asm.mixin.injection.ModifyVariable;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={class_485.class})
public class AbstractInventoryScreenMixin {
    @Unique
    private static final class_2960 INCURABLE_EFFECT_BACKGROUNDS = SpectrumCommon.locate("textures/gui/incurable_effect_backgrounds.png");
    @Unique
    private static final class_2960 NIGHT_EFFECT_BACKGROUNDS = SpectrumCommon.locate("textures/gui/night_alchemy_effect_backgrounds.png");
    @Unique
    private static final class_2960 DIVINITY_EFFECT_BACKGROUNDS = SpectrumCommon.locate("textures/gui/divinity_effect_backgrounds.png");
    @Unique
    private class_1293 effect;

    @ModifyVariable(method={"drawStatusEffectBackgrounds"}, at=@At(value="STORE"))
    public class_1293 storeEffect(class_1293 value) {
        this.effect = value;
        return value;
    }

    @ModifyArg(method={"drawStatusEffectBackgrounds"}, at=@At(value="INVOKE", target="Lnet/minecraft/client/gui/DrawContext;drawTexture(Lnet/minecraft/util/Identifier;IIIIII)V", ordinal=0))
    public class_2960 modifyWideBackground(class_2960 texture) {
        return AbstractInventoryScreenMixin.getTexture(texture, this.effect);
    }

    @ModifyArg(method={"drawStatusEffectBackgrounds"}, at=@At(value="INVOKE", target="Lnet/minecraft/client/gui/DrawContext;drawTexture(Lnet/minecraft/util/Identifier;IIIIII)V", ordinal=1))
    public class_2960 modifyBackground(class_2960 texture) {
        return AbstractInventoryScreenMixin.getTexture(texture, this.effect);
    }

    @Inject(method={"drawStatusEffectBackgrounds"}, at={@At(value="TAIL")})
    private void nullifyEffect(CallbackInfo ci) {
        this.effect = null;
    }

    @Unique
    private static class_2960 getTexture(class_2960 texture, class_1293 effect) {
        class_1291 type = effect.method_5579();
        if (type == SpectrumStatusEffects.DIVINITY) {
            return DIVINITY_EFFECT_BACKGROUNDS;
        }
        if (Incurable.isIncurable(effect) && type != SpectrumStatusEffects.ETERNAL_SLUMBER && type != SpectrumStatusEffects.FATAL_SLUMBER) {
            return INCURABLE_EFFECT_BACKGROUNDS;
        }
        if (SpectrumStatusEffectTags.isIn(SpectrumStatusEffectTags.NIGHT_ALCHEMY, type)) {
            return NIGHT_EFFECT_BACKGROUNDS;
        }
        return texture;
    }
}

