/*
 * Decompiled with CFR 0.152.
 */
package de.dafuqs.spectrum.networking;

import de.dafuqs.spectrum.api.block.PedestalVariant;
import de.dafuqs.spectrum.api.color.ColorRegistry;
import de.dafuqs.spectrum.api.energy.InkStorage;
import de.dafuqs.spectrum.api.energy.color.InkColor;
import de.dafuqs.spectrum.api.item.ExperienceStorageItem;
import de.dafuqs.spectrum.blocks.chests.BlackHoleChestBlockEntity;
import de.dafuqs.spectrum.blocks.chests.CompactingChestBlockEntity;
import de.dafuqs.spectrum.blocks.chests.RestockingChestBlockEntity;
import de.dafuqs.spectrum.blocks.memory.MemoryBlockEntity;
import de.dafuqs.spectrum.blocks.pastel_network.network.PastelTransmission;
import de.dafuqs.spectrum.blocks.pastel_network.network.ServerPastelNetwork;
import de.dafuqs.spectrum.blocks.pastel_network.nodes.PastelNodeBlockEntity;
import de.dafuqs.spectrum.blocks.pedestal.PedestalBlockEntity;
import de.dafuqs.spectrum.entity.entity.ShootingStarEntity;
import de.dafuqs.spectrum.networking.SpectrumS2CPackets;
import de.dafuqs.spectrum.particle.VectorPattern;
import de.dafuqs.spectrum.particle.effect.ColoredTransmission;
import de.dafuqs.spectrum.particle.effect.TypedTransmission;
import de.dafuqs.spectrum.spells.MoonstoneStrike;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Predicate;
import net.fabricmc.fabric.api.networking.v1.PacketByteBufs;
import net.fabricmc.fabric.api.networking.v1.PlayerLookup;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.minecraft.class_1299;
import net.minecraft.class_1657;
import net.minecraft.class_1767;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2374;
import net.minecraft.class_2382;
import net.minecraft.class_2394;
import net.minecraft.class_243;
import net.minecraft.class_2540;
import net.minecraft.class_2586;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3414;
import net.minecraft.class_3545;
import net.minecraft.class_7923;
import net.minecraft.server.MinecraftServer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SpectrumS2CPacketSender {
    public static void playParticleWithRandomOffsetAndVelocity(class_3218 world, class_243 position, @NotNull class_2394 particleEffect, int amount, class_243 randomOffset, class_243 randomVelocity) {
        class_2540 buf = PacketByteBufs.create();
        buf.writeDouble(position.field_1352);
        buf.writeDouble(position.field_1351);
        buf.writeDouble(position.field_1350);
        buf.method_10812(class_7923.field_41180.method_10221((Object)particleEffect.method_10295()));
        buf.writeInt(amount);
        buf.writeDouble(randomOffset.field_1352);
        buf.writeDouble(randomOffset.field_1351);
        buf.writeDouble(randomOffset.field_1350);
        buf.writeDouble(randomVelocity.field_1352);
        buf.writeDouble(randomVelocity.field_1351);
        buf.writeDouble(randomVelocity.field_1350);
        for (class_3222 player : PlayerLookup.tracking((class_3218)world, (class_2338)class_2338.method_49638((class_2374)position))) {
            ServerPlayNetworking.send((class_3222)player, (class_2960)SpectrumS2CPackets.PLAY_PARTICLE_WITH_RANDOM_OFFSET_AND_VELOCITY, (class_2540)buf);
        }
    }

    public static void playParticles(class_3218 world, class_2338 position, class_2394 particleEffect, int amount) {
        SpectrumS2CPacketSender.playParticleWithExactVelocity(world, class_243.method_24953((class_2382)position), particleEffect, amount, class_243.field_1353);
    }

    public static void playParticleWithExactVelocity(class_3218 world, @NotNull class_243 position, @NotNull class_2394 particleEffect, int amount, @NotNull class_243 velocity) {
        class_2540 buf = PacketByteBufs.create();
        buf.writeDouble(position.field_1352);
        buf.writeDouble(position.field_1351);
        buf.writeDouble(position.field_1350);
        buf.method_10812(class_7923.field_41180.method_10221((Object)particleEffect.method_10295()));
        buf.writeInt(amount);
        buf.writeDouble(velocity.field_1352);
        buf.writeDouble(velocity.field_1351);
        buf.writeDouble(velocity.field_1350);
        for (class_3222 player : PlayerLookup.tracking((class_3218)world, (class_2338)class_2338.method_49638((class_2374)position))) {
            ServerPlayNetworking.send((class_3222)player, (class_2960)SpectrumS2CPackets.PLAY_PARTICLE_WITH_EXACT_VELOCITY, (class_2540)buf);
        }
    }

    public static void playParticleWithPatternAndVelocity(@Nullable class_1657 notThisPlayerEntity, class_3218 world, @NotNull class_243 position, @NotNull class_2394 particleEffect, @NotNull VectorPattern pattern, double velocity) {
        class_2540 buf = PacketByteBufs.create();
        buf.writeDouble(position.field_1352);
        buf.writeDouble(position.field_1351);
        buf.writeDouble(position.field_1350);
        buf.method_10812(class_7923.field_41180.method_10221((Object)particleEffect.method_10295()));
        buf.writeInt(pattern.ordinal());
        buf.writeDouble(velocity);
        for (class_3222 player : PlayerLookup.tracking((class_3218)world, (class_2338)class_2338.method_49638((class_2374)position))) {
            if (player.equals((Object)notThisPlayerEntity)) continue;
            ServerPlayNetworking.send((class_3222)player, (class_2960)SpectrumS2CPackets.PLAY_PARTICLE_PACKET_WITH_PATTERN_AND_VELOCITY_ID, (class_2540)buf);
        }
    }

    public static void playParticleAroundBlockSides(class_3218 world, int quantity, @NotNull class_243 position, @NotNull class_243 velocity, @NotNull class_2394 particleEffect, Predicate<class_3222> sendCheck, class_2350 ... sides) {
        class_2540 buf = PacketByteBufs.create();
        buf.writeInt(quantity);
        buf.writeDouble(position.field_1352);
        buf.writeDouble(position.field_1351);
        buf.writeDouble(position.field_1350);
        buf.writeDouble(velocity.field_1352);
        buf.writeDouble(velocity.field_1351);
        buf.writeDouble(velocity.field_1350);
        buf.method_10812(class_7923.field_41180.method_10221((Object)particleEffect.method_10295()));
        buf.writeInt(sides.length);
        for (class_2350 side : sides) {
            buf.writeInt(side.ordinal());
        }
        for (class_3222 player : PlayerLookup.tracking((class_3218)world, (class_2338)class_2338.method_49638((class_2374)position))) {
            if (!sendCheck.test(player)) continue;
            ServerPlayNetworking.send((class_3222)player, (class_2960)SpectrumS2CPackets.PLAY_PARTICLE_AROUND_BLOCK_SIDES, (class_2540)buf);
        }
    }

    public static void playParticleAroundArea(class_3218 world, int quantity, double yOffset, boolean triangular, boolean solidSpawns, @NotNull class_243 scale, @NotNull class_243 position, @NotNull class_243 velocity, @NotNull class_2394 particleEffect, Predicate<class_3222> sendCheck) {
        class_2540 buf = PacketByteBufs.create();
        buf.writeInt(quantity);
        buf.writeDouble(yOffset);
        buf.writeBoolean(triangular);
        buf.writeBoolean(solidSpawns);
        buf.writeDouble(scale.field_1352);
        buf.writeDouble(scale.field_1351);
        buf.writeDouble(scale.field_1350);
        buf.writeDouble(position.field_1352);
        buf.writeDouble(position.field_1351);
        buf.writeDouble(position.field_1350);
        buf.writeDouble(velocity.field_1352);
        buf.writeDouble(velocity.field_1351);
        buf.writeDouble(velocity.field_1350);
        buf.method_10812(class_7923.field_41180.method_10221((Object)particleEffect.method_10295()));
        for (class_3222 player : PlayerLookup.tracking((class_3218)world, (class_2338)class_2338.method_49638((class_2374)position))) {
            if (!sendCheck.test(player)) continue;
            ServerPlayNetworking.send((class_3222)player, (class_2960)SpectrumS2CPackets.PLAY_PARTICLE_AROUND_AREA, (class_2540)buf);
        }
    }

    public static void sendPlayPedestalCraftingFinishedParticle(class_1937 world, class_2338 blockPos, class_1799 itemStack) {
        class_2540 buf = PacketByteBufs.create();
        buf.method_10807(blockPos);
        buf.method_10793(itemStack);
        for (class_3222 player : PlayerLookup.tracking((class_3218)((class_3218)world), (class_2338)blockPos)) {
            ServerPlayNetworking.send((class_3222)player, (class_2960)SpectrumS2CPackets.PLAY_PEDESTAL_CRAFTING_FINISHED_PARTICLE_PACKET_ID, (class_2540)buf);
        }
    }

    public static void sendPlayFusionCraftingInProgressParticles(class_1937 world, class_2338 blockPos) {
        class_2540 buf = PacketByteBufs.create();
        buf.method_10807(blockPos);
        for (class_3222 player : PlayerLookup.tracking((class_3218)((class_3218)world), (class_2338)blockPos)) {
            ServerPlayNetworking.send((class_3222)player, (class_2960)SpectrumS2CPackets.PLAY_FUSION_CRAFTING_IN_PROGRESS_PARTICLE_PACKET_ID, (class_2540)buf);
        }
    }

    public static void sendPlayFusionCraftingFinishedParticles(class_1937 world, class_2338 blockPos, @NotNull class_1799 itemStack) {
        Optional<class_1767> optionalItemColor = ColorRegistry.ITEM_COLORS.getMapping(itemStack.method_7909());
        class_2540 buf = PacketByteBufs.create();
        buf.method_10807(blockPos);
        if (optionalItemColor.isPresent()) {
            buf.writeInt(optionalItemColor.get().ordinal());
        } else {
            buf.writeInt(class_1767.field_7967.ordinal());
        }
        for (class_3222 player : PlayerLookup.tracking((class_3218)((class_3218)world), (class_2338)blockPos)) {
            ServerPlayNetworking.send((class_3222)player, (class_2960)SpectrumS2CPackets.PLAY_FUSION_CRAFTING_FINISHED_PARTICLE_PACKET_ID, (class_2540)buf);
        }
    }

    public static void sendPastelTransmissionParticle(ServerPastelNetwork network, int travelTime, @NotNull PastelTransmission transmission) {
        class_2540 buf = PacketByteBufs.create();
        buf.method_10797(network.getUUID());
        buf.writeInt(travelTime);
        PastelTransmission.writeToBuf(buf, transmission);
        for (class_3222 player : PlayerLookup.tracking((class_3218)((class_3218)network.getWorld()), (class_2338)transmission.getStartPos())) {
            ServerPlayNetworking.send((class_3222)player, (class_2960)SpectrumS2CPackets.PASTEL_TRANSMISSION, (class_2540)buf);
        }
    }

    public static void playColorTransmissionParticle(class_3218 world, @NotNull ColoredTransmission transfer) {
        class_2338 blockPos = class_2338.method_49638((class_2374)transfer.getOrigin());
        class_2540 buf = PacketByteBufs.create();
        ColoredTransmission.writeToBuf(buf, transfer);
        for (class_3222 player : PlayerLookup.tracking((class_3218)world, (class_2338)blockPos)) {
            ServerPlayNetworking.send((class_3222)player, (class_2960)SpectrumS2CPackets.COLOR_TRANSMISSION, (class_2540)buf);
        }
    }

    public static void playTransmissionParticle(class_3218 world, @NotNull TypedTransmission transmission) {
        class_2338 blockPos = class_2338.method_49638((class_2374)transmission.getOrigin());
        class_2540 buf = PacketByteBufs.create();
        TypedTransmission.writeToBuf(buf, transmission);
        for (class_3222 player : PlayerLookup.tracking((class_3218)world, (class_2338)blockPos)) {
            ServerPlayNetworking.send((class_3222)player, (class_2960)SpectrumS2CPackets.TYPED_TRANSMISSION, (class_2540)buf);
        }
    }

    public static void sendPlayBlockBoundSoundInstance(class_3414 soundEvent, @NotNull class_3218 world, class_2338 blockPos, int maxDurationTicks) {
        class_2540 buf = PacketByteBufs.create();
        buf.method_10812(class_7923.field_41172.method_10221((Object)soundEvent));
        buf.method_10812(class_7923.field_41175.method_10221((Object)world.method_8320(blockPos).method_26204()));
        buf.method_10807(blockPos);
        buf.writeInt(maxDurationTicks);
        for (class_3222 player : PlayerLookup.tracking((class_3218)world, (class_2338)blockPos)) {
            ServerPlayNetworking.send((class_3222)player, (class_2960)SpectrumS2CPackets.PLAY_BLOCK_BOUND_SOUND_INSTANCE, (class_2540)buf);
        }
    }

    public static void sendPlayTakeOffBeltSoundInstance(class_3222 playerEntity) {
        class_2540 buf = PacketByteBufs.create();
        ServerPlayNetworking.send((class_3222)playerEntity, (class_2960)SpectrumS2CPackets.PLAY_TAKE_OFF_BELT_SOUND_INSTANCE, (class_2540)buf);
    }

    public static void sendCancelBlockBoundSoundInstance(@NotNull class_3218 world, class_2338 blockPos) {
        class_2540 buf = PacketByteBufs.create();
        buf.method_10812(new class_2960("stop"));
        buf.method_10812(class_7923.field_41175.method_10221((Object)world.method_8320(blockPos).method_26204()));
        buf.method_10807(blockPos);
        buf.writeInt(1);
        for (class_3222 player : PlayerLookup.tracking((class_3218)world, (class_2338)blockPos)) {
            ServerPlayNetworking.send((class_3222)player, (class_2960)SpectrumS2CPackets.PLAY_BLOCK_BOUND_SOUND_INSTANCE, (class_2540)buf);
        }
    }

    public static void spawnPedestalUpgradeParticles(class_1937 world, class_2338 blockPos, @NotNull PedestalVariant newPedestalVariant) {
        class_2540 buf = PacketByteBufs.create();
        buf.method_10807(blockPos);
        buf.writeInt(newPedestalVariant.getRecipeTier().ordinal());
        for (class_3222 player : PlayerLookup.tracking((class_3218)((class_3218)world), (class_2338)blockPos)) {
            ServerPlayNetworking.send((class_3222)player, (class_2960)SpectrumS2CPackets.PLAY_PEDESTAL_UPGRADED_PARTICLE_PACKET_ID, (class_2540)buf);
        }
    }

    public static void spawnPedestalStartCraftingParticles(PedestalBlockEntity pedestalBlockEntity) {
        class_2540 buf = PacketByteBufs.create();
        buf.method_10807(pedestalBlockEntity.method_11016());
        for (class_3222 player : PlayerLookup.tracking((class_3218)((class_3218)pedestalBlockEntity.method_10997()), (class_2338)pedestalBlockEntity.method_11016())) {
            ServerPlayNetworking.send((class_3222)player, (class_2960)SpectrumS2CPackets.PLAY_PEDESTAL_START_CRAFTING_PARTICLE_PACKET_ID, (class_2540)buf);
        }
    }

    public static void sendPlayShootingStarParticles(@NotNull ShootingStarEntity shootingStarEntity) {
        class_2540 buf = PacketByteBufs.create();
        buf.writeDouble(shootingStarEntity.method_19538().method_10216());
        buf.writeDouble(shootingStarEntity.method_19538().method_10214());
        buf.writeDouble(shootingStarEntity.method_19538().method_10215());
        buf.writeInt(shootingStarEntity.getShootingStarType().ordinal());
        for (class_3222 player : PlayerLookup.tracking((class_3218)((class_3218)shootingStarEntity.method_37908()), (class_2338)shootingStarEntity.method_24515())) {
            ServerPlayNetworking.send((class_3222)player, (class_2960)SpectrumS2CPackets.PLAY_SHOOTING_STAR_PARTICLES, (class_2540)buf);
        }
    }

    public static void startSkyLerping(@NotNull class_3218 serverWorld, int additionalTime) {
        class_2540 buf = PacketByteBufs.create();
        long timeOfDay = serverWorld.method_8532();
        buf.writeLong(timeOfDay);
        buf.writeLong(timeOfDay + (long)additionalTime);
        for (class_3222 player : serverWorld.method_18456()) {
            ServerPlayNetworking.send((class_3222)player, (class_2960)SpectrumS2CPackets.START_SKY_LERPING, (class_2540)buf);
        }
    }

    public static void playMemoryManifestingParticles(class_3218 serverWorld, @NotNull class_2338 blockPos, class_1299<?> entityType, int amount) {
        class_3545<Integer, Integer> eggColors = MemoryBlockEntity.getEggColorsForEntity(entityType);
        class_2540 buf = PacketByteBufs.create();
        buf.method_10807(blockPos);
        buf.writeInt(((Integer)eggColors.method_15442()).intValue());
        buf.writeInt(((Integer)eggColors.method_15441()).intValue());
        buf.writeInt(amount);
        for (class_3222 player : PlayerLookup.tracking((class_3218)serverWorld, (class_2338)blockPos)) {
            ServerPlayNetworking.send((class_3222)player, (class_2960)SpectrumS2CPackets.PLAY_MEMORY_MANIFESTING_PARTICLES, (class_2540)buf);
        }
    }

    public static void sendBossBarUpdatePropertiesPacket(UUID uuid, boolean serpentMusic, Collection<class_3222> players) {
        class_2540 buf = PacketByteBufs.create();
        buf.method_10797(uuid);
        buf.writeBoolean(serpentMusic);
        for (class_3222 player : players) {
            ServerPlayNetworking.send((class_3222)player, (class_2960)SpectrumS2CPackets.UPDATE_BOSS_BAR, (class_2540)buf);
        }
    }

    public static void updateBlockEntityInk(class_2338 pos, InkStorage inkStorage, class_3222 player) {
        class_2540 buf = PacketByteBufs.create();
        buf.method_10807(pos);
        buf.writeLong(inkStorage.getCurrentTotal());
        Map<InkColor, Long> colors = inkStorage.getEnergy();
        buf.writeInt(colors.size());
        for (Map.Entry<InkColor, Long> color : colors.entrySet()) {
            buf.method_10812(color.getKey().getID());
            buf.writeLong(color.getValue().longValue());
        }
        ServerPlayNetworking.send((class_3222)player, (class_2960)SpectrumS2CPackets.UPDATE_BLOCK_ENTITY_INK, (class_2540)buf);
    }

    public static void sendInkColorSelected(@Nullable InkColor color, class_3222 player) {
        class_2540 packetByteBuf = PacketByteBufs.create();
        if (color == null) {
            packetByteBuf.writeBoolean(false);
        } else {
            packetByteBuf.writeBoolean(true);
            packetByteBuf.method_10812(color.getID());
        }
        ServerPlayNetworking.send((class_3222)player, (class_2960)SpectrumS2CPackets.INK_COLOR_SELECTED, (class_2540)packetByteBuf);
    }

    public static void playPresentOpeningParticles(class_3218 serverWorld, class_2338 pos, Map<class_1767, Integer> colors) {
        class_2540 packetByteBuf = PacketByteBufs.create();
        packetByteBuf.method_10807(pos);
        packetByteBuf.writeInt(colors.size());
        for (Map.Entry<class_1767, Integer> color : colors.entrySet()) {
            packetByteBuf.writeByte(color.getKey().method_7789());
            packetByteBuf.writeByte(color.getValue().intValue());
        }
        for (class_3222 player : PlayerLookup.tracking((class_3218)serverWorld, (class_2338)pos)) {
            ServerPlayNetworking.send((class_3222)player, (class_2960)SpectrumS2CPackets.PLAY_PRESENT_OPENING_PARTICLES, (class_2540)packetByteBuf);
        }
    }

    public static void playAscensionAppliedEffects(class_3222 player) {
        ServerPlayNetworking.send((class_3222)player, (class_2960)SpectrumS2CPackets.PLAY_ASCENSION_APPLIED_EFFECTS, (class_2540)PacketByteBufs.create());
    }

    public static void playDivinityAppliedEffects(class_3222 player) {
        class_2540 buf = PacketByteBufs.create();
        buf.writeInt(player.method_5628());
        ServerPlayNetworking.send((class_3222)player, (class_2960)SpectrumS2CPackets.PLAY_DIVINITY_APPLIED_EFFECTS, (class_2540)buf);
    }

    public static void sendMoonstoneBlast(class_3218 serverWorld, MoonstoneStrike moonstoneStrike) {
        for (class_3222 player : PlayerLookup.tracking((class_3218)serverWorld, (class_2338)class_2338.method_49637((double)moonstoneStrike.getX(), (double)moonstoneStrike.getY(), (double)moonstoneStrike.getZ()))) {
            class_243 playerVelocity = moonstoneStrike.getAffectedPlayers().getOrDefault(player, class_243.field_1353);
            class_2540 buf = PacketByteBufs.create();
            buf.writeDouble(moonstoneStrike.getX());
            buf.writeDouble(moonstoneStrike.getY());
            buf.writeDouble(moonstoneStrike.getZ());
            buf.writeFloat(moonstoneStrike.getPower());
            buf.writeFloat(moonstoneStrike.getKnockbackMod());
            buf.writeDouble(playerVelocity.field_1352);
            buf.writeDouble(playerVelocity.field_1351);
            buf.writeDouble(playerVelocity.field_1350);
            ServerPlayNetworking.send((class_3222)player, (class_2960)SpectrumS2CPackets.MOONSTONE_BLAST, (class_2540)buf);
        }
    }

    public static void sendMentalPresenceSync(class_3222 player, double value) {
        class_2540 buf = PacketByteBufs.create();
        buf.writeDouble(value);
        ServerPlayNetworking.send((class_3222)player, (class_2960)SpectrumS2CPackets.SYNC_MENTAL_PRESENCE, (class_2540)buf);
    }

    public static void sendCompactingChestStatusUpdate(CompactingChestBlockEntity chest) {
        class_2540 buf = PacketByteBufs.create();
        buf.method_10807(chest.method_11016());
        buf.writeBoolean(chest.hasToCraft());
        for (class_3222 player : PlayerLookup.tracking((class_2586)chest)) {
            ServerPlayNetworking.send((class_3222)player, (class_2960)SpectrumS2CPackets.COMPACTING_CHEST_STATUS_UPDATE, (class_2540)buf);
        }
    }

    public static void sendRestockingChestStatusUpdate(RestockingChestBlockEntity chest) {
        class_2540 buf = PacketByteBufs.create();
        buf.method_10807(chest.method_11016());
        buf.writeBoolean(chest.isFullServer());
        buf.writeBoolean(chest.hasValidRecipes());
        buf.writeInt(chest.getRecipeOutputs().size());
        for (class_1799 recipeOutput : chest.getRecipeOutputs()) {
            buf.method_10793(recipeOutput);
        }
        for (class_3222 player : PlayerLookup.tracking((class_2586)chest)) {
            ServerPlayNetworking.send((class_3222)player, (class_2960)SpectrumS2CPackets.RESTOCKING_CHEST_STATUS_UPDATE, (class_2540)buf);
        }
    }

    public static void sendBlackHoleChestUpdate(BlackHoleChestBlockEntity chest) {
        class_1799 xpStack = chest.method_5438(27);
        class_2540 buf = PacketByteBufs.create();
        buf.method_10807(chest.method_11016());
        buf.writeBoolean(chest.isFullServer());
        buf.writeBoolean(chest.canStoreExperience());
        class_1792 class_17922 = xpStack.method_7909();
        if (class_17922 instanceof ExperienceStorageItem) {
            ExperienceStorageItem experienceStorageItem = (ExperienceStorageItem)class_17922;
            buf.writeLong((long)ExperienceStorageItem.getStoredExperience(xpStack));
            buf.writeLong((long)experienceStorageItem.getMaxStoredExperience(xpStack));
        } else {
            buf.writeLong(0L);
            buf.writeLong(0L);
        }
        for (class_3222 player : PlayerLookup.tracking((class_2586)chest)) {
            ServerPlayNetworking.send((class_3222)player, (class_2960)SpectrumS2CPackets.BLACK_HOLE_CHEST_STATUS_UPDATE, (class_2540)buf);
        }
    }

    public static void sendPastelNodeStatusUpdate(List<PastelNodeBlockEntity> nodes, boolean longSpin) {
        class_2540 buf = PacketByteBufs.create();
        buf.writeBoolean(longSpin);
        buf.writeInt(nodes.size());
        for (PastelNodeBlockEntity node : nodes) {
            class_1937 world = node.method_10997();
            if (world == null) continue;
            int time = longSpin ? 24 + world.method_8409().method_43048(11) : 10 + world.method_8409().method_43048(11);
            buf.method_10807(node.method_11016());
            buf.writeInt(time);
        }
        for (class_3222 player : PlayerLookup.tracking((class_2586)nodes.get(0))) {
            ServerPlayNetworking.send((class_3222)player, (class_2960)SpectrumS2CPackets.PASTEL_NODE_STATUS_UPDATE, (class_2540)buf);
        }
    }

    public static void syncPastelNetworkEdges(ServerPastelNetwork serverPastelNetwork, class_2338 pos) {
        class_2540 buf = PacketByteBufs.create();
        buf.method_10797(serverPastelNetwork.getUUID());
        buf.method_10794(serverPastelNetwork.graphToNbt());
        for (class_3222 player : PlayerLookup.tracking((class_3218)((class_3218)serverPastelNetwork.getWorld()), (class_2338)pos)) {
            ServerPlayNetworking.send((class_3222)player, (class_2960)SpectrumS2CPackets.PASTEL_NETWORK_EDGE_SYNC, (class_2540)buf);
        }
    }

    public static void syncPastelNetworkRemoved(ServerPastelNetwork network) {
        class_2540 buf = PacketByteBufs.create();
        buf.method_10797(network.getUUID());
        for (class_3222 player : PlayerLookup.all((MinecraftServer)((class_3218)network.getWorld()).method_8503())) {
            ServerPlayNetworking.send((class_3222)player, (class_2960)SpectrumS2CPackets.PASTEL_NETWORK_REMOVED, (class_2540)buf);
        }
    }
}

