/*
 * Decompiled with CFR 0.152.
 */
package de.dafuqs.spectrum.particle.render;

import com.google.common.collect.EvictingQueue;
import de.dafuqs.spectrum.particle.render.EarlyRenderingParticle;
import it.unimi.dsi.fastutil.objects.Object2ReferenceOpenHashMap;
import java.util.Map;
import java.util.Queue;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_3999;
import net.minecraft.class_4184;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import net.minecraft.class_703;

@Environment(value=EnvType.CLIENT)
public class EarlyRenderingParticleContainer {
    private static final int MAX_PARTICLES = 16384;
    private static final Map<class_3999, Queue<EarlyRenderingParticle>> particles = new Object2ReferenceOpenHashMap();

    public void add(class_703 particle) {
        if (particle instanceof EarlyRenderingParticle) {
            EarlyRenderingParticle earlyRenderingParticle = (EarlyRenderingParticle)particle;
            particles.computeIfAbsent(particle.method_18122(), sheet -> EvictingQueue.create((int)16384)).add(earlyRenderingParticle);
        }
    }

    public void removeDead() {
        for (Queue<EarlyRenderingParticle> particles : EarlyRenderingParticleContainer.particles.values()) {
            particles.removeIf(particle -> !((class_703)particle).method_3086());
        }
    }

    public static void clear() {
        particles.clear();
    }

    public void render(class_4587 matrices, class_4597 vertexConsumers, class_4184 camera, float tickDelta) {
        for (Queue<EarlyRenderingParticle> particles : EarlyRenderingParticleContainer.particles.values()) {
            for (EarlyRenderingParticle particle : particles) {
                particle.renderAsEntity(matrices, vertexConsumers, camera, tickDelta);
            }
        }
    }
}

