/*
 * Decompiled with CFR 0.152.
 */
package de.dafuqs.spectrum.recipe.potion_workshop;

import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import de.dafuqs.spectrum.api.energy.InkCost;
import de.dafuqs.spectrum.api.energy.InkPoweredStatusEffectInstance;
import de.dafuqs.spectrum.api.energy.color.InkColor;
import de.dafuqs.spectrum.api.item.InkPoweredPotionFillable;
import de.dafuqs.spectrum.helpers.Support;
import de.dafuqs.spectrum.recipe.potion_workshop.PotionMod;
import java.util.Optional;
import net.minecraft.class_1291;
import net.minecraft.class_1293;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_3518;
import net.minecraft.class_5819;
import net.minecraft.class_7923;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public record PotionRecipeEffect(boolean applicableToPotions, boolean applicableToTippedArrows, boolean applicableToPotionFillabes, boolean applicableToWeapons, int baseDurationTicks, float baseYield, int potencyHardCap, float potencyModifier, class_1291 statusEffect, InkColor inkColor, int inkCost) {
    public static PotionRecipeEffect read(JsonObject jsonObject) {
        boolean applicableToPotions = class_3518.method_15258((JsonObject)jsonObject, (String)"applicable_to_potions", (boolean)true);
        boolean applicableToTippedArrows = class_3518.method_15258((JsonObject)jsonObject, (String)"applicable_to_tipped_arrows", (boolean)true);
        boolean applicableToPotionFillabes = class_3518.method_15258((JsonObject)jsonObject, (String)"applicable_to_potion_fillables", (boolean)true);
        boolean applicableToWeapons = class_3518.method_15258((JsonObject)jsonObject, (String)"applicable_to_potion_weapons", (boolean)true);
        int potencyHardCap = class_3518.method_15282((JsonObject)jsonObject, (String)"potency_hard_cap", (int)-1);
        int baseDurationTicks = class_3518.method_15282((JsonObject)jsonObject, (String)"base_duration_ticks", (int)1600);
        float baseYield = class_3518.method_15277((JsonObject)jsonObject, (String)"base_yield", (float)3.0f);
        float potencyModifier = class_3518.method_15277((JsonObject)jsonObject, (String)"potency_modifier", (float)1.0f);
        class_2960 statusEffectIdentifier = class_2960.method_12829((String)class_3518.method_15265((JsonObject)jsonObject, (String)"effect"));
        if (!class_7923.field_41174.method_10250(statusEffectIdentifier)) {
            throw new JsonParseException("Potion Workshop Recipe has a status effect set that does not exist or is disabled: " + String.valueOf(statusEffectIdentifier));
        }
        class_1291 statusEffect = (class_1291)class_7923.field_41174.method_10223(statusEffectIdentifier);
        String inkColorString = class_3518.method_15265((JsonObject)jsonObject, (String)"ink_color");
        Optional<InkColor> inkColor = InkColor.ofIdString(inkColorString);
        if (inkColor.isEmpty()) {
            throw new JsonParseException("InkColor " + inkColorString + " for Potion Recipe Effect json does not exist.");
        }
        int inkCost = class_3518.method_15260((JsonObject)jsonObject, (String)"ink_cost");
        return new PotionRecipeEffect(applicableToPotions, applicableToTippedArrows, applicableToPotionFillabes, applicableToWeapons, baseDurationTicks, baseYield, potencyHardCap, potencyModifier, statusEffect, inkColor.get(), inkCost);
    }

    public void write(class_2540 packetByteBuf) {
        packetByteBuf.method_10812(class_7923.field_41174.method_10221((Object)this.statusEffect));
        packetByteBuf.writeInt(this.baseDurationTicks);
        packetByteBuf.writeFloat(this.baseYield);
        packetByteBuf.writeInt(this.potencyHardCap);
        packetByteBuf.writeFloat(this.potencyModifier);
        packetByteBuf.writeBoolean(this.applicableToPotions);
        packetByteBuf.writeBoolean(this.applicableToTippedArrows);
        packetByteBuf.writeBoolean(this.applicableToPotionFillabes);
        packetByteBuf.writeBoolean(this.applicableToWeapons);
        packetByteBuf.method_10812(this.inkColor.getID());
        packetByteBuf.writeInt(this.inkCost);
    }

    public static PotionRecipeEffect read(class_2540 packetByteBuf) {
        class_1291 statusEffect = (class_1291)class_7923.field_41174.method_10223(packetByteBuf.method_10810());
        int baseDurationTicks = packetByteBuf.readInt();
        float baseYield = packetByteBuf.readFloat();
        int hardCap = packetByteBuf.readInt();
        float potencyModifier = packetByteBuf.readFloat();
        boolean applicableToPotions = packetByteBuf.readBoolean();
        boolean applicableToTippedArrows = packetByteBuf.readBoolean();
        boolean applicableToPotionFillabes = packetByteBuf.readBoolean();
        boolean applicableToWeapons = packetByteBuf.readBoolean();
        InkColor inkColor = InkColor.ofId(packetByteBuf.method_10810()).get();
        int inkCost = packetByteBuf.readInt();
        return new PotionRecipeEffect(applicableToPotions, applicableToTippedArrows, applicableToPotionFillabes, applicableToWeapons, baseDurationTicks, baseYield, hardCap, potencyModifier, statusEffect, inkColor, inkCost);
    }

    @Nullable
    public InkPoweredStatusEffectInstance getStatusEffectInstance(@NotNull PotionMod potionMod, class_5819 random) {
        float potency = potionMod.flatPotencyBonus;
        int durationTicks = this.baseDurationTicks() + potionMod.flatDurationBonusTicks;
        switch (this.statusEffect().method_18792()) {
            case field_18271: {
                potency += potionMod.flatPotencyBonusPositiveEffects;
                durationTicks += potionMod.flatDurationBonusPositiveEffects;
                break;
            }
            case field_18272: {
                potency += potionMod.flatPotencyBonusNegativeEffects;
                durationTicks += potionMod.flatDurationBonusNegativeEffects;
                break;
            }
        }
        int n = durationTicks = this.statusEffect().method_5561() ? 1 : (int)((float)durationTicks * potionMod.durationMultiplier);
        if (this.potencyModifier() == 0.0f) {
            potency = 0.0f;
        } else {
            potency = ((1.0f + potency) * potionMod.potencyMultiplier - 1.0f) * this.potencyModifier();
            if ((potency = (float)Support.getIntFromDecimalWithChance(potency, random)) < 0.0f && (double)potionMod.potencyMultiplier == 0.0) {
                potency = 0.0f;
            }
        }
        if (this.potencyHardCap > -1 && potency > (float)this.potencyHardCap) {
            potency = this.potencyHardCap;
        }
        if (potency >= 0.0f && durationTicks > 0) {
            int effectColor = potionMod.getColor(random);
            return new InkPoweredStatusEffectInstance(new class_1293(this.statusEffect(), durationTicks, (int)potency, !potionMod.noParticles, !potionMod.noParticles), new InkCost(this.inkColor(), this.inkCost()), effectColor, potionMod.unidentifiable, potionMod.incurable);
        }
        return null;
    }

    public boolean isApplicableTo(class_1799 baseIngredient, PotionMod potionMod) {
        if (baseIngredient.method_31574(class_1802.field_8107)) {
            return this.applicableToTippedArrows && potionMod.makeSplashing && potionMod.makeLingering;
        }
        class_1792 class_17922 = baseIngredient.method_7909();
        if (class_17922 instanceof InkPoweredPotionFillable) {
            InkPoweredPotionFillable inkPoweredPotionFillable = (InkPoweredPotionFillable)class_17922;
            return this.applicableToPotionFillabes && !inkPoweredPotionFillable.isFull(baseIngredient) || this.applicableToWeapons && inkPoweredPotionFillable.isWeapon();
        }
        return this.applicableToPotions;
    }
}

