/*
 * Decompiled with CFR 0.152.
 */
package de.dafuqs.spectrum.recipe.titration_barrel;

import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import de.dafuqs.matchbooks.recipe.IngredientStack;
import de.dafuqs.matchbooks.recipe.RecipeParser;
import de.dafuqs.spectrum.SpectrumCommon;
import de.dafuqs.spectrum.api.recipe.FluidIngredient;
import de.dafuqs.spectrum.api.recipe.GatedRecipeSerializer;
import de.dafuqs.spectrum.recipe.RecipeUtils;
import de.dafuqs.spectrum.recipe.titration_barrel.FermentationData;
import de.dafuqs.spectrum.recipe.titration_barrel.TitrationBarrelRecipe;
import java.util.List;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_3518;
import net.minecraft.class_7923;

public class TitrationBarrelRecipeSerializer
implements GatedRecipeSerializer<TitrationBarrelRecipe> {
    public final RecipeFactory recipeFactory;

    public TitrationBarrelRecipeSerializer(RecipeFactory recipeFactory) {
        this.recipeFactory = recipeFactory;
    }

    public TitrationBarrelRecipe read(class_2960 identifier, JsonObject jsonObject) {
        String group = this.readGroup(jsonObject);
        boolean secret = this.readSecret(jsonObject);
        class_2960 requiredAdvancementIdentifier = this.readRequiredAdvancementIdentifier(jsonObject);
        JsonArray ingredientArray = class_3518.method_15261((JsonObject)jsonObject, (String)"ingredients");
        List ingredients = RecipeParser.ingredientStacksFromJson((JsonArray)ingredientArray, (int)ingredientArray.size());
        FluidIngredient fluidInput = FluidIngredient.EMPTY;
        if (class_3518.method_34923((JsonObject)jsonObject, (String)"fluid")) {
            JsonObject fluidObject = class_3518.method_15296((JsonObject)jsonObject, (String)"fluid");
            FluidIngredient.JsonParseResult result = FluidIngredient.fromJson(fluidObject);
            fluidInput = result.result();
            if (result.malformed()) {
                SpectrumCommon.logError("Titration Recipe " + String.valueOf(identifier) + "contains a malformed fluid input tag! This recipe will not be craftable.");
            } else if (result.result() == FluidIngredient.EMPTY && !result.isTag()) {
                SpectrumCommon.logError("Titration Recipe " + String.valueOf(identifier) + " specifies fluid " + String.valueOf(result.id()) + " that does not exist! This recipe will not be craftable.");
            }
        }
        class_1799 outputItemStack = RecipeUtils.itemStackWithNbtFromJson(class_3518.method_15296((JsonObject)jsonObject, (String)"result"));
        int minTimeDays = class_3518.method_15282((JsonObject)jsonObject, (String)"min_fermentation_time_hours", (int)24);
        class_1792 tappingItem = class_1802.field_8162;
        if (class_3518.method_15289((JsonObject)jsonObject, (String)"tapping_item")) {
            tappingItem = (class_1792)class_7923.field_41178.method_10223(class_2960.method_12829((String)class_3518.method_15265((JsonObject)jsonObject, (String)"tapping_item")));
        }
        FermentationData fermentationData = null;
        if (class_3518.method_34923((JsonObject)jsonObject, (String)"fermentation_data")) {
            fermentationData = FermentationData.fromJson(class_3518.method_15296((JsonObject)jsonObject, (String)"fermentation_data"));
        }
        return this.recipeFactory.create(identifier, group, secret, requiredAdvancementIdentifier, ingredients, fluidInput, outputItemStack, tappingItem, minTimeDays, fermentationData);
    }

    public void write(class_2540 packetByteBuf, TitrationBarrelRecipe recipe) {
        packetByteBuf.method_10814(recipe.group);
        packetByteBuf.writeBoolean(recipe.secret);
        this.writeNullableIdentifier(packetByteBuf, recipe.requiredAdvancementIdentifier);
        packetByteBuf.writeShort(recipe.inputStacks.size());
        for (IngredientStack ingredientStack : recipe.getIngredientStacks()) {
            ingredientStack.write(packetByteBuf);
        }
        this.writeFluidIngredient(packetByteBuf, recipe.fluid);
        packetByteBuf.method_10793(recipe.outputItemStack);
        packetByteBuf.method_10814(class_7923.field_41178.method_10221((Object)recipe.tappingItem).toString());
        packetByteBuf.writeInt(recipe.minFermentationTimeHours);
        if (recipe.fermentationData == null) {
            packetByteBuf.writeBoolean(false);
        } else {
            packetByteBuf.writeBoolean(true);
            recipe.fermentationData.write(packetByteBuf);
        }
    }

    public TitrationBarrelRecipe read(class_2960 identifier, class_2540 packetByteBuf) {
        String group = packetByteBuf.method_19772();
        boolean secret = packetByteBuf.readBoolean();
        class_2960 requiredAdvancementIdentifier = this.readNullableIdentifier(packetByteBuf);
        short craftingInputCount = packetByteBuf.readShort();
        List ingredients = IngredientStack.decodeByteBuf((class_2540)packetByteBuf, (int)craftingInputCount);
        FluidIngredient fluidInput = this.readFluidIngredient(packetByteBuf);
        class_1799 outputItemStack = packetByteBuf.method_10819();
        class_1792 tappingItem = (class_1792)class_7923.field_41178.method_10223(class_2960.method_12829((String)packetByteBuf.method_19772()));
        int minTimeDays = packetByteBuf.readInt();
        FermentationData fermentationData = null;
        if (packetByteBuf.readBoolean()) {
            fermentationData = FermentationData.read(packetByteBuf);
        }
        return this.recipeFactory.create(identifier, group, secret, requiredAdvancementIdentifier, ingredients, fluidInput, outputItemStack, tappingItem, minTimeDays, fermentationData);
    }

    public static interface RecipeFactory {
        public TitrationBarrelRecipe create(class_2960 var1, String var2, boolean var3, class_2960 var4, List<IngredientStack> var5, FluidIngredient var6, class_1799 var7, class_1792 var8, int var9, FermentationData var10);
    }
}

