/*
 * Decompiled with CFR 0.152.
 */
package de.dafuqs.spectrum.registries;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import de.dafuqs.spectrum.SpectrumCommon;
import de.dafuqs.spectrum.compat.SpectrumIntegrationPacks;
import java.util.Iterator;
import net.fabricmc.fabric.api.resource.conditions.v1.ResourceConditions;
import net.minecraft.class_1887;
import net.minecraft.class_2960;
import net.minecraft.class_3518;
import net.minecraft.class_7923;

public class SpectrumResourceConditions {
    public static final class_2960 ENCHANTMENTS_EXIST = SpectrumCommon.locate("enchantments_exist");
    public static final class_2960 INTEGRATION_PACK_ACTIVE = SpectrumCommon.locate("integration_pack_active");

    public static void register() {
        ResourceConditions.register((class_2960)ENCHANTMENTS_EXIST, SpectrumResourceConditions::enchantmentExistsMatch);
        ResourceConditions.register((class_2960)INTEGRATION_PACK_ACTIVE, SpectrumResourceConditions::integrationPackActive);
    }

    private static boolean enchantmentExistsMatch(JsonObject object) {
        JsonArray array = class_3518.method_15261((JsonObject)object, (String)"values");
        Iterator iterator = array.iterator();
        if (iterator.hasNext()) {
            JsonElement element = (JsonElement)iterator.next();
            if (element.isJsonPrimitive()) {
                class_2960 identifier = class_2960.method_12829((String)element.getAsString());
                class_1887 enchantment = (class_1887)class_7923.field_41176.method_10223(identifier);
                return enchantment != null;
            }
            throw new JsonParseException("Invalid enchantment id entry: " + String.valueOf(element));
        }
        return false;
    }

    private static boolean integrationPackActive(JsonObject object) {
        if (object.has("integration_pack")) {
            return SpectrumIntegrationPacks.isIntegrationPackActive(object.get("integration_pack").getAsString());
        }
        return false;
    }
}

