/*
 * Decompiled with CFR 0.152.
 */
package de.dafuqs.spectrum.worldgen.features;

import com.mojang.serialization.Codec;
import de.dafuqs.spectrum.blocks.deeper_down.flora.TriStateVineBlock;
import de.dafuqs.spectrum.registries.SpectrumBlockTags;
import de.dafuqs.spectrum.worldgen.features.TriStateVineFeatureConfig;
import net.minecraft.class_1936;
import net.minecraft.class_1945;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2680;
import net.minecraft.class_2741;
import net.minecraft.class_2769;
import net.minecraft.class_2794;
import net.minecraft.class_3031;
import net.minecraft.class_3481;
import net.minecraft.class_5281;
import net.minecraft.class_5819;
import net.minecraft.class_5821;

public class TriStateVineFeature
extends class_3031<TriStateVineFeatureConfig> {
    public TriStateVineFeature(Codec<TriStateVineFeatureConfig> configCodec) {
        super(configCodec);
    }

    public boolean method_13151(class_5821<TriStateVineFeatureConfig> context) {
        int stemHeight;
        class_5281 world = context.method_33652();
        class_2338 origin = context.method_33655();
        class_5819 random = context.method_33654();
        class_2794 chunkGen = context.method_33653();
        TriStateVineFeatureConfig config = (TriStateVineFeatureConfig)context.method_33656();
        class_2680 floorState = world.method_8320(origin.method_10084());
        if (!floorState.method_26164(class_3481.field_29822) && !floorState.method_26164(SpectrumBlockTags.BASE_STONE_DEEPER_DOWN)) {
            return false;
        }
        float berryChance = config.berryChance();
        class_2248 vineBlock = config.vineBlock();
        if (!(vineBlock instanceof TriStateVineBlock)) {
            throw new IllegalStateException("TriStateVineFeatures must use TriStateVineBlocks!");
        }
        if (berryChance > 0.0f && !vineBlock.method_9564().method_28498((class_2769)class_2741.field_28716)) {
            throw new IllegalStateException("Attempted to generate fruits for a vine with no fruiting state!");
        }
        int minHeight = config.minHeight().method_35008(random);
        float overgrowth = config.overgrowth().method_33920(random);
        class_2338.class_2339 mutablePos = origin.method_25503();
        for (stemHeight = 0; stemHeight < minHeight * 3; ++stemHeight) {
            mutablePos.method_10098(class_2350.field_11033);
            if (mutablePos.method_10264() < chunkGen.method_33730() || !TriStateVineFeature.isReplaceable((class_1936)world, (class_2338)mutablePos) || stemHeight > minHeight && random.method_43057() > overgrowth) break;
        }
        if (stemHeight <= config.cutoff()) {
            return false;
        }
        this.generateStem((class_1936)world, random, origin, vineBlock, stemHeight, berryChance);
        return true;
    }

    private static boolean isReplaceable(class_1936 world, class_2338 pos) {
        return world.method_8320(pos).method_26215();
    }

    private void generateStem(class_1936 world, class_5819 random, class_2338 origin, class_2248 vineBlock, int stemHeight, float berryChance) {
        class_2338.class_2339 stemPointer = origin.method_25503();
        class_2680 stemState = (class_2680)vineBlock.method_9564().method_11657(TriStateVineBlock.LIFE_STAGE, (Comparable)((Object)TriStateVineBlock.LifeStage.STALK));
        for (int height = 0; height <= stemHeight; ++height) {
            if (height == stemHeight) {
                if (berryChance > 0.0f && random.method_43057() <= berryChance) {
                    this.method_13153((class_1945)world, (class_2338)stemPointer, (class_2680)((class_2680)stemState.method_11657(TriStateVineBlock.LIFE_STAGE, (Comparable)((Object)TriStateVineBlock.LifeStage.MATURE))).method_11657((class_2769)class_2741.field_28716, (Comparable)Boolean.valueOf(true)));
                } else {
                    this.method_13153((class_1945)world, (class_2338)stemPointer, (class_2680)stemState.method_11657(TriStateVineBlock.LIFE_STAGE, (Comparable)((Object)TriStateVineBlock.LifeStage.MATURE)));
                }
            } else if (berryChance > 0.0f && random.method_43057() <= berryChance) {
                this.method_13153((class_1945)world, (class_2338)stemPointer, (class_2680)stemState.method_11657((class_2769)class_2741.field_28716, (Comparable)Boolean.valueOf(true)));
            } else {
                this.method_13153((class_1945)world, (class_2338)stemPointer, stemState);
            }
            stemPointer.method_10098(class_2350.field_11033);
        }
    }
}

