/*
 * Decompiled with CFR 0.152.
 */
package de.dafuqs.spectrum.worldgen.structures;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import de.dafuqs.spectrum.registries.SpectrumStructureTypes;
import java.util.Optional;
import java.util.function.Predicate;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import net.minecraft.class_2680;
import net.minecraft.class_2794;
import net.minecraft.class_2902;
import net.minecraft.class_2919;
import net.minecraft.class_2960;
import net.minecraft.class_3195;
import net.minecraft.class_3341;
import net.minecraft.class_3778;
import net.minecraft.class_3785;
import net.minecraft.class_4966;
import net.minecraft.class_5539;
import net.minecraft.class_5819;
import net.minecraft.class_5868;
import net.minecraft.class_6017;
import net.minecraft.class_6122;
import net.minecraft.class_6880;
import net.minecraft.class_7138;
import net.minecraft.class_7151;

public class UndergroundJigsawStructure
extends class_3195 {
    public static final Codec<UndergroundJigsawStructure> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)UndergroundJigsawStructure.method_42697((RecordCodecBuilder.Instance)instance), (App)class_3785.field_24954.fieldOf("start_pool").forGetter(structure -> structure.startPool), (App)class_2960.field_25139.optionalFieldOf("start_jigsaw_name").forGetter(structure -> structure.startJigsawName), (App)Codec.intRange((int)0, (int)7).fieldOf("size").forGetter(structure -> structure.size), (App)class_6122.field_31540.fieldOf("start_height").forGetter(structure -> structure.startHeight), (App)class_6017.field_33450.fieldOf("bury_depth").forGetter(structure -> structure.buryDepth), (App)Codec.intRange((int)0, (int)64).fieldOf("placement_check_width").forGetter(structure -> structure.placementCheckWidth), (App)Codec.intRange((int)0, (int)64).fieldOf("placement_check_height").forGetter(structure -> structure.placementCheckHeight), (App)Codec.intRange((int)1, (int)128).fieldOf("max_distance_from_center").forGetter(structure -> structure.maxDistanceFromCenter)).apply((Applicative)instance, UndergroundJigsawStructure::new)).codec();
    protected final class_6880<class_3785> startPool;
    protected final Optional<class_2960> startJigsawName;
    protected final int size;
    protected final int placementCheckWidth;
    protected final int placementCheckHeight;
    protected final class_6122 startHeight;
    protected final class_6017 buryDepth;
    protected final int maxDistanceFromCenter;

    public UndergroundJigsawStructure(class_3195.class_7302 config, class_6880<class_3785> startPool, Optional<class_2960> startJigsawName, Integer size, class_6122 startHeight, class_6017 buryDepth, Integer placementCheckWidth, Integer placementCheckHeight, Integer maxDistanceFromCenter) {
        super(config);
        this.startPool = startPool;
        this.startJigsawName = startJigsawName;
        this.size = size;
        this.startHeight = startHeight;
        this.buryDepth = buryDepth;
        this.placementCheckWidth = placementCheckWidth;
        this.placementCheckHeight = placementCheckHeight;
        this.maxDistanceFromCenter = maxDistanceFromCenter;
    }

    public Optional<class_3195.class_7150> method_38676(class_3195.class_7149 context) {
        class_3341 structureBox;
        class_7138 noiseConfig;
        class_5539 world;
        class_2919 chunkRandom = context.comp_566();
        class_5868 heightContext = new class_5868(context.comp_562(), context.comp_569());
        int x = context.comp_568().method_8326() + chunkRandom.method_43048(16);
        int z = context.comp_568().method_8328() + chunkRandom.method_43048(16);
        int y = this.startHeight.method_35391((class_5819)chunkRandom, heightContext);
        class_2794 chunkGenerator = context.comp_562();
        Optional<Integer> floorHeight = UndergroundJigsawStructure.getFloorHeight((class_5819)chunkRandom, chunkGenerator, world = context.comp_569(), noiseConfig = context.comp_564(), structureBox = class_3341.method_34390((class_2382)new class_2338(x - this.placementCheckWidth / 2, y, z - this.placementCheckWidth / 2), (class_2382)new class_2338(x + this.placementCheckWidth / 2, y + this.placementCheckHeight, z + this.placementCheckWidth / 2)), this.buryDepth);
        if (floorHeight.isEmpty()) {
            return Optional.empty();
        }
        return class_3778.method_30419((class_3195.class_7149)context, this.startPool, this.startJigsawName, (int)this.size, (class_2338)new class_2338(x, floorHeight.get().intValue(), z), (boolean)false, Optional.empty(), (int)this.maxDistanceFromCenter);
    }

    public class_7151<UndergroundJigsawStructure> method_41618() {
        return SpectrumStructureTypes.UNDERGROUND_JIGSAW;
    }

    private static Optional<Integer> getFloorHeight(class_5819 random, class_2794 chunkGenerator, class_5539 world, class_7138 noiseConfig, class_3341 box, class_6017 buryDepth) {
        int lowestY = world.method_31607() + 12;
        int floorY = box.method_35416();
        int structureHeight = box.method_35419() - box.method_35416();
        if (floorY > chunkGenerator.method_16397(box.method_35415(), box.method_35417(), class_2902.class_2903.field_13195, world, noiseConfig) - structureHeight || floorY > chunkGenerator.method_16397(box.method_35415(), box.method_35420(), class_2902.class_2903.field_13195, world, noiseConfig) - structureHeight || floorY > chunkGenerator.method_16397(box.method_35420(), box.method_35417(), class_2902.class_2903.field_13195, world, noiseConfig) - structureHeight || floorY > chunkGenerator.method_16397(box.method_35420(), box.method_35420(), class_2902.class_2903.field_13195, world, noiseConfig) - structureHeight) {
            return Optional.empty();
        }
        class_4966 heightLimitView = chunkGenerator.method_26261(box.method_22874().method_10263(), box.method_22874().method_10260(), world, noiseConfig);
        while (true) {
            if (floorY < lowestY) {
                return Optional.empty();
            }
            if (!heightLimitView.method_32892(floorY).method_51367()) break;
            --floorY;
        }
        class_4966[] verticalBlockSamples = new class_4966[]{chunkGenerator.method_26261(box.method_35415(), box.method_35417(), world, noiseConfig), chunkGenerator.method_26261(box.method_35415(), box.method_35420(), world, noiseConfig), chunkGenerator.method_26261(box.method_35418(), box.method_35417(), world, noiseConfig), chunkGenerator.method_26261(box.method_35418(), box.method_35420(), world, noiseConfig)};
        Predicate blockPredicate = class_2902.class_2903.field_13195.method_16402();
        while (floorY >= lowestY) {
            int matchingBlocks = 0;
            for (class_4966 verticalBlockSample : verticalBlockSamples) {
                class_2680 blockState = verticalBlockSample.method_32892(floorY);
                if (!blockPredicate.test(blockState) || ++matchingBlocks != 3) continue;
                if ((floorY -= buryDepth.method_35008(random)) < lowestY) {
                    return Optional.empty();
                }
                return Optional.of(floorY);
            }
            --floorY;
        }
        return Optional.empty();
    }
}

