/*
 * Decompiled with CFR 0.152.
 */
package de.dafuqs.spectrum.api.energy.storage;

import de.dafuqs.spectrum.api.energy.color.InkColor;
import de.dafuqs.spectrum.api.energy.color.InkColors;
import de.dafuqs.spectrum.api.energy.storage.SingleInkStorage;
import java.util.Optional;
import net.minecraft.class_2487;
import org.jetbrains.annotations.NotNull;

public class FixedSingleInkStorage
extends SingleInkStorage {
    public FixedSingleInkStorage(long maxEnergy, InkColor color) {
        super(maxEnergy);
        this.storedColor = color;
    }

    public FixedSingleInkStorage(long maxEnergy, InkColor color, long amount) {
        super(maxEnergy, color, amount);
    }

    public static FixedSingleInkStorage fromNbt(@NotNull class_2487 compound) {
        long maxEnergyTotal = compound.method_10537("MaxEnergyTotal");
        Optional<InkColor> color = InkColor.ofIdString(compound.method_10558("Color"));
        if (color.isPresent()) {
            long amount = compound.method_10537("Amount");
            return new FixedSingleInkStorage(maxEnergyTotal, color.get(), amount);
        }
        return new FixedSingleInkStorage(maxEnergyTotal, InkColors.CYAN, 0L);
    }

    @Override
    public boolean accepts(InkColor color) {
        return this.storedColor == color;
    }

    @Override
    public long getRoom(InkColor color) {
        if (this.storedColor == color) {
            return this.maxEnergy - this.storedEnergy;
        }
        return 0L;
    }
}

