/*
 * Decompiled with CFR 0.152.
 */
package de.dafuqs.spectrum.api.item;

import de.dafuqs.spectrum.api.item.StampDataCategory;
import de.dafuqs.spectrum.helpers.BlockReference;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_3545;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;

public interface Stampable {
    public static final String STAMPING_DATA_TAG = "spectrum:stamping_data";

    public StampData recordStampData(Optional<class_1657> var1, BlockReference var2, class_1937 var3);

    public boolean handleImpression(Optional<UUID> var1, Optional<class_1657> var2, BlockReference var3, class_1937 var4);

    public void clearImpression();

    public StampDataCategory getStampCategory();

    public boolean canUserStamp(Optional<class_1657> var1);

    public static class_2487 saveStampingData(StampData data) {
        class_2487 compound = new class_2487();
        data.stamper.ifPresent(uuid -> compound.method_25927("stamper", uuid));
        if (data.reference == null) {
            throw new IllegalStateException("Attempted to save stamp data without a BlockReference!");
        }
        compound.method_10544("source", data.reference.pos.method_10063());
        return compound;
    }

    public static Optional<StampData> loadStampingData(class_1937 world, class_2487 nbt) {
        class_3545<Optional<Stampable>, BlockReference> sourcePair = Stampable.findSource(world, nbt);
        Optional source = (Optional)sourcePair.method_15442();
        if (source.isEmpty()) {
            return Optional.empty();
        }
        Optional<UUID> stamper = Optional.empty();
        if (nbt.method_25928("stamper")) {
            stamper = Optional.of(nbt.method_25926("stamper"));
        }
        return Optional.of(new StampData(stamper, (BlockReference)sourcePair.method_15441(), (Stampable)source.get()));
    }

    private static class_3545<Optional<Stampable>, BlockReference> findSource(class_1937 world, class_2487 nbt) {
        Stampable interactable;
        Stampable stampInteractable = null;
        if (!nbt.method_10545("source")) {
            return new class_3545(Optional.empty(), null);
        }
        class_2338 pos = class_2338.method_10092((long)nbt.method_10537("source"));
        class_2680 state = world.method_8320(pos);
        BlockReference reference = BlockReference.of(state, pos);
        class_2248 class_22482 = state.method_26204();
        if (class_22482 instanceof Stampable) {
            stampInteractable = interactable = (Stampable)class_22482;
        }
        if ((class_22482 = world.method_8321(pos)) instanceof Stampable) {
            stampInteractable = interactable = (Stampable)class_22482;
            reference = reference.appendBE((class_2586)interactable);
        }
        return new class_3545(Optional.ofNullable(stampInteractable), (Object)reference);
    }

    default public boolean verifyStampData(StampData data) {
        if (data.source.getStampCategory() == StampDataCategory.UNIQUE) {
            return this.verifyUniqueStampData(data);
        }
        return data.source.getStampCategory() == this.getStampCategory();
    }

    @ApiStatus.OverrideOnly
    default public boolean verifyUniqueStampData(StampData data) {
        return true;
    }

    public void onImpressedOther(StampData var1, boolean var2);

    public record StampData(Optional<UUID> stamper, BlockReference reference, Stampable source) {
        public StampData(@Nullable class_1297 stamper, BlockReference reference, Stampable source) {
            this(Optional.ofNullable(stamper).map(class_1297::method_5667), reference, source);
        }

        public boolean verifyStampData(StampData data) {
            return this.source.verifyStampData(data);
        }

        public void notifySourceOfChange(StampData data, boolean succeess) {
            this.source.onImpressedOther(data, succeess);
        }

        public boolean canUserStamp(Optional<class_1657> player) {
            return this.source.canUserStamp(player);
        }
    }
}

