/*
 * Decompiled with CFR 0.152.
 */
package de.dafuqs.spectrum.api.recipe;

import com.google.gson.JsonObject;
import de.dafuqs.matchbooks.recipe.RegistryHelper;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Stream;
import net.fabricmc.fabric.api.transfer.v1.fluid.FluidVariant;
import net.minecraft.class_1799;
import net.minecraft.class_1856;
import net.minecraft.class_2378;
import net.minecraft.class_2960;
import net.minecraft.class_3518;
import net.minecraft.class_3611;
import net.minecraft.class_3612;
import net.minecraft.class_6862;
import net.minecraft.class_6885;
import net.minecraft.class_7922;
import net.minecraft.class_7923;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FluidIngredient {
    @Nullable
    private final class_3611 fluid;
    @Nullable
    private final class_2960 tag;
    public static FluidIngredient EMPTY = new FluidIngredient(null, null);

    private FluidIngredient(@Nullable class_3611 fluid, @Nullable class_2960 tag) {
        this.fluid = fluid;
        this.tag = tag;
    }

    public String toString() {
        if (this == EMPTY) {
            return "FluidIngredient.EMPTY";
        }
        if (this.fluid != null) {
            return String.format("FluidIngredient[fluid=%s]", this.fluid);
        }
        assert (this.tag != null);
        return String.format("FluidIngredient[tag=%s]", this.tag);
    }

    public static FluidIngredient of(@NotNull class_3611 fluid) {
        Objects.requireNonNull(fluid);
        return new FluidIngredient(fluid, null);
    }

    public static FluidIngredient of(@NotNull class_2960 tag) {
        Objects.requireNonNull(tag);
        return new FluidIngredient(null, tag);
    }

    public Optional<class_3611> fluid() {
        return Optional.ofNullable(this.fluid);
    }

    public Optional<class_6862<class_3611>> tag() {
        return RegistryHelper.tryGetTagKey((class_2378)class_7923.field_41173, (class_2960)this.tag);
    }

    public boolean isTag() {
        return this.tag != null;
    }

    public class_2960 id() {
        return this.fluid != null ? class_7923.field_41173.method_10221((Object)this.fluid) : this.tag;
    }

    @NotNull
    public class_1856 into() {
        if (this == EMPTY) {
            return class_1856.method_35226();
        }
        if (this.fluid != null) {
            return class_1856.method_8101((class_1799[])new class_1799[]{this.fluid.method_15774().method_7854()});
        }
        if (this.tag != null) {
            class_7922 registry = class_7923.field_41173;
            if (registry == null) {
                return class_1856.method_35226();
            }
            Optional optional = registry.method_40266(this.tag().get());
            if (optional.isEmpty()) {
                return class_1856.method_35226();
            }
            class_6885.class_6888 list = (class_6885.class_6888)optional.get();
            Stream<class_1799> stacks = list.method_40239().map(entry -> ((class_3611)entry.comp_349()).method_15774().method_7854());
            return class_1856.method_26964(stacks);
        }
        throw new AssertionError((Object)"Invalid FluidIngredient object");
    }

    public boolean test(@NotNull class_3611 fluid) {
        Objects.requireNonNull(fluid);
        if (this == EMPTY) {
            return fluid == class_3612.field_15906;
        }
        if (this.fluid != null) {
            return this.fluid == fluid;
        }
        if (this.tag != null) {
            return fluid.method_15785().method_15767(this.tag().get());
        }
        throw new AssertionError((Object)"Invalid FluidIngredient object");
    }

    public boolean test(@NotNull FluidVariant variant) {
        Objects.requireNonNull(variant);
        return this.test(variant.getFluid());
    }

    @NotNull
    public static FluidIngredient fromIdentifier(@Nullable class_2960 id, boolean isTag) {
        if (isTag) {
            return FluidIngredient.of(id);
        }
        class_3611 fluid = (class_3611)class_7923.field_41173.method_10223(id);
        if (fluid.method_15785().method_15769()) {
            return EMPTY;
        }
        return FluidIngredient.of(fluid);
    }

    @NotNull
    public static JsonParseResult fromJson(JsonObject fluidObject) {
        boolean hasFluid = class_3518.method_15289((JsonObject)fluidObject, (String)"fluid");
        boolean isTag = class_3518.method_15289((JsonObject)fluidObject, (String)"tag");
        if (hasFluid && isTag || !hasFluid && !isTag) {
            return new JsonParseResult(EMPTY, true, isTag, null);
        }
        class_2960 id = class_2960.method_12829((String)class_3518.method_15265((JsonObject)fluidObject, (String)(isTag ? "tag" : "fluid")));
        return new JsonParseResult(FluidIngredient.fromIdentifier(id, isTag), false, isTag, id);
    }

    public record JsonParseResult(@NotNull FluidIngredient result, boolean malformed, boolean isTag, @Nullable class_2960 id) {
    }
}

