/*
 * Decompiled with CFR 0.152.
 */
package de.dafuqs.spectrum.blocks.bottomless_bundle;

import de.dafuqs.spectrum.blocks.bottomless_bundle.BottomlessBundleItem;
import de.dafuqs.spectrum.registries.SpectrumBlockEntities;
import de.dafuqs.spectrum.registries.SpectrumEnchantments;
import de.dafuqs.spectrum.registries.SpectrumItems;
import net.fabricmc.fabric.api.transfer.v1.item.ItemVariant;
import net.fabricmc.fabric.api.transfer.v1.storage.TransferVariant;
import net.fabricmc.fabric.api.transfer.v1.storage.base.SingleVariantStorage;
import net.fabricmc.fabric.api.transfer.v1.transaction.TransactionContext;
import net.minecraft.class_1799;
import net.minecraft.class_1887;
import net.minecraft.class_1890;
import net.minecraft.class_1893;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import org.jetbrains.annotations.NotNull;

public class BottomlessBundleBlockEntity
extends class_2586 {
    private class_1799 bottomlessBundleStack;
    private boolean isVoiding;
    protected int powerLevel;
    public final SingleVariantStorage<ItemVariant> storage = new SingleVariantStorage<ItemVariant>(){

        protected boolean canInsert(ItemVariant variant) {
            return variant.getItem().method_31568() && (((ItemVariant)this.variant).isBlank() || ((ItemVariant)this.variant).isOf((Object)variant.getItem()) && ((ItemVariant)this.variant).nbtMatches(variant.getNbt()));
        }

        public long insert(ItemVariant insertedVariant, long maxAmount, TransactionContext transaction) {
            long inserted = super.insert((TransferVariant)insertedVariant, maxAmount, transaction);
            return BottomlessBundleBlockEntity.this.isVoiding ? maxAmount : inserted;
        }

        protected ItemVariant getBlankVariant() {
            return (ItemVariant)this.variant;
        }

        protected long getCapacity(ItemVariant variant) {
            return BottomlessBundleItem.getMaxStoredAmount(BottomlessBundleBlockEntity.this.powerLevel);
        }

        protected void onFinalCommit() {
            super.onFinalCommit();
            BottomlessBundleBlockEntity.this.method_5431();
        }
    };

    public BottomlessBundleBlockEntity(class_2338 pos, class_2680 state) {
        super(SpectrumBlockEntities.BOTTOMLESS_BUNDLE, pos, state);
        this.bottomlessBundleStack = SpectrumItems.BOTTOMLESS_BUNDLE.method_7854();
    }

    public void method_11014(class_2487 nbt) {
        super.method_11014(nbt);
        this.setBundleUnsynced(class_1799.method_7915((class_2487)nbt.method_10562("Bundle")));
        if (nbt.method_10545("StorageVariant")) {
            this.storage.variant = ItemVariant.fromNbt((class_2487)nbt.method_10562("StorageVariant"));
            this.storage.amount = nbt.method_10537("StorageCount");
            this.syncBundleWithStorage();
        } else {
            this.syncStorageWithBundle();
        }
    }

    private void syncBundleWithStorage() {
        if (this.storage.variant == null || this.storage.amount == 0L) {
            BottomlessBundleItem.setBundledStack(this.bottomlessBundleStack, class_1799.field_8037, 0);
        } else {
            BottomlessBundleItem.setBundledStack(this.bottomlessBundleStack, ((ItemVariant)this.storage.variant).toStack(), (int)this.storage.amount);
        }
    }

    private void syncStorageWithBundle() {
        this.storage.variant = ItemVariant.of((class_1799)BottomlessBundleItem.getFirstBundledStack(this.bottomlessBundleStack));
        this.storage.amount = BottomlessBundleItem.getStoredAmount(this.bottomlessBundleStack);
    }

    protected void method_11007(class_2487 nbt) {
        super.method_11007(nbt);
        this.syncBundleWithStorage();
        class_2487 bundleCompound = new class_2487();
        this.bottomlessBundleStack.method_7953(bundleCompound);
        nbt.method_10566("Bundle", (class_2520)bundleCompound);
    }

    private boolean setBundleUnsynced(class_1799 itemStack) {
        if (itemStack.method_7909() instanceof BottomlessBundleItem) {
            this.bottomlessBundleStack = itemStack;
            this.isVoiding = class_1890.method_8225((class_1887)SpectrumEnchantments.VOIDING, (class_1799)this.bottomlessBundleStack) > 0;
            this.powerLevel = class_1890.method_8225((class_1887)class_1893.field_9103, (class_1799)itemStack);
            return true;
        }
        return false;
    }

    public void setBundle(@NotNull class_1799 itemStack) {
        if (this.setBundleUnsynced(itemStack)) {
            this.syncStorageWithBundle();
        }
    }

    public class_1799 retrieveBundle() {
        if (this.bottomlessBundleStack.method_7960()) {
            return SpectrumItems.BOTTOMLESS_BUNDLE.method_7854();
        }
        this.syncBundleWithStorage();
        return this.bottomlessBundleStack;
    }
}

