/*
 * Decompiled with CFR 0.152.
 */
package de.dafuqs.spectrum.blocks.chests;

import de.dafuqs.spectrum.blocks.chests.SpectrumChestBlockEntity;
import de.dafuqs.spectrum.helpers.InventoryHelper;
import de.dafuqs.spectrum.inventories.AutoCompactingInventory;
import de.dafuqs.spectrum.inventories.CompactingChestScreenHandler;
import de.dafuqs.spectrum.networking.SpectrumS2CPacketSender;
import de.dafuqs.spectrum.registries.SpectrumBlockEntities;
import de.dafuqs.spectrum.registries.SpectrumSoundEvents;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.fabricmc.fabric.api.screenhandler.v1.ExtendedScreenHandlerFactory;
import net.fabricmc.fabric.api.transfer.v1.item.ItemVariant;
import net.minecraft.class_1263;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2371;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_2487;
import net.minecraft.class_2540;
import net.minecraft.class_2561;
import net.minecraft.class_2680;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3545;
import net.minecraft.class_3955;
import net.minecraft.class_3956;
import net.minecraft.class_5819;

public class CompactingChestBlockEntity
extends SpectrumChestBlockEntity
implements ExtendedScreenHandlerFactory {
    private static final Map<AutoCompactingInventory.AutoCraftingMode, Map<ItemVariant, Optional<class_3955>>> cache = new EnumMap<AutoCompactingInventory.AutoCraftingMode, Map<ItemVariant, Optional<class_3955>>>(AutoCompactingInventory.AutoCraftingMode.class);
    private final AutoCompactingInventory autoCompactingInventory = new AutoCompactingInventory();
    private AutoCompactingInventory.AutoCraftingMode autoCraftingMode;
    private class_3955 lastCraftingRecipe = null;
    private ItemVariant lastItemVariant = null;
    private boolean hasToCraft = false;
    private boolean isOpen;
    private State state = State.CLOSED;
    float pistonPos;
    float pistonTarget;
    float lastPistonTarget;
    float driverPos;
    float driverTarget;
    float lastDriverTarget;
    float capPos;
    float capTarget;
    float lastCapTarget;
    long interpTicks;
    long interpLength = 1L;
    long activeTicks;
    long craftingTicks;

    public CompactingChestBlockEntity(class_2338 blockPos, class_2680 blockState) {
        super(SpectrumBlockEntities.COMPACTING_CHEST, blockPos, blockState);
        this.autoCraftingMode = AutoCompactingInventory.AutoCraftingMode.ThreeXThree;
    }

    public static void tick(class_1937 world, class_2338 pos, class_2680 state, CompactingChestBlockEntity chest) {
        if (!world.method_8608()) {
            SpectrumS2CPacketSender.sendCompactingChestStatusUpdate(chest);
        }
        if (world.method_8608()) {
            chest.craftingTicks = chest.hasToCraft() ? 20L : --chest.craftingTicks;
            chest.activeTicks = chest.craftingTicks >= 0L ? ++chest.activeTicks : 0L;
            if (chest.isOpen()) {
                chest.changeState(State.OPEN);
                chest.interpLength = 5L;
            } else if (chest.craftingTicks >= 0L) {
                chest.changeState(State.CRAFTING);
                chest.interpLength = 20L;
            } else {
                chest.changeState(State.CLOSED);
                chest.interpLength = 15L;
            }
            if (chest.interpTicks < chest.interpLength) {
                ++chest.interpTicks;
            }
        } else if (chest.hasToCraft) {
            boolean couldCraft = chest.tryCraftOnce();
            if (!couldCraft) {
                chest.shouldCraft(false);
            }
            if (world.method_8510() % 6L == 0L) {
                chest.produceRunningEffects();
            }
        }
    }

    public void produceRunningEffects() {
        class_3218 server = (class_3218)this.field_11863;
        class_5819 random = this.field_11863.method_8409();
        if (random.method_43057() < 0.125f) {
            server.method_8396(null, this.field_11867, class_3417.field_19199, class_3419.field_15245, 0.05f + random.method_43057() * 0.1f, 0.334f + random.method_43057() / 2.0f);
            for (int i = 0; i < 4 + random.method_43048(5); ++i) {
                server.method_14199((class_2394)class_2398.field_11204, (double)((float)this.field_11867.method_10263() + random.method_43057()), (double)this.field_11867.method_10264() + 0.975 + (double)(random.method_43057() * 0.667f), (double)((float)this.field_11867.method_10260() + random.method_43057()), 0, 0.0, (double)(random.method_43057() / 20.0f + 0.02f), 0.0, 1.0);
            }
        }
    }

    public void changeState(State state) {
        if (this.state != state) {
            this.state = state;
            this.lastPistonTarget = this.pistonPos;
            this.lastDriverTarget = this.driverPos;
            this.lastCapTarget = this.capPos;
            this.interpTicks = 0L;
        }
    }

    public State getState() {
        return this.state;
    }

    private static boolean smartAddToInventory(List<class_1799> itemStacks, List<class_1799> inventory, boolean test) {
        ArrayList<class_1799> additionStacks = new ArrayList<class_1799>();
        for (class_1799 itemStack : itemStacks) {
            additionStacks.add(itemStack.method_7972());
        }
        boolean tryStackExisting = true;
        for (int i = 0; i < inventory.size(); ++i) {
            class_1799 currentStack = inventory.get(i);
            for (class_1799 additionStack : additionStacks) {
                int canAcceptCount;
                int maxStackCount;
                boolean doneStuff = false;
                if (additionStack.method_7947() <= 0) continue;
                if (currentStack.method_7960() && (test || !tryStackExisting)) {
                    maxStackCount = currentStack.method_7914();
                    int maxAcceptCount = Math.min(additionStack.method_7947(), maxStackCount);
                    if (!test) {
                        class_1799 newStack = additionStack.method_7972();
                        newStack.method_7939(maxAcceptCount);
                        inventory.set(i, newStack);
                    }
                    additionStack.method_7939(additionStack.method_7947() - maxAcceptCount);
                    doneStuff = true;
                } else if (class_1799.method_31577((class_1799)currentStack, (class_1799)additionStack) && (canAcceptCount = (maxStackCount = currentStack.method_7914()) - currentStack.method_7947()) > 0) {
                    if (!test) {
                        inventory.get(i).method_7933(Math.min(additionStack.method_7947(), canAcceptCount));
                    }
                    if (canAcceptCount >= additionStack.method_7947()) {
                        additionStack.method_7939(0);
                    } else {
                        additionStack.method_7939(additionStack.method_7947() - canAcceptCount);
                    }
                    doneStuff = true;
                }
                if (!doneStuff) continue;
                boolean allEmpty = true;
                for (class_1799 itemStack : additionStacks) {
                    if (itemStack.method_7947() <= 0) continue;
                    allEmpty = false;
                    break;
                }
                if (!allEmpty) continue;
                return true;
            }
            if (!tryStackExisting || test || i != inventory.size() - 1) continue;
            tryStackExisting = false;
            i = -1;
        }
        return false;
    }

    public static void clearCache() {
        cache.clear();
    }

    protected class_2561 method_17823() {
        return class_2561.method_43471((String)"block.spectrum.compacting_chest");
    }

    @Override
    public void method_11014(class_2487 tag) {
        super.method_11014(tag);
        if (tag.method_10573("AutoCraftingMode", 99)) {
            int autoCraftingModeInt = tag.method_10550("AutoCraftingMode");
            this.autoCraftingMode = AutoCompactingInventory.AutoCraftingMode.values()[autoCraftingModeInt];
        }
    }

    @Override
    public void method_11007(class_2487 tag) {
        super.method_11007(tag);
        tag.method_10569("AutoCraftingMode", this.autoCraftingMode.ordinal());
    }

    public int method_5439() {
        return 27;
    }

    @Override
    public void method_5447(int slot, class_1799 stack) {
        super.method_5447(slot, stack);
        this.shouldCraft(true);
    }

    public void inventoryChanged() {
        this.shouldCraft(true);
    }

    private boolean tryCraftOnce() {
        Optional<Object> optionalCraftingRecipe = Optional.empty();
        class_2371<class_1799> inventory = this.method_11282();
        if (this.lastCraftingRecipe != null) {
            int requiredItemCount = this.autoCraftingMode.getItemCount();
            if (InventoryHelper.isItemCountInInventory(inventory, this.lastItemVariant, requiredItemCount)) {
                optionalCraftingRecipe = Optional.ofNullable(this.lastCraftingRecipe);
            } else {
                this.lastCraftingRecipe = null;
                this.lastItemVariant = null;
            }
        }
        if (optionalCraftingRecipe.isEmpty()) {
            optionalCraftingRecipe = this.searchRecipeToCraft();
        }
        if (optionalCraftingRecipe.isPresent() && this.lastItemVariant != null && this.tryCraftInInventory(inventory, (class_3955)optionalCraftingRecipe.get(), this.lastItemVariant)) {
            this.lastCraftingRecipe = (class_3955)optionalCraftingRecipe.get();
            return true;
        }
        return false;
    }

    public boolean isOpen() {
        return this.isOpen;
    }

    public void shouldCraft(boolean hasToCraft) {
        this.hasToCraft = hasToCraft;
    }

    @Override
    public boolean method_11004(int type, int data) {
        if (type == 1) {
            this.isOpen = data > 0;
        }
        return super.method_11004(type, data);
    }

    public boolean hasToCraft() {
        return this.hasToCraft;
    }

    public Optional<class_3955> searchRecipeToCraft() {
        for (class_1799 itemStack : this.inventory) {
            ItemVariant itemKey;
            int requiredItemCount;
            class_3545<Integer, List<class_1799>> stackPair;
            if (itemStack.method_7960() || (Integer)(stackPair = InventoryHelper.getStackCountInInventory(itemStack, (List<class_1799>)this.inventory, requiredItemCount = this.autoCraftingMode.getItemCount())).method_15442() < requiredItemCount) continue;
            Map currentCache = cache.computeIfAbsent(this.autoCraftingMode, mode -> new HashMap());
            Optional recipe = (Optional)currentCache.get(itemKey = ItemVariant.of((class_1799)itemStack));
            if (recipe != null) {
                if (recipe.isEmpty()) continue;
                this.lastItemVariant = itemKey;
                return recipe;
            }
            this.autoCompactingInventory.setCompacting(this.autoCraftingMode, itemKey.toStack());
            Optional<class_3955> optionalCraftingRecipe = this.field_11863.method_8433().method_8132(class_3956.field_17545, (class_1263)this.autoCompactingInventory, this.field_11863);
            if (optionalCraftingRecipe.isEmpty() || ((class_3955)optionalCraftingRecipe.get()).method_8116((class_1263)this.autoCompactingInventory, this.field_11863.method_30349()).method_7960()) {
                optionalCraftingRecipe = Optional.empty();
                currentCache.put(itemKey, optionalCraftingRecipe);
                continue;
            }
            currentCache.put(itemKey, optionalCraftingRecipe);
            this.lastItemVariant = itemKey;
            return optionalCraftingRecipe;
        }
        return Optional.empty();
    }

    public boolean tryCraftInInventory(class_2371<class_1799> inventory, class_3955 craftingRecipe, ItemVariant itemVariant) {
        class_1799 inputStack = itemVariant.toStack(this.autoCraftingMode.getItemCount());
        List<class_1799> remainders = InventoryHelper.removeFromInventoryWithRemainders(inputStack, (class_1263)this);
        ArrayList<class_1799> additionItemStacks = new ArrayList<class_1799>();
        additionItemStacks.add(craftingRecipe.method_8110(this.field_11863.method_30349()));
        additionItemStacks.addAll(remainders);
        boolean spaceInInventory = CompactingChestBlockEntity.smartAddToInventory(additionItemStacks, inventory, true);
        if (spaceInInventory) {
            CompactingChestBlockEntity.smartAddToInventory(additionItemStacks, inventory, false);
            this.method_11281(inventory);
            return true;
        }
        CompactingChestBlockEntity.smartAddToInventory(List.of(inputStack), inventory, false);
        return false;
    }

    @Override
    public class_3414 getOpenSound() {
        return SpectrumSoundEvents.COMPACTING_CHEST_OPEN;
    }

    @Override
    public class_3414 getCloseSound() {
        return SpectrumSoundEvents.COMPACTING_CHEST_CLOSE;
    }

    public AutoCompactingInventory.AutoCraftingMode getAutoCraftingMode() {
        return this.autoCraftingMode;
    }

    public void applySettings(class_2540 buf) {
        int autoCraftingModeInt = buf.readInt();
        this.autoCraftingMode = AutoCompactingInventory.AutoCraftingMode.values()[autoCraftingModeInt];
        this.lastCraftingRecipe = null;
    }

    protected class_1703 method_5465(int syncId, class_1661 playerInventory) {
        return new CompactingChestScreenHandler(syncId, playerInventory, this);
    }

    public void writeScreenOpeningData(class_3222 player, class_2540 buf) {
        buf.method_10807(this.field_11867);
        buf.writeInt(this.autoCraftingMode.ordinal());
    }

    public static enum State {
        OPEN,
        CRAFTING,
        CLOSED;

    }
}

