/*
 * Decompiled with CFR 0.152.
 */
package de.dafuqs.spectrum.blocks.pastel_network.network;

import de.dafuqs.spectrum.SpectrumCommon;
import de.dafuqs.spectrum.blocks.pastel_network.Pastel;
import de.dafuqs.spectrum.blocks.pastel_network.network.NodeRemovalReason;
import de.dafuqs.spectrum.blocks.pastel_network.network.PastelNetwork;
import de.dafuqs.spectrum.blocks.pastel_network.network.PastelTransmission;
import de.dafuqs.spectrum.blocks.pastel_network.network.PastelTransmissionLogic;
import de.dafuqs.spectrum.blocks.pastel_network.nodes.PastelNodeBlockEntity;
import de.dafuqs.spectrum.blocks.pastel_network.nodes.PastelNodeType;
import de.dafuqs.spectrum.helpers.SchedulerMap;
import de.dafuqs.spectrum.helpers.TickLooper;
import de.dafuqs.spectrum.networking.SpectrumS2CPacketSender;
import de.dafuqs.spectrum.registries.SpectrumBlockEntities;
import it.unimi.dsi.fastutil.objects.Object2ObjectArrayMap;
import it.unimi.dsi.fastutil.objects.ObjectArraySet;
import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2520;
import net.minecraft.class_2586;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_5321;
import net.minecraft.class_7924;
import org.jetbrains.annotations.Nullable;
import org.jgrapht.alg.connectivity.ConnectivityInspector;
import org.jgrapht.graph.DefaultEdge;

public class ServerPastelNetwork
extends PastelNetwork<class_3218> {
    protected final Map<PastelNodeType, Set<PastelNodeBlockEntity>> loadedNodes = new ConcurrentHashMap<PastelNodeType, Set<PastelNodeBlockEntity>>();
    protected final Set<PastelNodeBlockEntity> priorityNodes = new HashSet<PastelNodeBlockEntity>();
    protected final Set<PastelNodeBlockEntity> highPriorityNodes = new HashSet<PastelNodeBlockEntity>();
    private final TickLooper transferLooper = new TickLooper(10);
    protected final SchedulerMap<PastelTransmission> transmissions = new SchedulerMap();
    protected final PastelTransmissionLogic transmissionLogic;

    public ServerPastelNetwork(class_3218 world, @Nullable UUID uuid) {
        super(world, uuid);
        for (PastelNodeType type : PastelNodeType.values()) {
            this.loadedNodes.put(type, new HashSet());
        }
        this.transmissionLogic = new PastelTransmissionLogic(this);
    }

    private boolean addNodeOrReturn(PastelNodeBlockEntity node) {
        return !this.loadedNodes.get((Object)node.getNodeType()).add(node);
    }

    private void addPriorityNode(PastelNodeBlockEntity node) {
        switch (node.getPriority()) {
            case MODERATE: {
                this.priorityNodes.add(node);
                break;
            }
            case HIGH: {
                this.highPriorityNodes.add(node);
            }
        }
    }

    public void updateNodePriority(PastelNodeBlockEntity node, PastelNetwork.NodePriority oldPriority) {
        this.removePriorityNode(node, oldPriority);
        this.addPriorityNode(node);
    }

    @Override
    public String getNodeDebugText() {
        return super.getNodeDebugText() + " - Prov: " + this.getLoadedNodes(PastelNodeType.PROVIDER).size() + " - Send: " + this.getLoadedNodes(PastelNodeType.SENDER).size() + " - Gath: " + this.getLoadedNodes(PastelNodeType.GATHER).size() + " - Stor: " + this.getLoadedNodes(PastelNodeType.STORAGE).size() + " - Buff: " + this.getLoadedNodes(PastelNodeType.BUFFER).size() + " - Conn: " + this.getLoadedNodes(PastelNodeType.CONNECTION).size();
    }

    public String toString() {
        StringBuilder builder = new StringBuilder(this.uuid.toString());
        for (PastelNodeType type : PastelNodeType.values()) {
            builder.append("-").append(this.getLoadedNodes(type).size());
        }
        return builder.toString();
    }

    @Nullable
    protected PastelNodeBlockEntity getLoadedNodeAt(class_2338 blockPos) {
        if (!this.graph.vertexSet().contains(blockPos)) {
            return null;
        }
        if (!((class_3218)this.getWorld()).method_22340(blockPos)) {
            return null;
        }
        class_2586 blockEntity = ((class_3218)this.getWorld()).method_8321(blockPos);
        if (blockEntity instanceof PastelNodeBlockEntity) {
            PastelNodeBlockEntity pastelNodeBlockEntity = (PastelNodeBlockEntity)blockEntity;
            return pastelNodeBlockEntity;
        }
        return null;
    }

    private void removePriorityNode(PastelNodeBlockEntity node, PastelNetwork.NodePriority priority) {
        switch (priority) {
            case MODERATE: {
                this.priorityNodes.remove(node);
                break;
            }
            case HIGH: {
                this.highPriorityNodes.remove(node);
            }
        }
    }

    public Set<PastelNodeBlockEntity> getLoadedNodes(PastelNodeType type) {
        return this.getLoadedNodes(type, PastelNetwork.NodePriority.GENERIC);
    }

    public Set<PastelNodeBlockEntity> getLoadedNodes(PastelNodeType type, PastelNetwork.NodePriority priority) {
        Set<PastelNodeBlockEntity> nodeType = this.loadedNodes.get((Object)type);
        if (priority == PastelNetwork.NodePriority.MODERATE) {
            return nodeType.stream().filter(this.priorityNodes::contains).collect(Collectors.toSet());
        }
        if (priority == PastelNetwork.NodePriority.HIGH) {
            return nodeType.stream().filter(this.highPriorityNodes::contains).collect(Collectors.toSet());
        }
        return nodeType;
    }

    protected void addNode(PastelNodeBlockEntity node) {
        if (this.graph.containsVertex((Object)node.method_11016())) {
            this.loadedNodes.get((Object)node.getNodeType()).add(node);
        } else {
            if (this.addNodeOrReturn(node)) {
                return;
            }
            this.graph.addVertex((Object)node.method_11016());
        }
        this.addPriorityNode(node);
    }

    protected void removeSelf() {
        for (class_2338 vertex : this.graph.vertexSet()) {
            Optional be = ((class_3218)this.world).method_35230(vertex, SpectrumBlockEntities.PASTEL_NODE);
            be.ifPresent(pastelNodeBlockEntity -> pastelNodeBlockEntity.setNetworkUUID(null));
        }
        SpectrumS2CPacketSender.syncPastelNetworkRemoved(this);
        Pastel.getServerInstance().removeNetwork(this.getUUID());
    }

    protected void addNodeAndConnect(PastelNodeBlockEntity newNode, PastelNodeBlockEntity existing) {
        if (this.addNodeOrReturn(newNode)) {
            return;
        }
        this.graph.addVertex((Object)newNode.method_11016());
        this.getGraph().addEdge((Object)newNode.method_11016(), (Object)existing.method_11016());
        this.addPriorityNode(newNode);
        newNode.setNetworkUUID(this.getUUID());
        SpectrumS2CPacketSender.syncPastelNetworkEdges(this, newNode.method_11016());
    }

    private void checkForNetworkSplit(class_2338 sourcePos) {
        ConnectivityInspector connectivityInspector;
        List connectedSets;
        if (this.graph.vertexSet().size() < 2) {
            this.removeSelf();
        }
        if ((connectedSets = (connectivityInspector = new ConnectivityInspector(this.graph)).connectedSets()).size() == 1) {
            this.transmissionLogic.invalidateCache();
            return;
        }
        int biggestSetSize = 0;
        Set biggestSet = null;
        ArrayList<Set> smallerSets = new ArrayList<Set>();
        for (Set set : connectedSets) {
            int size = set.size();
            if (size > biggestSetSize) {
                biggestSetSize = size;
                if (biggestSet != null) {
                    smallerSets.add(biggestSet);
                }
                biggestSet = set;
                continue;
            }
            smallerSets.add(set);
        }
        if (biggestSetSize == 1) {
            this.removeSelf();
            return;
        }
        ObjectOpenHashSet disconnectedBEs = new ObjectOpenHashSet();
        for (Set smallerSet : smallerSets) {
            boolean isSingleNode;
            boolean bl = isSingleNode = smallerSet.size() == 1;
            if (isSingleNode) {
                Optional blockEntity = ((class_3218)this.world).method_35230((class_2338)smallerSet.stream().findAny().get(), SpectrumBlockEntities.PASTEL_NODE);
                if (!blockEntity.isPresent()) continue;
                ((PastelNodeBlockEntity)blockEntity.get()).setNetworkUUID(null);
                disconnectedBEs.add((PastelNodeBlockEntity)blockEntity.get());
                continue;
            }
            UUID newNetworkUUID = null;
            ObjectArraySet blockEntities = new ObjectArraySet();
            for (class_2338 pos : smallerSet) {
                Optional blockEntity = ((class_3218)this.world).method_35230(pos, SpectrumBlockEntities.PASTEL_NODE);
                if (!blockEntity.isPresent()) continue;
                disconnectedBEs.add((PastelNodeBlockEntity)blockEntity.get());
                blockEntities.add((PastelNodeBlockEntity)blockEntity.get());
                if (newNetworkUUID != null) continue;
                newNetworkUUID = ((PastelNodeBlockEntity)blockEntity.get()).getNodeId();
            }
            ServerPastelNetwork newNetwork = Pastel.getServerInstance().createNetwork((class_3218)this.world, newNetworkUUID);
            Object2ObjectArrayMap edges = new Object2ObjectArrayMap();
            for (class_2338 class_23382 : smallerSet) {
                for (DefaultEdge edge : this.graph.edgesOf((Object)class_23382)) {
                    edges.put((class_2338)this.graph.getEdgeSource((Object)edge), (class_2338)this.graph.getEdgeTarget((Object)edge));
                }
                Optional couldBeANode = ((class_3218)this.getWorld()).method_35230(class_23382, SpectrumBlockEntities.PASTEL_NODE);
                if (!couldBeANode.isPresent()) continue;
                PastelNodeBlockEntity pastelNode = (PastelNodeBlockEntity)couldBeANode.get();
                newNetwork.addNode(pastelNode);
                pastelNode.setNetworkUUID(newNetwork.getUUID());
            }
            for (Map.Entry entry : edges.entrySet()) {
                newNetwork.addEdge((class_2338)entry.getKey(), (class_2338)entry.getValue());
            }
        }
        for (PastelNodeBlockEntity p : disconnectedBEs) {
            this.removeNode(p, NodeRemovalReason.REMOVED);
        }
        SpectrumS2CPacketSender.syncPastelNetworkEdges(this, sourcePos);
        this.transmissionLogic.invalidateCache();
    }

    protected void incorporate(ServerPastelNetwork networkToIncorporate, class_2338 trackingPos) {
        for (Map.Entry<PastelNodeType, Set<PastelNodeBlockEntity>> nodesToIncorporate : networkToIncorporate.loadedNodes.entrySet()) {
            for (PastelNodeBlockEntity nodeToIncorporate : nodesToIncorporate.getValue()) {
                this.addNode(nodeToIncorporate);
            }
        }
        networkToIncorporate.graph.vertexSet().forEach(pos -> {
            class_2586 patt0$temp = ((class_3218)this.world).method_8321(pos);
            if (patt0$temp instanceof PastelNodeBlockEntity) {
                PastelNodeBlockEntity switchNode = (PastelNodeBlockEntity)patt0$temp;
                switchNode.setNetworkUUID(this.uuid);
            }
            this.graph.addVertex(pos);
        });
        networkToIncorporate.graph.edgeSet().forEach(edge -> this.graph.addEdge((Object)((class_2338)networkToIncorporate.getGraph().getEdgeSource(edge)), (Object)((class_2338)networkToIncorporate.getGraph().getEdgeTarget(edge))));
        Pastel.getServerInstance().removeNetwork(networkToIncorporate.getUUID());
        this.transmissionLogic.invalidateCache();
        SpectrumS2CPacketSender.syncPastelNetworkEdges(this, trackingPos);
    }

    protected void removeNode(PastelNodeBlockEntity node, NodeRemovalReason reason) {
        if (!this.graph.containsVertex((Object)node.method_11016())) {
            return;
        }
        if (reason != NodeRemovalReason.UNLOADED) {
            this.graph.removeVertex((Object)node.method_11016());
        }
        this.loadedNodes.get((Object)node.getNodeType()).remove(node);
        this.removePriorityNode(node, node.getPriority());
        if (reason.checksForNetworkSplit) {
            this.checkForNetworkSplit(node.method_11016());
            SpectrumS2CPacketSender.syncPastelNetworkEdges(this, node.method_11016());
        }
    }

    @Override
    public boolean removeEdge(PastelNodeBlockEntity node, PastelNodeBlockEntity otherNode) {
        Optional<ServerPastelNetwork> network = node.getServerNetwork();
        if (network.isEmpty()) {
            throw new IllegalStateException("Attempted to remove an edge from a null network");
        }
        Optional<ServerPastelNetwork> otherNetwork = otherNode.getServerNetwork();
        if (otherNetwork.isEmpty() || !network.get().equals(otherNetwork.get())) {
            throw new IllegalArgumentException("Can't remove an edge between nodes in different networks - how did you even do this");
        }
        boolean success = super.removeEdge(node, otherNode);
        if (success) {
            this.checkForNetworkSplit(node.method_11016());
            this.transmissionLogic.invalidateCache();
            SpectrumS2CPacketSender.syncPastelNetworkEdges(this, node.method_11016());
        }
        return success;
    }

    @Override
    public boolean addEdge(PastelNodeBlockEntity node, PastelNodeBlockEntity otherNode) {
        Optional<ServerPastelNetwork> network = node.getServerNetwork();
        if (network.isEmpty()) {
            throw new IllegalStateException("Attempted to add an edge to a null network");
        }
        Optional<ServerPastelNetwork> otherNetwork = otherNode.getServerNetwork();
        if (otherNetwork.isEmpty() || !network.get().equals(otherNetwork.get())) {
            throw new IllegalArgumentException("Can't add an edge between nodes in different networks");
        }
        if (node == otherNode || network.get().hasEdge(node.method_11016(), otherNode.method_11016())) {
            return false;
        }
        boolean success = super.addEdge(node, otherNode);
        if (success) {
            this.transmissionLogic.invalidateCache();
            SpectrumS2CPacketSender.syncPastelNetworkEdges(this, node.method_11016());
        }
        return success;
    }

    protected void tick() {
        this.transmissions.tick();
        PastelNetwork.NodePriority priority = PastelNetwork.NodePriority.GENERIC;
        if (this.transferLooper.getTick() % 5 == 0) {
            priority = PastelNetwork.NodePriority.MODERATE;
        } else if (this.transferLooper.getTick() % 2 == 0) {
            priority = PastelNetwork.NodePriority.HIGH;
        }
        this.transferLooper.tick();
        boolean cap = this.transferLooper.reachedCap();
        if (cap || priority != PastelNetwork.NodePriority.GENERIC) {
            if (cap) {
                this.transferLooper.reset();
            }
            try {
                this.transmissionLogic.tick(priority);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.tickNodeEffects();
    }

    private void tickNodeEffects() {
        ArrayList<PastelNodeBlockEntity> nodeSync = new ArrayList<PastelNodeBlockEntity>();
        for (Map.Entry<PastelTransmission, Integer> entry : this.transmissions) {
            class_2586 node;
            int travelTime;
            double progress;
            PastelTransmission transmission = entry.getKey();
            Integer remainingTravelTime = entry.getValue();
            List<class_2338> nodes = transmission.getNodePositions();
            if (nodes.isEmpty() || (progress = (double)((travelTime = transmission.getTransmissionDuration()) - remainingTravelTime)) == 0.0 || progress % (double)transmission.getVertexTime() != 0.0 || !((node = ((class_3218)this.world).method_8321(nodes.get((int)Math.round((double)(nodes.size() - 1) * progress / (double)travelTime)))) instanceof PastelNodeBlockEntity)) continue;
            PastelNodeBlockEntity pastelNode = (PastelNodeBlockEntity)node;
            nodeSync.add(pastelNode);
            if (!pastelNode.isSensor()) continue;
            pastelNode.notifySensor();
        }
        if (!nodeSync.isEmpty()) {
            SpectrumS2CPacketSender.sendPastelNodeStatusUpdate(nodeSync, false);
        }
    }

    public void addTransmission(PastelTransmission transmission, int travelTime) {
        transmission.setNetwork(this);
        this.transmissions.put(transmission, travelTime);
    }

    public class_2487 toNbt() {
        class_2487 nbt = new class_2487();
        nbt.method_25927("UUID", this.uuid);
        nbt.method_10582("World", ((class_3218)this.getWorld()).method_27983().method_29177().toString());
        nbt.method_10566("Graph", (class_2520)this.graphToNbt());
        nbt.method_10566("Looper", this.transferLooper.toNbt());
        class_2499 transmissionList = new class_2499();
        for (Map.Entry<PastelTransmission, Integer> entry : this.transmissions) {
            class_2487 transmissionCompound = new class_2487();
            transmissionCompound.method_10569("Delay", entry.getValue().intValue());
            transmissionCompound.method_10566("Transmission", (class_2520)entry.getKey().toNbt());
            transmissionList.add((Object)transmissionCompound);
        }
        nbt.method_10566("Transmissions", (class_2520)transmissionList);
        return nbt;
    }

    public static Optional<ServerPastelNetwork> fromNbt(class_2487 nbt) {
        UUID uuid = nbt.method_25926("UUID");
        class_3218 world = SpectrumCommon.minecraftServer.method_3847(class_5321.method_29179((class_5321)class_7924.field_41223, (class_2960)class_2960.method_12829((String)nbt.method_10558("World"))));
        ServerPastelNetwork network = new ServerPastelNetwork(world, uuid);
        network.graph = ServerPastelNetwork.graphFromNbt(nbt.method_10562("Graph"));
        if (network.graph.edgeSet().isEmpty()) {
            SpectrumCommon.logError("Tried to load a Pastel Network without any edges");
            return Optional.empty();
        }
        if (network.graph.vertexSet().isEmpty()) {
            SpectrumCommon.logError("Tried to load a Pastel Network without any vertices");
            return Optional.empty();
        }
        if (nbt.method_10573("Looper", 10)) {
            network.transferLooper.readNbt(nbt.method_10562("Looper"));
        }
        for (class_2520 e : nbt.method_10554("Transmissions", 10)) {
            class_2487 t = (class_2487)e;
            int delay = t.method_10550("Delay");
            PastelTransmission transmission = PastelTransmission.fromNbt(t.method_10562("Transmission"));
            network.addTransmission(transmission, delay);
        }
        return Optional.of(network);
    }
}

