/*
 * Decompiled with CFR 0.152.
 */
package de.dafuqs.spectrum.blocks.pedestal;

import de.dafuqs.spectrum.SpectrumCommon;
import de.dafuqs.spectrum.blocks.pedestal.PedestalBlockEntity;
import de.dafuqs.spectrum.recipe.pedestal.PedestalRecipe;
import de.dafuqs.spectrum.registries.client.SpectrumRenderLayers;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1263;
import net.minecraft.class_1799;
import net.minecraft.class_1860;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import net.minecraft.class_5603;
import net.minecraft.class_5606;
import net.minecraft.class_5607;
import net.minecraft.class_5609;
import net.minecraft.class_5610;
import net.minecraft.class_5614;
import net.minecraft.class_630;
import net.minecraft.class_7833;
import net.minecraft.class_811;
import net.minecraft.class_827;
import org.jetbrains.annotations.Nullable;

@Environment(value=EnvType.CLIENT)
public class PedestalBlockEntityRenderer<C extends PedestalBlockEntity>
implements class_827<C> {
    private final class_2960 GROUND_MARK = SpectrumCommon.locate("textures/misc/circle.png");
    private final class_630 circle;
    private static final int RECIPE_RECALCULATION_TICKS = 4;
    @Nullable
    private class_1860<?> cachedRecipe;
    private long cachedRecipeTime = 0L;
    private class_1799 cachedRecipeOutput = class_1799.field_8037;

    public PedestalBlockEntityRenderer(class_5614.class_5615 ctx) {
        this.circle = PedestalBlockEntityRenderer.getTexturedModelData().method_32109().method_32086("circle");
    }

    public static class_5607 getTexturedModelData() {
        class_5609 modelData = new class_5609();
        class_5610 modelPartData = modelData.method_32111();
        modelPartData.method_32117("circle", class_5606.method_32108(), class_5603.method_32090((float)8.0f, (float)0.1f, (float)8.0f));
        modelPartData.method_32116("circle").method_32117("circle2", class_5606.method_32108().method_32101(0, 0).method_32097(-32.0f, 0.0f, -29.0f, 64.0f, 0.0f, 64.0f), class_5603.method_32092((float)0.0f, (float)0.0f, (float)0.0f));
        return class_5607.method_32110((class_5609)modelData, (int)256, (int)256);
    }

    public void render(PedestalBlockEntity entity, float tickDelta, class_4587 matrixStack, class_4597 vertexConsumerProvider, int light, int overlay) {
        if (entity.method_10997() == null) {
            return;
        }
        class_1860<?> currentRecipe = entity.getCurrentRecipe();
        if (currentRecipe instanceof PedestalRecipe) {
            PedestalRecipe pedestalRecipe = (PedestalRecipe)currentRecipe;
            float time = (float)(entity.method_10997().method_8510() % 50000L) + tickDelta;
            this.circle.field_3675 = time / 25.0f;
            this.circle.method_22698(matrixStack, vertexConsumerProvider.getBuffer(SpectrumRenderLayers.GlowInTheDarkRenderLayer.get(this.GROUND_MARK)), light, overlay);
            long currentTime = entity.method_10997().method_8510();
            if (this.cachedRecipeTime + 4L < currentTime || this.cachedRecipe != pedestalRecipe) {
                this.cachedRecipeOutput = pedestalRecipe.method_8116((class_1263)entity, entity.method_10997().method_30349());
                this.cachedRecipe = pedestalRecipe;
                this.cachedRecipeTime = currentTime;
            }
            matrixStack.method_22903();
            double height = Math.sin((double)time / 8.0) / 6.0;
            matrixStack.method_22904(0.5, 1.3 + height, 0.5);
            matrixStack.method_22907(class_7833.field_40716.rotationDegrees(time * 2.0f));
            class_310.method_1551().method_1480().method_23178(this.cachedRecipeOutput, class_811.field_4318, 0xF000F0, overlay, matrixStack, vertexConsumerProvider, entity.method_10997(), 0);
            matrixStack.method_22909();
        }
    }
}

