/*
 * Decompiled with CFR 0.152.
 */
package de.dafuqs.spectrum.compat.REI.plugins;

import de.dafuqs.matchbooks.recipe.IngredientStack;
import de.dafuqs.spectrum.api.recipe.GatedRecipe;
import de.dafuqs.spectrum.compat.REI.GatedSpectrumDisplay;
import de.dafuqs.spectrum.compat.REI.REIHelper;
import de.dafuqs.spectrum.compat.REI.SpectrumPlugins;
import de.dafuqs.spectrum.recipe.pedestal.BuiltinGemstoneColor;
import de.dafuqs.spectrum.recipe.pedestal.PedestalRecipe;
import de.dafuqs.spectrum.recipe.pedestal.PedestalRecipeTier;
import java.util.Collections;
import java.util.List;
import me.shedaniel.rei.api.common.category.CategoryIdentifier;
import me.shedaniel.rei.api.common.display.basic.BasicDisplay;
import me.shedaniel.rei.api.common.entry.EntryIngredient;
import me.shedaniel.rei.api.common.util.EntryIngredients;
import net.minecraft.class_1263;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1935;
import net.minecraft.class_2371;
import net.minecraft.class_310;

public class PedestalCraftingDisplay
extends GatedSpectrumDisplay {
    protected final PedestalRecipeTier pedestalRecipeTier;
    protected final int width;
    protected final int height;
    protected final float experience;
    protected final int craftingTime;
    public boolean shapeless;

    public PedestalCraftingDisplay(PedestalRecipe recipe) {
        super((GatedRecipe<? extends class_1263>)recipe, PedestalCraftingDisplay.mapIngredients(recipe), Collections.singletonList(EntryIngredients.of((class_1799)recipe.method_8110(BasicDisplay.registryAccess()))));
        this.pedestalRecipeTier = recipe.getTier();
        this.width = recipe.getWidth();
        this.height = recipe.getHeight();
        this.experience = recipe.getExperience();
        this.craftingTime = recipe.getCraftingTime();
        this.shapeless = recipe.isShapeless();
    }

    private static List<EntryIngredient> mapIngredients(PedestalRecipe recipe) {
        int i;
        int powderSlotCount = recipe.getTier().getPowderSlotCount();
        List<IngredientStack> ingredients = recipe.getIngredientStacks();
        int ingredientCount = ingredients.size();
        class_2371 list = class_2371.method_10213((int)(9 + powderSlotCount), (Object)EntryIngredient.empty());
        for (i = 0; i < ingredientCount; ++i) {
            list.set(recipe.getGridSlotId(i), REIHelper.ofIngredientStack(recipe.getIngredientStacks().get(i)));
        }
        for (i = 0; i < powderSlotCount; ++i) {
            BuiltinGemstoneColor color = BuiltinGemstoneColor.values()[i];
            int powderAmount = recipe.getPowderInputs().getOrDefault(color, 0);
            if (powderAmount <= 0) continue;
            list.set(9 + i, EntryIngredients.of((class_1935)color.getGemstonePowderItem(), (int)powderAmount));
        }
        return list;
    }

    public CategoryIdentifier<?> getCategoryIdentifier() {
        return SpectrumPlugins.PEDESTAL_CRAFTING;
    }

    @Override
    public boolean isUnlocked() {
        class_310 client = class_310.method_1551();
        return this.pedestalRecipeTier.hasUnlocked((class_1657)client.field_1724) && super.isUnlocked();
    }

    public PedestalRecipeTier getTier() {
        return this.pedestalRecipeTier;
    }
}

