/*
 * Decompiled with CFR 0.152.
 */
package de.dafuqs.spectrum.compat.REI.plugins;

import de.dafuqs.revelationary.api.advancements.AdvancementHelper;
import de.dafuqs.spectrum.api.recipe.FluidIngredient;
import de.dafuqs.spectrum.api.recipe.GatedRecipe;
import de.dafuqs.spectrum.compat.REI.FluidIngredientREI;
import de.dafuqs.spectrum.compat.REI.GatedSpectrumDisplay;
import de.dafuqs.spectrum.compat.REI.REIHelper;
import de.dafuqs.spectrum.compat.REI.SpectrumPlugins;
import de.dafuqs.spectrum.recipe.titration_barrel.FermentationData;
import de.dafuqs.spectrum.recipe.titration_barrel.ITitrationBarrelRecipe;
import de.dafuqs.spectrum.recipe.titration_barrel.TitrationBarrelRecipe;
import java.util.List;
import me.shedaniel.rei.api.common.category.CategoryIdentifier;
import me.shedaniel.rei.api.common.display.basic.BasicDisplay;
import me.shedaniel.rei.api.common.entry.EntryIngredient;
import me.shedaniel.rei.api.common.util.EntryIngredients;
import net.minecraft.class_1263;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import org.jetbrains.annotations.NotNull;

public class TitrationBarrelDisplay
extends GatedSpectrumDisplay {
    protected final EntryIngredient tappingIngredient;
    protected final int minFermentationTimeHours;
    protected final FermentationData fermentationData;

    public TitrationBarrelDisplay(@NotNull ITitrationBarrelRecipe recipe) {
        super((GatedRecipe<? extends class_1263>)recipe, TitrationBarrelDisplay.buildInputs(recipe), List.of(TitrationBarrelDisplay.buildOutputs(recipe)));
        this.tappingIngredient = recipe.getTappingItem() == class_1802.field_8162 ? EntryIngredient.empty() : EntryIngredients.of((class_1799)recipe.getTappingItem().method_7854());
        this.minFermentationTimeHours = recipe.getMinFermentationTimeHours();
        this.fermentationData = recipe.getFermentationData();
    }

    private static EntryIngredient buildOutputs(ITitrationBarrelRecipe recipe) {
        TitrationBarrelRecipe titrationBarrelRecipe;
        if (recipe instanceof TitrationBarrelRecipe && (titrationBarrelRecipe = (TitrationBarrelRecipe)recipe).getFermentationData() != null) {
            return EntryIngredients.ofItemStacks(titrationBarrelRecipe.getOutputVariations(TitrationBarrelRecipe.FERMENTATION_DURATION_DISPLAY_TIME_MULTIPLIERS));
        }
        return EntryIngredients.of((class_1799)recipe.method_8110(BasicDisplay.registryAccess()));
    }

    public static List<EntryIngredient> buildInputs(ITitrationBarrelRecipe recipe) {
        List<EntryIngredient> inputs = REIHelper.toEntryIngredients(recipe.getIngredientStacks());
        if (recipe.getFluidInput() != FluidIngredient.EMPTY) {
            inputs.add(FluidIngredientREI.into(recipe.getFluidInput()));
        }
        return inputs;
    }

    public CategoryIdentifier<?> getCategoryIdentifier() {
        return SpectrumPlugins.TITRATION_BARREL;
    }

    @Override
    public boolean isUnlocked() {
        class_310 client = class_310.method_1551();
        return AdvancementHelper.hasAdvancement((class_1657)client.field_1724, (class_2960)TitrationBarrelRecipe.UNLOCK_ADVANCEMENT_IDENTIFIER) && super.isUnlocked();
    }
}

