/*
 * Decompiled with CFR 0.152.
 */
package de.dafuqs.spectrum.compat.modonomicon.pages;

import com.google.common.collect.Maps;
import com.google.gson.JsonObject;
import com.klikli_dev.modonomicon.book.BookTextHolder;
import com.klikli_dev.modonomicon.book.RenderedBookTextHolder;
import com.klikli_dev.modonomicon.book.conditions.BookCondition;
import com.klikli_dev.modonomicon.book.conditions.BookNoneCondition;
import com.klikli_dev.modonomicon.book.page.BookTextPage;
import com.klikli_dev.modonomicon.client.gui.book.markdown.BookTextRenderer;
import com.klikli_dev.modonomicon.util.BookGsonHelper;
import de.dafuqs.spectrum.compat.modonomicon.ModonomiconCompat;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.class_2540;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3518;
import net.minecraft.class_5250;

public class BookChecklistPage
extends BookTextPage {
    private final Map<class_2960, BookTextHolder> checklist;

    public BookChecklistPage(BookTextHolder title, BookTextHolder text, boolean useMarkdownInTitle, boolean showTitleSeparator, String anchor, BookCondition condition, Map<class_2960, BookTextHolder> checklist) {
        super(title, text, useMarkdownInTitle, showTitleSeparator, anchor, condition);
        this.checklist = checklist;
    }

    public static BookChecklistPage fromJson(JsonObject json) {
        BookTextHolder title = BookGsonHelper.getAsBookTextHolder((JsonObject)json, (String)"title", (BookTextHolder)BookTextHolder.EMPTY);
        boolean useMarkdownInTitle = class_3518.method_15258((JsonObject)json, (String)"use_markdown_title", (boolean)false);
        boolean showTitleSeparator = class_3518.method_15258((JsonObject)json, (String)"show_title_separator", (boolean)true);
        BookTextHolder text = BookGsonHelper.getAsBookTextHolder((JsonObject)json, (String)"text", (BookTextHolder)BookTextHolder.EMPTY);
        String anchor = class_3518.method_15253((JsonObject)json, (String)"anchor", (String)"");
        BookNoneCondition condition = json.has("condition") ? BookCondition.fromJson((JsonObject)json.getAsJsonObject("condition")) : new BookNoneCondition();
        JsonObject checklistObject = class_3518.method_15281((JsonObject)json, (String)"checklist", (JsonObject)new JsonObject());
        LinkedHashMap<class_2960, BookTextHolder> checklist = new LinkedHashMap<class_2960, BookTextHolder>();
        for (String key : checklistObject.keySet()) {
            BookTextHolder value = BookGsonHelper.getAsBookTextHolder((JsonObject)checklistObject, (String)key, (BookTextHolder)BookTextHolder.EMPTY);
            checklist.put(new class_2960(key), value);
        }
        return new BookChecklistPage(title, text, useMarkdownInTitle, showTitleSeparator, anchor, (BookCondition)condition, checklist);
    }

    public static BookChecklistPage fromNetwork(class_2540 buffer) {
        BookTextHolder title = BookTextHolder.fromNetwork((class_2540)buffer);
        boolean useMarkdownInTitle = buffer.readBoolean();
        boolean showTitleSeparator = buffer.readBoolean();
        BookTextHolder text = BookTextHolder.fromNetwork((class_2540)buffer);
        String anchor = buffer.method_19772();
        BookCondition condition = BookCondition.fromNetwork((class_2540)buffer);
        LinkedHashMap checklist = (LinkedHashMap)buffer.method_34069(Maps::newLinkedHashMapWithExpectedSize, class_2540::method_10810, BookTextHolder::fromNetwork);
        return new BookChecklistPage(title, text, useMarkdownInTitle, showTitleSeparator, anchor, condition, checklist);
    }

    public Map<class_2960, BookTextHolder> getChecklist() {
        return this.checklist;
    }

    public void prerenderMarkdown(BookTextRenderer textRenderer) {
        super.prerenderMarkdown(textRenderer);
        ArrayList<class_5250> mutableTexts = new ArrayList<class_5250>();
        int i = 1;
        for (Map.Entry<class_2960, BookTextHolder> entry : this.checklist.entrySet()) {
            BookTextHolder entryText = entry.getValue();
            List rendered = textRenderer.render(entryText.getString());
            class_5250 parent = class_2561.method_43470((String)String.format("%d. ", i));
            for (class_5250 mutableText : rendered) {
                parent.method_10852((class_2561)mutableText);
            }
            parent.method_10852((class_2561)class_2561.method_43470((String)""));
            mutableTexts.add(parent);
            ++i;
        }
        BookTextHolder bookTextHolder = this.text;
        if (bookTextHolder instanceof RenderedBookTextHolder) {
            RenderedBookTextHolder renderedText = (RenderedBookTextHolder)bookTextHolder;
            mutableTexts.addAll(renderedText.getRenderedText());
        } else {
            mutableTexts.add(this.text.getComponent().method_27661());
        }
        this.text = new RenderedBookTextHolder(new BookTextHolder(""), mutableTexts);
    }

    public class_2960 getType() {
        return ModonomiconCompat.CHECKLIST_PAGE;
    }

    public void toNetwork(class_2540 buffer) {
        super.toNetwork(buffer);
        buffer.method_34063(this.checklist, class_2540::method_10812, (buf, value) -> value.toNetwork(buf));
    }
}

