/*
 * Decompiled with CFR 0.152.
 */
package de.dafuqs.spectrum.compat.modonomicon.pages;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.klikli_dev.modonomicon.Modonomicon;
import com.klikli_dev.modonomicon.book.BookTextHolder;
import com.klikli_dev.modonomicon.book.conditions.BookCondition;
import com.klikli_dev.modonomicon.book.conditions.BookNoneCondition;
import com.klikli_dev.modonomicon.book.entries.ContentBookEntry;
import com.klikli_dev.modonomicon.book.page.BookTextPage;
import com.klikli_dev.modonomicon.util.BookGsonHelper;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import de.dafuqs.spectrum.compat.modonomicon.ModonomiconCompat;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_1074;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2287;
import net.minecraft.class_2290;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_3518;
import net.minecraft.class_5455;
import net.minecraft.class_7157;
import net.minecraft.class_7699;

public class BookCollectionPage
extends BookTextPage {
    private final List<String> itemStrings;
    private final List<class_1799> items;

    public BookCollectionPage(BookTextHolder title, BookTextHolder text, boolean useMarkdownInTitle, boolean showTitleSeparator, String anchor, BookCondition condition, List<String> itemStrings) {
        super(title, text, useMarkdownInTitle, showTitleSeparator, anchor, condition);
        this.itemStrings = itemStrings;
        this.items = new ArrayList<class_1799>(itemStrings.size());
    }

    public static BookCollectionPage fromJson(JsonObject json) {
        BookTextHolder title = BookGsonHelper.getAsBookTextHolder((JsonObject)json, (String)"title", (BookTextHolder)BookTextHolder.EMPTY);
        boolean useMarkdownInTitle = class_3518.method_15258((JsonObject)json, (String)"use_markdown_title", (boolean)false);
        boolean showTitleSeparator = class_3518.method_15258((JsonObject)json, (String)"show_title_separator", (boolean)true);
        BookTextHolder text = BookGsonHelper.getAsBookTextHolder((JsonObject)json, (String)"text", (BookTextHolder)BookTextHolder.EMPTY);
        String anchor = class_3518.method_15253((JsonObject)json, (String)"anchor", (String)"");
        BookNoneCondition condition = json.has("condition") ? BookCondition.fromJson((JsonObject)json.getAsJsonObject("condition")) : new BookNoneCondition();
        List<String> items = class_3518.method_15292((JsonObject)json, (String)"items", (JsonArray)new JsonArray()).asList().stream().map(JsonElement::getAsString).toList();
        return new BookCollectionPage(title, text, useMarkdownInTitle, showTitleSeparator, anchor, (BookCondition)condition, items);
    }

    public static BookCollectionPage fromNetwork(class_2540 buffer) {
        BookTextHolder title = BookTextHolder.fromNetwork((class_2540)buffer);
        boolean useMarkdownInTitle = buffer.readBoolean();
        boolean showTitleSeparator = buffer.readBoolean();
        BookTextHolder text = BookTextHolder.fromNetwork((class_2540)buffer);
        String anchor = buffer.method_19772();
        BookCondition condition = BookCondition.fromNetwork((class_2540)buffer);
        List items = buffer.method_34066(class_2540::method_19772);
        return new BookCollectionPage(title, text, useMarkdownInTitle, showTitleSeparator, anchor, condition, items);
    }

    public List<class_1799> getItems() {
        return this.items;
    }

    public class_2960 getType() {
        return ModonomiconCompat.COLLECTION_PAGE;
    }

    public void build(class_1937 world, ContentBookEntry parentEntry, int pageNum) {
        super.build(world, parentEntry, pageNum);
        for (String itemString : this.itemStrings) {
            try {
                class_7157.class_7870 access = class_7157.method_46723((class_5455)world.method_30349(), (class_7699)world.method_45162());
                class_2287 argumentType = new class_2287((class_7157)access);
                class_2290 argument = argumentType.method_9778(new StringReader(itemString));
                this.items.add(argument.method_9781(1, false));
            }
            catch (CommandSyntaxException e) {
                Modonomicon.LOG.warn("Unable to parse stack {} in collection page", (Object)itemString);
            }
        }
    }

    public void toNetwork(class_2540 buffer) {
        super.toNetwork(buffer);
        buffer.method_34062(this.itemStrings, class_2540::method_10814);
    }

    public boolean matchesQuery(String query) {
        return super.matchesQuery(query) || this.items.stream().map(class_1799::method_7922).map(x$0 -> class_1074.method_4662((String)x$0, (Object[])new Object[0])).map(String::toLowerCase).anyMatch(string -> string.contains(query));
    }
}

