/*
 * Decompiled with CFR 0.152.
 */
package de.dafuqs.spectrum.data_loaders;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import de.dafuqs.revelationary.api.advancements.AdvancementHelper;
import de.dafuqs.spectrum.SpectrumCommon;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.fabricmc.fabric.api.resource.IdentifiableResourceReloadListener;
import net.minecraft.class_1657;
import net.minecraft.class_2396;
import net.minecraft.class_2960;
import net.minecraft.class_3300;
import net.minecraft.class_3518;
import net.minecraft.class_3695;
import net.minecraft.class_4309;
import net.minecraft.class_7923;
import org.jetbrains.annotations.Nullable;

public class ParticleSpawnerParticlesDataLoader
extends class_4309
implements IdentifiableResourceReloadListener {
    public static final String ID = "particle_spawner_particles";
    public static final ParticleSpawnerParticlesDataLoader INSTANCE = new ParticleSpawnerParticlesDataLoader();
    protected static final List<ParticleSpawnerEntry> PARTICLES = new ArrayList<ParticleSpawnerEntry>();

    private ParticleSpawnerParticlesDataLoader() {
        super(new Gson(), ID);
    }

    protected void apply(Map<class_2960, JsonElement> prepared, class_3300 manager, class_3695 profiler) {
        PARTICLES.clear();
        prepared.forEach((identifier, jsonElement) -> {
            JsonObject jsonObject = jsonElement.getAsJsonObject();
            String particleTypeString = jsonObject.get("particle_type").getAsString();
            class_2396 particleType = (class_2396)class_7923.field_41180.method_10223(class_2960.method_12829((String)particleTypeString));
            class_2960 guiTexture = class_2960.method_12829((String)jsonObject.get("gui_texture").getAsString());
            class_2960 unlockIdentifier = jsonObject.has("unlock_identifier") ? class_2960.method_12829((String)jsonObject.get("unlock_identifier").getAsString()) : null;
            boolean supportsColoring = class_3518.method_15258((JsonObject)jsonObject, (String)"supports_coloring", (boolean)false);
            if (particleType == null) {
                SpectrumCommon.logError("Particle Spawner Particle '" + particleTypeString + "' not found. Will be ignored.");
                return;
            }
            PARTICLES.add(new ParticleSpawnerEntry(particleType, guiTexture, supportsColoring, unlockIdentifier));
        });
    }

    public class_2960 getFabricId() {
        return SpectrumCommon.locate(ID);
    }

    public static List<ParticleSpawnerEntry> getAllUnlocked(class_1657 player) {
        ArrayList<ParticleSpawnerEntry> list = new ArrayList<ParticleSpawnerEntry>();
        for (ParticleSpawnerEntry entry : PARTICLES) {
            if (!AdvancementHelper.hasAdvancement((class_1657)player, (class_2960)entry.unlockIdentifier())) continue;
            list.add(entry);
        }
        return list;
    }

    public record ParticleSpawnerEntry(class_2396<?> particleType, class_2960 textureIdentifier, boolean supportsColoring, @Nullable class_2960 unlockIdentifier) {
    }
}

