/*
 * Decompiled with CFR 0.152.
 */
package de.dafuqs.spectrum.data_loaders;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import de.dafuqs.spectrum.SpectrumCommon;
import de.dafuqs.spectrum.api.interaction.ResonanceDropProcessor;
import de.dafuqs.spectrum.api.interaction.ResonanceDropProcessors;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.fabricmc.fabric.api.resource.IdentifiableResourceReloadListener;
import net.minecraft.class_1799;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_3300;
import net.minecraft.class_3518;
import net.minecraft.class_3695;
import net.minecraft.class_4309;

public class ResonanceDropsDataLoader
extends class_4309
implements IdentifiableResourceReloadListener {
    public static final String ID = "resonance_drops";
    public static final ResonanceDropsDataLoader INSTANCE = new ResonanceDropsDataLoader();
    protected static final List<ResonanceDropProcessor> RESONANCE_DROPS = new ArrayList<ResonanceDropProcessor>();
    public static boolean preventNextXPDrop;

    private ResonanceDropsDataLoader() {
        super(new Gson(), ID);
    }

    protected void apply(Map<class_2960, JsonElement> prepared, class_3300 manager, class_3695 profiler) {
        RESONANCE_DROPS.clear();
        prepared.forEach((identifier, jsonElement) -> {
            JsonObject json = jsonElement.getAsJsonObject();
            class_2960 processorType = class_2960.method_12829((String)class_3518.method_15265((JsonObject)json, (String)"type"));
            ResonanceDropProcessor.Serializer serializer = ResonanceDropProcessors.get(processorType);
            if (serializer == null) {
                SpectrumCommon.logError("Unknown ResonanceDropProcessor " + String.valueOf(processorType) + " in file " + String.valueOf(identifier));
                return;
            }
            try {
                RESONANCE_DROPS.add(serializer.fromJson(json));
            }
            catch (Exception e) {
                SpectrumCommon.logError("Error parsing ResonanceDropProcessor " + String.valueOf(identifier) + ": " + e.getLocalizedMessage());
            }
        });
    }

    public class_2960 getFabricId() {
        return SpectrumCommon.locate(ID);
    }

    public static void applyResonance(class_2680 minedState, class_2586 blockEntity, List<class_1799> droppedStacks) {
        for (ResonanceDropProcessor entry : RESONANCE_DROPS) {
            entry.process(minedState, blockEntity, droppedStacks);
        }
    }
}

