/*
 * Decompiled with CFR 0.152.
 */
package de.dafuqs.spectrum.data_loaders.resonance_processors;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import de.dafuqs.spectrum.api.interaction.ResonanceDropProcessor;
import de.dafuqs.spectrum.api.predicate.block.BrokenBlockPredicate;
import de.dafuqs.spectrum.data_loaders.ResonanceDropsDataLoader;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_1799;
import net.minecraft.class_2487;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_3518;

public class DropSelfResonanceProcessor
extends ResonanceDropProcessor {
    public List<String> nbtToCopy;
    public List<String> statePropertiesToCopy;
    public boolean includeDefaultStateProperties;

    public DropSelfResonanceProcessor(BrokenBlockPredicate blockTarget, List<String> nbtToCopy, List<String> statePropertiesToCopy, boolean includeDefaultStateProperties) throws Exception {
        super(blockTarget);
        this.nbtToCopy = nbtToCopy;
        this.statePropertiesToCopy = statePropertiesToCopy;
        this.includeDefaultStateProperties = includeDefaultStateProperties;
    }

    @Override
    public boolean process(class_2680 state, class_2586 blockEntity, List<class_1799> droppedStacks) {
        if (this.blockPredicate.test(state)) {
            this.dropSelf(state, blockEntity, droppedStacks);
            ResonanceDropsDataLoader.preventNextXPDrop = true;
            return true;
        }
        return false;
    }

    public void copyBlockStateTags(class_2680 minedState, class_1799 convertedStack) {
        for (class_2769 blockProperty : minedState.method_28501()) {
            if (!this.statePropertiesToCopy.contains(blockProperty.method_11899()) || !this.includeDefaultStateProperties && minedState.method_26204().method_9564().method_11654(blockProperty) == minedState.method_11654(blockProperty)) continue;
            class_2487 nbt = convertedStack.method_7911("BlockStateTag");
            nbt.method_10582(blockProperty.method_11899(), DropSelfResonanceProcessor.getPropertyName(minedState, blockProperty));
        }
    }

    private static <T extends Comparable<T>> String getPropertyName(class_2680 state, class_2769<T> property) {
        return property.method_11901(state.method_11654(property));
    }

    public void copyNbt(class_2586 blockEntity, class_1799 convertedStack) {
        class_2487 newNbt = new class_2487();
        class_2487 beNbt = blockEntity.method_38244();
        for (String s : this.nbtToCopy) {
            if (!beNbt.method_10545(s)) continue;
            newNbt.method_10566(s, beNbt.method_10580(s));
        }
        if (!newNbt.method_33133()) {
            convertedStack.method_7911("BlockEntityTag").method_10543(newNbt);
        }
    }

    private void dropSelf(class_2680 minedState, class_2586 blockEntity, List<class_1799> droppedStacks) {
        class_1799 selfStack = minedState.method_26204().method_8389().method_7854();
        if (!this.statePropertiesToCopy.isEmpty()) {
            this.copyBlockStateTags(minedState, selfStack);
        }
        if (!this.nbtToCopy.isEmpty()) {
            this.copyNbt(blockEntity, selfStack);
        }
        droppedStacks.clear();
        droppedStacks.add(selfStack);
    }

    public static class Serializer
    implements ResonanceDropProcessor.Serializer {
        @Override
        public ResonanceDropProcessor fromJson(JsonObject json) throws Exception {
            BrokenBlockPredicate blockTarget = BrokenBlockPredicate.fromJson(json.get("block"));
            ArrayList<String> statePropertiesToCopy = new ArrayList<String>();
            if (json.has("state_properties_to_copy")) {
                for (Object e : class_3518.method_15261((JsonObject)json, (String)"state_properties_to_copy")) {
                    statePropertiesToCopy.add(e.getAsString());
                }
            }
            ArrayList<String> nbtToCopy = new ArrayList<String>();
            if (json.has("nbt_to_copy")) {
                for (JsonElement e : class_3518.method_15261((JsonObject)json, (String)"nbt_to_copy")) {
                    nbtToCopy.add(e.getAsString());
                }
            }
            boolean includeDefaultStateProperties = class_3518.method_15258((JsonObject)json, (String)"include_default_state_properties", (boolean)false);
            return new DropSelfResonanceProcessor(blockTarget, nbtToCopy, statePropertiesToCopy, includeDefaultStateProperties);
        }
    }
}

