/*
 * Decompiled with CFR 0.152.
 */
package de.dafuqs.spectrum.entity.entity;

import de.dafuqs.spectrum.entity.SpectrumEntityTypes;
import de.dafuqs.spectrum.entity.SpectrumTrackedDataHandlerRegistry;
import de.dafuqs.spectrum.items.tools.GlassArrowVariant;
import de.dafuqs.spectrum.registries.SpectrumRegistries;
import de.dafuqs.spectrum.spells.MoonstoneStrike;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1665;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2394;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2940;
import net.minecraft.class_2945;
import net.minecraft.class_2960;
import net.minecraft.class_3417;
import net.minecraft.class_3965;
import net.minecraft.class_3966;
import net.minecraft.class_5134;

public class GlassArrowEntity
extends class_1665 {
    private static final String VARIANT_STRING = "variant";
    private static final class_2940<GlassArrowVariant> VARIANT = class_2945.method_12791(GlassArrowEntity.class, SpectrumTrackedDataHandlerRegistry.GLASS_ARROW_VARIANT);
    public static final float DAMAGE_MODIFIER = 1.25f;

    public GlassArrowEntity(class_1299<? extends GlassArrowEntity> entityType, class_1937 world) {
        super(entityType, world);
    }

    public GlassArrowEntity(class_1937 world, class_1309 owner) {
        super(SpectrumEntityTypes.GLASS_ARROW, owner, world);
        this.method_7438(this.method_7448() * 1.25);
    }

    public GlassArrowEntity(class_1937 world, double x, double y, double z) {
        super(SpectrumEntityTypes.GLASS_ARROW, x, y, z, world);
        this.method_7438(this.method_7448() * 1.25);
    }

    public void method_7435(class_1309 entity, float damageModifier) {
        super.method_7435(entity, damageModifier);
        this.method_7438(this.method_7448() * 1.25);
    }

    public void method_5773() {
        super.method_5773();
        if (this.method_37908().method_8608() && (!this.field_7588 || this.method_37908().method_8510() % 8L == 0L)) {
            this.spawnParticles(1);
        }
    }

    private void spawnParticles(int amount) {
        class_2394 particleType = this.getVariant().getParticleEffect();
        if (particleType != null) {
            for (int j = 0; j < amount; ++j) {
                this.method_37908().method_8406(particleType, this.method_23322(0.5), this.method_23319(), this.method_23325(0.5), 0.0, 0.0, 0.0);
            }
        }
    }

    protected void method_7454(class_3966 entityHitResult) {
        class_1309 livingEntityToResetHurtTime = null;
        class_1937 world = this.method_37908();
        int invincibilityFrameStore = 0;
        GlassArrowVariant variant = this.getVariant();
        if (variant == GlassArrowVariant.TOPAZ) {
            if (!this.method_37908().method_8608() && this.method_24921() != null) {
                class_1297 entity = entityHitResult.method_17782();
                GlassArrowEntity.pullEntityClose(this.method_24921(), entity, 0.2);
            }
        } else if (variant == GlassArrowVariant.AMETHYST) {
            if (!this.method_37908().method_8608()) {
                class_1297 entity = entityHitResult.method_17782();
                entity.method_32317(200);
            }
        } else if (variant == GlassArrowVariant.ONYX) {
            class_1297 entity = entityHitResult.method_17782();
            if (entity instanceof class_1309) {
                class_1309 livingEntity = (class_1309)entity;
                invincibilityFrameStore = livingEntity.field_6235;
                livingEntity.field_6235 = 0;
                livingEntityToResetHurtTime = livingEntity;
                livingEntity.method_6056(20.0f);
                livingEntity.method_6105(world.method_48963().method_48831(), 20.0f);
            }
        } else if (variant == GlassArrowVariant.MOONSTONE) {
            MoonstoneStrike.create(world, (class_1297)this, null, this.method_23317(), this.method_23318(), this.method_23321(), 4.0f);
        }
        super.method_7454(entityHitResult);
        if (livingEntityToResetHurtTime != null) {
            livingEntityToResetHurtTime.field_6235 = invincibilityFrameStore;
        }
        this.method_5783(class_3417.field_15081, 0.75f, 0.9f + world.field_9229.method_43057() * 0.2f);
        this.method_5650(class_1297.class_5529.field_26999);
    }

    protected void method_24920(class_3965 blockHitResult) {
        super.method_24920(blockHitResult);
        if (this.getVariant() == GlassArrowVariant.MOONSTONE) {
            MoonstoneStrike.create(this.method_37908(), (class_1297)this, null, this.method_23317(), this.method_23318(), this.method_23321(), 4.0f);
        }
    }

    protected static void pullEntityClose(class_1297 shooter, class_1297 entityToPull, double pullStrength) {
        double d = shooter.method_23317() - entityToPull.method_23317();
        double e = shooter.method_23318() - entityToPull.method_23318();
        double f = shooter.method_23321() - entityToPull.method_23321();
        double pullStrengthModifier = 1.0;
        if (entityToPull instanceof class_1309) {
            class_1309 livingEntity = (class_1309)entityToPull;
            pullStrengthModifier = Math.max(0.0, 1.0 - livingEntity.method_26825(class_5134.field_23718));
        }
        class_243 additionalVelocity = new class_243(d * pullStrength, e * pullStrength + Math.sqrt(Math.sqrt(d * d + e * e + f * f)) * 0.08, f * pullStrength).method_1021(pullStrengthModifier);
        entityToPull.method_5762(additionalVelocity.field_1352, additionalVelocity.field_1351, additionalVelocity.field_1350);
    }

    protected class_1799 method_7445() {
        return ((GlassArrowVariant)this.field_6011.method_12789(VARIANT)).getArrow().method_7854();
    }

    protected float method_7436() {
        return 0.85f;
    }

    protected void method_5693() {
        super.method_5693();
        this.field_6011.method_12784(VARIANT, (Object)GlassArrowVariant.MALACHITE);
    }

    public GlassArrowVariant getVariant() {
        return (GlassArrowVariant)this.field_6011.method_12789(VARIANT);
    }

    public void setVariant(GlassArrowVariant variant) {
        this.field_6011.method_12778(VARIANT, (Object)variant);
        if (variant == GlassArrowVariant.CITRINE) {
            this.method_7449(5);
        }
    }

    public void method_5652(class_2487 nbt) {
        super.method_5652(nbt);
        nbt.method_10582(VARIANT_STRING, SpectrumRegistries.GLASS_ARROW_VARIANT.method_10221((Object)this.getVariant()).toString());
    }

    public void method_5749(class_2487 nbt) {
        super.method_5749(nbt);
        GlassArrowVariant variant = (GlassArrowVariant)SpectrumRegistries.GLASS_ARROW_VARIANT.method_10223(class_2960.method_12829((String)nbt.method_10558(VARIANT_STRING)));
        if (variant != null) {
            this.setVariant(variant);
        }
    }
}

