/*
 * Decompiled with CFR 0.152.
 */
package de.dafuqs.spectrum.entity.entity;

import com.google.common.collect.Sets;
import de.dafuqs.spectrum.SpectrumCommon;
import de.dafuqs.spectrum.entity.SpectrumEntityTypes;
import de.dafuqs.spectrum.entity.entity.LightShardBaseEntity;
import java.util.List;
import java.util.Set;
import java.util.function.Predicate;
import net.minecraft.class_1293;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1676;
import net.minecraft.class_1844;
import net.minecraft.class_1937;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2520;
import net.minecraft.class_2940;
import net.minecraft.class_2941;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_2960;
import net.minecraft.class_6017;
import org.jetbrains.annotations.Nullable;

public class LightMineEntity
extends LightShardBaseEntity {
    private static final int NO_POTION_COLOR = -1;
    private static final class_2940<Integer> COLOR = class_2945.method_12791(LightMineEntity.class, (class_2941)class_2943.field_13327);
    private boolean colorSet;
    protected final Set<class_1293> effects = Sets.newHashSet();

    public LightMineEntity(class_1299<? extends class_1676> entityType, class_1937 world) {
        super(entityType, world);
    }

    public LightMineEntity(class_1937 world, class_1309 owner, float detectionRange, float damage, float lifeSpanTicks) {
        super(SpectrumEntityTypes.LIGHT_MINE, world, owner, detectionRange, damage, lifeSpanTicks);
    }

    public static void summonBarrage(class_1937 world, @Nullable class_1309 user, @Nullable class_1309 target, Predicate<class_1309> targetPredicate, List<class_1293> effects, class_243 position, class_6017 count) {
        LightMineEntity.summonBarrageInternal(world, user, () -> {
            LightMineEntity mine = new LightMineEntity(world, user, 8.0f, 1.0f, 800.0f);
            mine.setEffects(effects);
            return mine;
        }, target, targetPredicate, position, count);
    }

    public void setEffects(List<class_1293> effects) {
        this.effects.addAll(effects);
        if (this.effects.isEmpty()) {
            this.setColor(0xFFFFFF);
        } else {
            this.setColor(class_1844.method_8055(this.effects));
        }
    }

    public int getColor() {
        return (Integer)this.field_6011.method_12789(COLOR);
    }

    private void setColor(int color) {
        this.colorSet = true;
        this.field_6011.method_12778(COLOR, (Object)color);
    }

    @Override
    protected void method_5652(class_2487 nbt) {
        super.method_5652(nbt);
        if (this.colorSet) {
            nbt.method_10569("Color", this.getColor());
        }
        if (!this.effects.isEmpty()) {
            class_2499 nbtList = new class_2499();
            for (class_1293 statusEffectInstance : this.effects) {
                nbtList.add((Object)statusEffectInstance.method_5582(new class_2487()));
            }
            nbt.method_10566("CustomPotionEffects", (class_2520)nbtList);
        }
    }

    @Override
    protected void method_5749(class_2487 nbt) {
        super.method_5749(nbt);
        this.setEffects(class_1844.method_8060((class_2487)nbt));
        if (nbt.method_10573("Color", 99)) {
            this.setColor(nbt.method_10550("Color"));
        } else {
            this.colorSet = false;
            if (this.effects.isEmpty()) {
                this.field_6011.method_12778(COLOR, (Object)-1);
            } else {
                this.field_6011.method_12778(COLOR, (Object)class_1844.method_8055(this.effects));
            }
        }
    }

    @Override
    public class_2960 getTexture() {
        return SpectrumCommon.locate("textures/entity/projectile/light_mine.png");
    }

    @Override
    protected void method_5693() {
        super.method_5693();
        this.field_6011.method_12784(COLOR, (Object)-1);
    }

    @Override
    public void method_5773() {
        super.method_5773();
        if (this.method_37908().method_8608() && this.field_6012 % 4 == 0) {
            this.spawnParticles();
        }
    }

    private void spawnParticles() {
        if (!this.effects.isEmpty()) {
            int color = this.getColor();
            double d = (double)(color >> 16 & 0xFF) / 255.0;
            double e = (double)(color >> 8 & 0xFF) / 255.0;
            double f = (double)(color & 0xFF) / 255.0;
            this.method_37908().method_8406((class_2394)class_2398.field_11226, this.method_23322(0.5), this.method_23319(), this.method_23325(0.5), d, e, f);
        }
    }

    @Override
    protected void onHitEntity(class_1309 attacked) {
        super.onHitEntity(attacked);
        class_1297 attacker = this.method_37225();
        for (class_1293 statusEffectInstance : this.effects) {
            attacked.method_37222(new class_1293(statusEffectInstance.method_5579(), Math.max(statusEffectInstance.method_5584() / 8, 1), statusEffectInstance.method_5578(), statusEffectInstance.method_5591(), statusEffectInstance.method_5581()), attacker);
        }
        if (!this.effects.isEmpty()) {
            for (class_1293 statusEffectInstance : this.effects) {
                attacked.method_37222(statusEffectInstance, attacker);
            }
        }
    }
}

