/*
 * Decompiled with CFR 0.152.
 */
package de.dafuqs.spectrum.inventories;

import de.dafuqs.spectrum.SpectrumCommon;
import de.dafuqs.spectrum.helpers.ColorHelper;
import de.dafuqs.spectrum.helpers.LoreHelper;
import de.dafuqs.spectrum.inventories.SpectrumScreenHandlerTypes;
import de.dafuqs.spectrum.items.PigmentItem;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import net.minecraft.class_1263;
import net.minecraft.class_155;
import net.minecraft.class_156;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1735;
import net.minecraft.class_1772;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1887;
import net.minecraft.class_1890;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_2680;
import net.minecraft.class_3481;
import net.minecraft.class_3914;
import net.minecraft.class_3915;
import net.minecraft.class_4861;
import net.minecraft.class_5250;
import net.minecraft.class_5251;
import net.minecraft.class_8047;
import org.apache.commons.lang3.StringUtils;

public class BedrockAnvilScreenHandler
extends class_4861 {
    public static final int MAX_LORE_LENGTH = 200;
    public static final int FIRST_INPUT_SLOT_INDEX = 0;
    public static final int SECOND_INPUT_SLOT_INDEX = 1;
    public static final int OUTPUT_SLOT_INDEX = 2;
    private final class_3915 levelCost = class_3915.method_17403();
    private int repairItemCount;
    private String newItemName;
    private String newLoreString;

    public BedrockAnvilScreenHandler(int syncId, class_1661 inventory) {
        this(syncId, inventory, class_3914.field_17304);
    }

    public BedrockAnvilScreenHandler(int syncId, class_1661 inventory, class_3914 context) {
        super(SpectrumScreenHandlerTypes.BEDROCK_ANVIL, syncId, inventory, context);
        this.method_17362(this.levelCost);
    }

    protected class_8047 method_48352() {
        return class_8047.method_48364().method_48374(0, 27, 47, stack -> true).method_48374(1, 76, 47, stack -> true).method_48373(2, 134, 47).method_48372();
    }

    public void method_48353(class_1661 playerInventory) {
        int i;
        for (i = 0; i < 3; ++i) {
            for (int j = 0; j < 9; ++j) {
                this.method_7621(new class_1735((class_1263)playerInventory, j + i * 9 + 9, 8 + j * 18, 108 + i * 18));
            }
        }
        for (i = 0; i < 9; ++i) {
            this.method_7621(new class_1735((class_1263)playerInventory, i, 8 + i * 18, 166));
        }
    }

    protected boolean method_24925(class_2680 state) {
        return state.method_26164(class_3481.field_15486);
    }

    public static int getNextCost(int cost) {
        return cost * 2 + 1;
    }

    public void method_7609(class_1263 inventory) {
        super.method_7609(inventory);
        if (inventory == this.field_22480) {
            this.method_24928();
        }
    }

    public void method_7595(class_1657 player) {
        super.method_7595(player);
        this.field_22481.method_17393((world, pos) -> this.method_7607(player, this.field_22480));
    }

    public boolean method_7597(class_1657 player) {
        return (Boolean)this.field_22481.method_17396((world, pos) -> this.method_24925(world.method_8320(pos)) && player.method_5649((double)pos.method_10263() + 0.5, (double)pos.method_10264() + 0.5, (double)pos.method_10260() + 0.5) <= 64.0, (Object)true);
    }

    protected boolean method_24927(class_1657 player, boolean present) {
        return player.method_31549().field_7477 || player.field_7520 >= this.levelCost.method_17407();
    }

    protected void method_24923(class_1657 player, class_1799 stack) {
        if (!player.method_31549().field_7477) {
            player.method_7316(-this.levelCost.method_17407());
        }
        this.field_22480.method_5447(0, class_1799.field_8037);
        if (this.repairItemCount > 0) {
            class_1799 itemStack = this.field_22480.method_5438(1);
            if (!itemStack.method_7960() && itemStack.method_7947() > this.repairItemCount) {
                itemStack.method_7934(this.repairItemCount);
                this.field_22480.method_5447(1, itemStack);
            } else {
                this.field_22480.method_5447(1, class_1799.field_8037);
            }
        } else {
            this.field_22480.method_5447(1, class_1799.field_8037);
        }
        this.levelCost.method_17404(0);
        this.field_22481.method_17393((world, pos) -> world.method_20290(1030, pos, 0));
    }

    public void method_24928() {
        boolean combined = false;
        class_1799 inputStack = this.field_22480.method_5438(0);
        this.levelCost.method_17404(0);
        int enchantmentLevelCost = 0;
        int repairLevelCost = 0;
        int k = 0;
        if (inputStack.method_7960()) {
            this.field_22479.method_5447(0, class_1799.field_8037);
            this.levelCost.method_17404(0);
        } else {
            class_1799 outputStack = inputStack.method_7972();
            class_1799 repairSlotStack = this.field_22480.method_5438(1);
            Map enchantmentLevelMap = class_1890.method_8222((class_1799)outputStack);
            repairLevelCost += inputStack.method_7928() + (repairSlotStack.method_7960() ? 0 : repairSlotStack.method_7928());
            this.repairItemCount = 0;
            boolean pigmentInRepairSlot = repairSlotStack.method_7909() instanceof PigmentItem;
            if (pigmentInRepairSlot) {
                this.repairItemCount = 1;
            }
            if (!repairSlotStack.method_7960()) {
                boolean enchantedBookInRepairSlot;
                combined = true;
                boolean enchantedBookInInputSlot = inputStack.method_31574(class_1802.field_8598) && !class_1772.method_7806((class_1799)inputStack).isEmpty();
                boolean bl = enchantedBookInRepairSlot = repairSlotStack.method_31574(class_1802.field_8598) && !class_1772.method_7806((class_1799)repairSlotStack).isEmpty();
                if (outputStack.method_7963() && outputStack.method_7909().method_7878(inputStack, repairSlotStack)) {
                    o = Math.min(outputStack.method_7919(), outputStack.method_7936() / 4);
                    if (o <= 0) {
                        this.field_22479.method_5447(0, class_1799.field_8037);
                        this.levelCost.method_17404(0);
                        return;
                    }
                    for (repairItemCount = 0; o > 0 && repairItemCount < repairSlotStack.method_7947(); ++repairItemCount) {
                        int newOutputStackDamage = outputStack.method_7919() - o;
                        outputStack.method_7974(newOutputStackDamage);
                        ++enchantmentLevelCost;
                        o = Math.min(outputStack.method_7919(), outputStack.method_7936() / 4);
                    }
                    this.repairItemCount = repairItemCount;
                } else {
                    if (!(pigmentInRepairSlot || enchantedBookInRepairSlot || outputStack.method_31574(repairSlotStack.method_7909()) && outputStack.method_7963())) {
                        this.field_22479.method_5447(0, class_1799.field_8037);
                        this.levelCost.method_17404(0);
                        return;
                    }
                    if (outputStack.method_7963() && !enchantedBookInRepairSlot && !pigmentInRepairSlot) {
                        o = inputStack.method_7936() - inputStack.method_7919();
                        repairItemCount = repairSlotStack.method_7936() - repairSlotStack.method_7919();
                        int newOutputStackDamage = repairItemCount + outputStack.method_7936() * 12 / 100;
                        int r = o + newOutputStackDamage;
                        int s = outputStack.method_7936() - r;
                        if (s < 0) {
                            s = 0;
                        }
                        if (s < outputStack.method_7919()) {
                            outputStack.method_7974(s);
                            enchantmentLevelCost += 2;
                        }
                    }
                    Map currentEnchantments = class_1890.method_8222((class_1799)repairSlotStack);
                    boolean bl2 = false;
                    boolean bl3 = false;
                    Iterator enchantmentIterator = currentEnchantments.keySet().iterator();
                    while (true) {
                        int enchantmentRarityInt;
                        boolean capToMaxLevel;
                        int newEnchantmentLevel;
                        if (!enchantmentIterator.hasNext()) {
                            if (!bl3 || bl2) break;
                            this.field_22479.method_5447(0, class_1799.field_8037);
                            this.levelCost.method_17404(0);
                            return;
                        }
                        class_1887 enchantment = (class_1887)enchantmentIterator.next();
                        if (enchantment == null) continue;
                        int t = enchantmentLevelMap.getOrDefault(enchantment, 0);
                        newEnchantmentLevel = t == (newEnchantmentLevel = ((Integer)currentEnchantments.get(enchantment)).intValue()) ? newEnchantmentLevel + 1 : Math.max(newEnchantmentLevel, t);
                        boolean itemStackIsAcceptableForStack = enchantment.method_8192(inputStack);
                        if (this.field_22482.method_31549().field_7477 || inputStack.method_31574(class_1802.field_8598)) {
                            itemStackIsAcceptableForStack = true;
                        }
                        for (class_1887 enchantment2 : enchantmentLevelMap.keySet()) {
                            if (enchantment2 == enchantment || enchantment.method_8188(enchantment2)) continue;
                            itemStackIsAcceptableForStack = false;
                            ++enchantmentLevelCost;
                        }
                        if (!itemStackIsAcceptableForStack) {
                            bl3 = true;
                            continue;
                        }
                        bl2 = true;
                        boolean bl4 = capToMaxLevel = enchantedBookInInputSlot || !SpectrumCommon.CONFIG.BedrockAnvilCanExceedMaxVanillaEnchantmentLevel;
                        if (capToMaxLevel && newEnchantmentLevel > enchantment.method_8183()) {
                            newEnchantmentLevel = enchantment.method_8183();
                        }
                        enchantmentLevelMap.put(enchantment, newEnchantmentLevel);
                        switch (enchantment.method_8186()) {
                            default: {
                                throw new IncompatibleClassChangeError();
                            }
                            case field_9087: {
                                int n = 1;
                                break;
                            }
                            case field_9090: {
                                int n = 2;
                                break;
                            }
                            case field_9088: {
                                int n = 4;
                                break;
                            }
                            case field_9091: {
                                int n = enchantmentRarityInt = 8;
                            }
                        }
                        if (enchantedBookInRepairSlot) {
                            enchantmentRarityInt = Math.max(1, enchantmentRarityInt / 2);
                        }
                        enchantmentLevelCost += enchantmentRarityInt * newEnchantmentLevel;
                        if (inputStack.method_7947() <= 1) continue;
                        enchantmentLevelCost = 40;
                    }
                }
            }
            if (this.newItemName != null && !class_156.method_51894((String)this.newItemName)) {
                if (!this.newItemName.equals(inputStack.method_7964().getString())) {
                    class_5250 inputText;
                    class_2561 enchantedBookInRepairSlot = inputStack.method_7964();
                    if (enchantedBookInRepairSlot instanceof class_5250 && (inputText = (class_5250)enchantedBookInRepairSlot).method_10866().method_10973() != null) {
                        outputStack.method_7977((class_2561)class_2561.method_43470((String)this.newItemName).method_10862(class_2583.field_24360.method_27703(inputText.method_10866().method_10973())));
                    } else {
                        outputStack.method_7977((class_2561)class_2561.method_43470((String)this.newItemName));
                    }
                }
            } else if (inputStack.method_7938()) {
                outputStack.method_7925();
            }
            class_2561 text = outputStack.method_7964();
            if (pigmentInRepairSlot && text instanceof class_5250) {
                class_5250 mutableText = (class_5250)text;
                class_5251 newColor = class_5251.method_27717((int)ColorHelper.getInt(((PigmentItem)repairSlotStack.method_7909()).getColor()));
                class_5250 newName = mutableText.method_10862(mutableText.method_10866().method_27703(newColor));
                if (!newName.equals((Object)inputStack.method_7964())) {
                    outputStack.method_7977((class_2561)newName);
                }
            }
            if (this.newLoreString != null && !class_156.method_51894((String)this.newLoreString)) {
                List<class_2561> lore = LoreHelper.getLoreTextArrayFromString(this.newLoreString);
                if (!LoreHelper.equalsLore(lore, inputStack)) {
                    LoreHelper.setLore(outputStack, lore);
                }
            } else if (inputStack.method_7938()) {
                LoreHelper.removeLore(outputStack);
            }
            this.levelCost.method_17404(repairLevelCost + enchantmentLevelCost);
            if (enchantmentLevelCost < 0) {
                outputStack = class_1799.field_8037;
            }
            if (!combined || pigmentInRepairSlot) {
                this.levelCost.method_17404(0);
            } else if (!outputStack.method_7960()) {
                int repairCost = outputStack.method_7928();
                if (!repairSlotStack.method_7960() && repairCost < repairSlotStack.method_7928()) {
                    repairCost = repairSlotStack.method_7928();
                }
                if (k != enchantmentLevelCost) {
                    repairCost = BedrockAnvilScreenHandler.getNextCost(repairCost);
                    outputStack.method_7927(repairCost);
                }
                class_1890.method_8214((Map)enchantmentLevelMap, (class_1799)outputStack);
            }
            this.field_22479.method_5447(0, outputStack);
            this.method_7623();
        }
    }

    public boolean setNewItemName(String newItemName) {
        String string = BedrockAnvilScreenHandler.sanitize(newItemName, 50);
        if (!string.equals(this.newItemName)) {
            this.newItemName = string;
            if (this.method_7611(2).method_7681()) {
                class_1799 itemStack = this.method_7611(2).method_7677();
                if (class_156.method_51894((String)string)) {
                    itemStack.method_7925();
                } else {
                    itemStack.method_7977((class_2561)class_2561.method_43470((String)string));
                }
            }
            this.method_24928();
            return true;
        }
        return false;
    }

    private static String sanitize(String name, int maxLength) {
        String s = class_155.method_644((String)name);
        return s.length() > maxLength ? s.substring(0, maxLength) : s;
    }

    public boolean setNewItemLore(String newLoreString) {
        String string = BedrockAnvilScreenHandler.sanitize(newLoreString, 200);
        if (!string.equals(this.newLoreString)) {
            this.newLoreString = string;
            if (this.method_7611(2).method_7681()) {
                class_1799 itemStack = this.method_7611(2).method_7677();
                if (StringUtils.isBlank((CharSequence)newLoreString)) {
                    LoreHelper.removeLore(itemStack);
                } else {
                    LoreHelper.setLore(itemStack, LoreHelper.getLoreTextArrayFromString(this.newLoreString));
                }
            }
            this.method_24928();
            return true;
        }
        return false;
    }

    public int getLevelCost() {
        return this.levelCost.method_17407();
    }
}

