/*
 * Decompiled with CFR 0.152.
 */
package de.dafuqs.spectrum.inventories.widgets;

import de.dafuqs.revelationary.api.advancements.AdvancementHelper;
import de.dafuqs.spectrum.api.energy.color.InkColor;
import de.dafuqs.spectrum.api.energy.color.InkColors;
import de.dafuqs.spectrum.blocks.energy.ColorPickerBlockEntity;
import de.dafuqs.spectrum.helpers.RenderHelper;
import de.dafuqs.spectrum.registries.SpectrumSoundEvents;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_339;
import net.minecraft.class_3419;
import net.minecraft.class_3532;
import net.minecraft.class_3545;
import net.minecraft.class_437;
import net.minecraft.class_6381;
import net.minecraft.class_6382;
import org.jetbrains.annotations.Nullable;

@Environment(value=EnvType.CLIENT)
public class ColorSelectionWidget
extends class_339 {
    protected final ColorPickerBlockEntity colorPicker;
    @Nullable
    private Consumer<InkColor> changedListener;
    protected final class_437 screen;
    final List<class_3545<InkColor, Boolean>> usableColors = new ArrayList<class_3545<InkColor, Boolean>>();
    final int selectedDotX;
    final int selectedDotY;

    public ColorSelectionWidget(int x, int y, int selectedDotX, int selectedDotY, class_437 screen, ColorPickerBlockEntity colorPicker) {
        this(x, y, selectedDotX, selectedDotY, screen, colorPicker, InkColors.BUILTIN_COLORS);
    }

    public ColorSelectionWidget(int x, int y, int selectedDotX, int selectedDotY, class_437 screen, ColorPickerBlockEntity colorPicker, List<InkColor> availableColors) {
        super(x, y, 56, 14, (class_2561)class_2561.method_43470((String)""));
        this.colorPicker = colorPicker;
        this.selectedDotX = selectedDotX;
        this.selectedDotY = selectedDotY;
        this.screen = screen;
        for (InkColor inkColor : availableColors) {
            this.usableColors.add((class_3545<InkColor, Boolean>)new class_3545((Object)inkColor, (Object)AdvancementHelper.hasAdvancementClient((class_2960)inkColor.getRequiredAdvancement())));
        }
    }

    public void setChangedListener(@Nullable Consumer<InkColor> changedListener) {
        this.changedListener = changedListener;
    }

    private void onChanged(InkColor newColor) {
        if (this.changedListener != null) {
            this.changedListener.accept(newColor);
        }
    }

    protected void method_48579(class_332 context, int mouseX, int mouseY, float delta) {
    }

    public boolean method_25402(double mouseX, double mouseY, int button) {
        boolean colorSelectionClicked;
        class_310 client = class_310.method_1551();
        if (this.isUnselection(mouseX, mouseY)) {
            client.field_1724.method_17356(SpectrumSoundEvents.BUTTON_CLICK, class_3419.field_15254, 1.0f, 1.0f);
            this.onChanged(null);
        }
        boolean bl = colorSelectionClicked = mouseX >= (double)this.method_46426() && mouseX < (double)(this.method_46426() + this.field_22758) && mouseY >= (double)this.method_46427() && mouseY < (double)(this.method_46427() + this.field_22759);
        if (colorSelectionClicked && button == 0) {
            int yOffset;
            int verticalColorOffset;
            int xOffset = class_3532.method_15357((double)mouseX) - this.method_46426();
            int horizontalColorOffset = xOffset / 7;
            int newColorIndex = horizontalColorOffset + (verticalColorOffset = (yOffset = class_3532.method_15357((double)mouseY) - this.method_46427()) / 7) * 8;
            class_3545<InkColor, Boolean> clickedColor = this.usableColors.get(newColorIndex);
            if (((Boolean)clickedColor.method_15441()).booleanValue()) {
                client.field_1724.method_17356(SpectrumSoundEvents.BUTTON_CLICK, class_3419.field_15254, 1.0f, 1.0f);
                this.onChanged((InkColor)clickedColor.method_15442());
            } else {
                client.field_1724.method_17356(SpectrumSoundEvents.USE_FAIL, class_3419.field_15254, 1.0f, 1.0f);
                this.onChanged(null);
            }
            return true;
        }
        return false;
    }

    protected void method_47399(class_6382 builder) {
        builder.method_37034(class_6381.field_33788, (class_2561)class_2561.method_43469((String)"spectrum.narration.color_selection", (Object[])new Object[]{this.colorPicker.getSelectedColor()}));
    }

    public void draw(class_332 drawContext) {
        int i = -1;
        int currentX = this.method_46426() + 1;
        int currentY = this.method_46427() + 1;
        for (class_3545<InkColor, Boolean> color : this.usableColors) {
            if (((Boolean)color.method_15441()).booleanValue()) {
                RenderHelper.fillQuad(drawContext.method_51448(), currentX, currentY, 5, 5, ((InkColor)color.method_15442()).getColorVec());
            }
            currentX += 7;
            if (++i != 7) continue;
            currentY += 7;
            currentX = this.method_46426() + 1;
        }
        InkColor selectedColor = this.colorPicker.getSelectedColor();
        if (selectedColor != null) {
            RenderHelper.fillQuad(drawContext.method_51448(), this.selectedDotX, this.selectedDotY, 4, 4, selectedColor.getColorVec());
        }
    }

    private boolean isUnselection(double mouseX, double mouseY) {
        return mouseX >= (double)this.selectedDotX && mouseX < (double)(this.selectedDotX + 4) && mouseY >= (double)this.selectedDotY && mouseY < (double)(this.selectedDotY + 4);
    }

    public boolean method_25405(double mouseX, double mouseY) {
        return super.method_25405(mouseX, mouseY) || this.field_22763 && this.field_22764 && this.isUnselection(mouseX, mouseY);
    }

    public void drawMouseoverTooltip(class_332 drawContext, int mouseX, int mouseY) {
        boolean overUnselection;
        class_310 client = class_310.method_1551();
        boolean bl = overUnselection = (double)mouseX >= (double)this.selectedDotX && (double)mouseX < (double)(this.selectedDotX + 4) && (double)mouseY >= (double)this.selectedDotY && (double)mouseY < (double)(this.selectedDotY + 4);
        if (overUnselection) {
            drawContext.method_51437(client.field_1772, List.of(class_2561.method_43471((String)"spectrum.tooltip.ink_powered.unselect_color")), Optional.empty(), this.method_46426(), this.method_46427());
        } else {
            int yOffset;
            int verticalColorOffset;
            int xOffset = class_3532.method_15375((float)mouseX) - this.method_46426();
            int horizontalColorOffset = xOffset / 7;
            int newColorIndex = horizontalColorOffset + (verticalColorOffset = (yOffset = class_3532.method_15375((float)mouseY) - this.method_46427()) / 7) * 8;
            class_3545<InkColor, Boolean> hoveredColor = this.usableColors.get(newColorIndex);
            if (((Boolean)hoveredColor.method_15441()).booleanValue()) {
                drawContext.method_51437(client.field_1772, List.of(((InkColor)hoveredColor.method_15442()).getName()), Optional.empty(), this.method_46426(), this.method_46427());
            } else {
                drawContext.method_51437(client.field_1772, List.of(class_2561.method_43471((String)"spectrum.tooltip.ink_powered.unselect_color")), Optional.empty(), this.method_46426(), this.method_46427());
            }
        }
    }
}

