/*
 * Decompiled with CFR 0.152.
 */
package de.dafuqs.spectrum.items.energy;

import de.dafuqs.spectrum.SpectrumCommon;
import de.dafuqs.spectrum.api.energy.InkStorage;
import de.dafuqs.spectrum.api.energy.InkStorageItem;
import de.dafuqs.spectrum.api.energy.color.InkColor;
import de.dafuqs.spectrum.api.energy.storage.IndividualCappedInkStorage;
import de.dafuqs.spectrum.api.item.LoomPatternProvider;
import de.dafuqs.spectrum.api.render.ExtendedItemBarProvider;
import de.dafuqs.spectrum.helpers.ColorHelper;
import de.dafuqs.spectrum.helpers.Support;
import de.dafuqs.spectrum.items.trinkets.SpectrumTrinketItem;
import de.dafuqs.spectrum.registries.SpectrumBannerPatterns;
import de.dafuqs.spectrum.registries.SpectrumRegistries;
import java.util.ArrayList;
import java.util.List;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_124;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_1937;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_2582;
import net.minecraft.class_310;
import net.minecraft.class_6880;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PigmentPaletteItem
extends SpectrumTrinketItem
implements InkStorageItem<IndividualCappedInkStorage>,
LoomPatternProvider,
ExtendedItemBarProvider {
    private final long maxEnergyPerColor;

    public PigmentPaletteItem(class_1792.class_1793 settings, long maxEnergyPerColor) {
        super(settings, SpectrumCommon.locate("unlocks/trinkets/pigment_palette"));
        this.maxEnergyPerColor = maxEnergyPerColor;
    }

    @Override
    public InkStorageItem.Drainability getDrainability() {
        return InkStorageItem.Drainability.PLAYER_ONLY;
    }

    @Override
    public IndividualCappedInkStorage getEnergyStorage(class_1799 itemStack) {
        class_2487 compound = itemStack.method_7969();
        if (compound != null && compound.method_10545("EnergyStore")) {
            return IndividualCappedInkStorage.fromNbt(compound.method_10562("EnergyStore"));
        }
        return new IndividualCappedInkStorage(this.maxEnergyPerColor);
    }

    @Override
    public class_1799 method_7854() {
        return super.method_7854();
    }

    @Override
    public void setEnergyStorage(class_1799 itemStack, InkStorage storage) {
        if (storage instanceof IndividualCappedInkStorage) {
            IndividualCappedInkStorage pigmentPaletteInkStorage = (IndividualCappedInkStorage)storage;
            class_2487 compound = itemStack.method_7948();
            compound.method_10566("EnergyStore", (class_2520)pigmentPaletteInkStorage.toNbt());
        }
    }

    @Environment(value=EnvType.CLIENT)
    public void method_7851(class_1799 stack, @Nullable class_1937 world, List<class_2561> tooltip, class_1836 context) {
        super.method_7851(stack, world, tooltip, context);
        tooltip.add((class_2561)class_2561.method_43471((String)"item.spectrum.pigment_palette.tooltip.target").method_27692(class_124.field_1080));
        this.getEnergyStorage(stack).addTooltip(tooltip);
        this.addBannerPatternProviderTooltip(tooltip);
    }

    @Override
    public class_6880<class_2582> getPattern() {
        return SpectrumBannerPatterns.PALETTE;
    }

    @Override
    public int barCount(class_1799 stack) {
        return 1;
    }

    @Override
    public ExtendedItemBarProvider.BarSignature getSignature(@Nullable class_1657 player, @NotNull class_1799 stack, int index) {
        IndividualCappedInkStorage storage = this.getEnergyStorage(stack);
        ArrayList<InkColor> colors = new ArrayList<InkColor>();
        if (player == null || storage.isEmpty()) {
            return ExtendedItemBarProvider.PASS;
        }
        long time = player.method_37908().method_8510() % 864000L;
        for (InkColor inkColor : SpectrumRegistries.INK_COLORS) {
            if (storage.getEnergy(inkColor) <= 0L) continue;
            colors.add(inkColor);
        }
        int progress = Support.getSensiblePercent(storage.getCurrentTotal(), storage.getMaxTotal(), 14);
        if (colors.size() == 1) {
            InkColor color = (InkColor)colors.get(0);
            return new ExtendedItemBarProvider.BarSignature(1, 13, 14, progress, 1, color.getColorInt() | 0xFF000000, 2, -16777216);
        }
        float delta = class_310.method_1551().method_1488();
        InkColor curColor = (InkColor)colors.get((int)(time % (30L * (long)colors.size()) / 30L));
        InkColor nextColor = (InkColor)colors.get((int)((time % (30L * (long)colors.size()) / 30L + 1L) % (long)colors.size()));
        float blendFactor = ((float)time + delta) % 30.0f / 30.0f;
        int blendedColor = ColorHelper.interpolate(curColor.getTextColorVec(), nextColor.getTextColorVec(), blendFactor);
        return new ExtendedItemBarProvider.BarSignature(1, 13, 14, progress, 1, blendedColor, 2, -16777216);
    }
}

