/*
 * Decompiled with CFR 0.152.
 */
package de.dafuqs.spectrum.items.magic_items;

import de.dafuqs.spectrum.api.energy.InkPowered;
import de.dafuqs.spectrum.api.energy.color.InkColor;
import de.dafuqs.spectrum.api.energy.color.InkColors;
import de.dafuqs.spectrum.api.item.PrioritizedBlockInteraction;
import de.dafuqs.spectrum.compat.claims.GenericClaimModsCompat;
import de.dafuqs.spectrum.helpers.BuildingHelper;
import de.dafuqs.spectrum.registries.SpectrumBlockTags;
import net.minecraft.class_1268;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1750;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2680;
import net.minecraft.class_3965;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import oshi.util.tuples.Triplet;

public abstract class BuildingStaffItem
extends class_1792
implements PrioritizedBlockInteraction,
InkPowered {
    public static final InkColor USED_COLOR = InkColors.CYAN;

    public BuildingStaffItem(class_1792.class_1793 settings) {
        super(settings);
    }

    public boolean canInteractWith(class_2680 state, class_1922 world, class_2338 pos, class_1657 player) {
        if (state.method_26204().method_8389() == class_1802.field_8162) {
            return false;
        }
        if (player == null || world.method_8321(pos) != null || state.method_26164(SpectrumBlockTags.BUILDING_STAFFS_BLACKLISTED)) {
            return false;
        }
        if (player.method_7337()) {
            return true;
        }
        float hardness = state.method_26214(world, pos);
        return hardness >= 0.0f && GenericClaimModsCompat.canInteract(player.method_37908(), pos, (class_1297)player);
    }

    protected static Triplet<class_2248, class_1792, Integer> countSuitableReplacementItems(@NotNull class_1657 player, @NotNull class_2248 targetBlock, boolean single, int inkCostPerBlock) {
        if (player.method_7337()) {
            return new Triplet((Object)targetBlock, (Object)targetBlock.method_8389(), (Object)(single ? 1 : Integer.MAX_VALUE));
        }
        long blocksToPlace = single ? (InkPowered.getAvailableInk(player, USED_COLOR) >= (long)inkCostPerBlock ? 1L : 0L) : InkPowered.getAvailableInk(player, USED_COLOR) / (long)inkCostPerBlock;
        blocksToPlace = Math.min(1024L, blocksToPlace);
        return BuildingHelper.getBuildingItemCountInInventoryIncludingSimilars(player, targetBlock, blocksToPlace);
    }

    public static class BuildingStaffPlacementContext
    extends class_1750 {
        public BuildingStaffPlacementContext(class_1937 world, @Nullable class_1657 playerEntity, class_3965 blockHitResult) {
            super(world, playerEntity, class_1268.field_5808, class_1799.field_8037, blockHitResult);
        }
    }
}

