/*
 * Decompiled with CFR 0.152.
 */
package de.dafuqs.spectrum.items.magic_items;

import de.dafuqs.spectrum.api.energy.InkPowered;
import de.dafuqs.spectrum.api.energy.color.InkColor;
import de.dafuqs.spectrum.compat.claims.GenericClaimModsCompat;
import de.dafuqs.spectrum.helpers.BuildingHelper;
import de.dafuqs.spectrum.helpers.InventoryHelper;
import de.dafuqs.spectrum.items.magic_items.BuildingStaffItem;
import de.dafuqs.spectrum.recipe.pedestal.PedestalRecipeTier;
import java.util.List;
import java.util.Optional;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_124;
import net.minecraft.class_1269;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1750;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_1838;
import net.minecraft.class_1922;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_2404;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_2680;
import net.minecraft.class_310;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3965;
import net.minecraft.class_4538;
import oshi.util.tuples.Triplet;

public class ConstructorsStaffItem
extends BuildingStaffItem {
    public static final int INK_COST_PER_BLOCK = 1;
    public static final int CREATIVE_RANGE = 10;

    public ConstructorsStaffItem(class_1792.class_1793 settings) {
        super(settings);
    }

    public static int getRange(class_1657 playerEntity) {
        if (playerEntity == null || playerEntity.method_7337()) {
            return 10;
        }
        Optional<PedestalRecipeTier> highestUnlockedRecipeTier = PedestalRecipeTier.getHighestUnlockedRecipeTier(playerEntity);
        if (highestUnlockedRecipeTier.isPresent()) {
            switch (highestUnlockedRecipeTier.get()) {
                case COMPLEX: {
                    return 10;
                }
                case ADVANCED: {
                    return 7;
                }
            }
            return 4;
        }
        return 3;
    }

    @Environment(value=EnvType.CLIENT)
    public void method_7851(class_1799 stack, class_1937 world, List<class_2561> tooltip, class_1836 context) {
        super.method_7851(stack, world, tooltip, context);
        tooltip.add((class_2561)class_2561.method_43469((String)"item.spectrum.constructors_staff.tooltip.range", (Object[])new Object[]{ConstructorsStaffItem.getRange((class_1657)class_310.method_1551().field_1724)}).method_27692(class_124.field_1080));
        tooltip.add((class_2561)class_2561.method_43471((String)"item.spectrum.constructors_staff.tooltip.crouch").method_27692(class_124.field_1080));
        this.addInkPoweredTooltip(tooltip);
    }

    public class_1269 method_7884(class_1838 context) {
        class_1657 player = context.method_8036();
        class_1937 world = context.method_8045();
        class_2338 pos = context.method_8037();
        class_2680 targetBlockState = world.method_8320(pos);
        if (player != null && this.canInteractWith(targetBlockState, (class_1922)context.method_8045(), context.method_8037(), context.method_8036())) {
            long count;
            class_1792 itemToConsume;
            class_2248 blockToPlace = targetBlockState.method_26204();
            if (player.method_7337()) {
                itemToConsume = blockToPlace.method_8389();
                count = Integer.MAX_VALUE;
            } else {
                Triplet<class_2248, class_1792, Integer> replaceData = ConstructorsStaffItem.countSuitableReplacementItems(player, blockToPlace, false, 1);
                blockToPlace = (class_2248)replaceData.getA();
                itemToConsume = (class_1792)replaceData.getB();
                count = ((Integer)replaceData.getC()).intValue();
            }
            if (count > 0L) {
                boolean sneaking;
                int maxRange;
                int range;
                class_2350 side = context.method_8038();
                List<class_2338> targetPositions = BuildingHelper.calculateBuildingStaffSelection(world, pos, side, count, range = (int)Math.min((long)(maxRange = ConstructorsStaffItem.getRange(player)), player.method_7337() ? (long)maxRange : count), !(sneaking = player.method_5715()));
                if (targetPositions.isEmpty()) {
                    return class_1269.field_5814;
                }
                if (!world.field_9236) {
                    ConstructorsStaffItem.placeBlocksAndDecrementInventory(player, world, blockToPlace, itemToConsume, side, targetPositions);
                }
                return class_1269.field_5812;
            }
        } else if (player != null) {
            world.method_8396(null, player.method_24515(), class_3417.field_14701, class_3419.field_15248, 1.0f, 1.0f);
        }
        return class_1269.field_5814;
    }

    protected static void placeBlocksAndDecrementInventory(class_1657 player, class_1937 world, class_2248 blockToPlace, class_1792 itemToConsume, class_2350 side, List<class_2338> targetPositions) {
        int placedBlocks = 0;
        for (class_2338 position : targetPositions) {
            class_2680 stateToPlace;
            class_2680 originalState;
            if (!GenericClaimModsCompat.canPlaceBlock(world, position, (class_1297)player) || !(originalState = world.method_8320(position)).method_26215() && !(originalState.method_26204() instanceof class_2404) && (!originalState.method_45474() || !originalState.method_26220((class_1922)world, position).method_1110()) || (stateToPlace = blockToPlace.method_9605((class_1750)new BuildingStaffItem.BuildingStaffPlacementContext(world, player, new class_3965(class_243.method_24955((class_2382)position), side, position, false)))) == null || !stateToPlace.method_26184((class_4538)world, position) || !world.method_8501(position, stateToPlace)) continue;
            if (placedBlocks == 0) {
                world.method_8396(null, player.method_24515(), stateToPlace.method_26231().method_10598(), class_3419.field_15248, stateToPlace.method_26231().method_10597(), stateToPlace.method_26231().method_10599());
            }
            ++placedBlocks;
        }
        if (!player.method_7337()) {
            InventoryHelper.removeFromInventoryWithRemainders(player, new class_1799((class_1935)itemToConsume, placedBlocks));
            InkPowered.tryDrainEnergy(player, USED_COLOR, (long)targetPositions.size() * 1L);
        }
    }

    @Override
    public List<InkColor> getUsedColors() {
        return List.of(USED_COLOR);
    }
}

