/*
 * Decompiled with CFR 0.152.
 */
package de.dafuqs.spectrum.items.trinkets;

import com.google.common.collect.Multimap;
import de.dafuqs.spectrum.api.energy.color.InkColor;
import de.dafuqs.spectrum.api.energy.storage.FixedSingleInkStorage;
import de.dafuqs.spectrum.api.item.GravitableItem;
import de.dafuqs.spectrum.items.trinkets.InkDrainTrinketItem;
import dev.emi.trinkets.api.SlotReference;
import java.util.UUID;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1320;
import net.minecraft.class_1322;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_2960;
import net.minecraft.class_5134;

public abstract class GravityRingItem
extends InkDrainTrinketItem
implements GravitableItem {
    public GravityRingItem(class_1792.class_1793 settings, class_2960 unlockIdentifier, InkColor inkColor) {
        super(settings, unlockIdentifier, inkColor);
    }

    public Multimap<class_1320, class_1322> getModifiers(class_1799 stack, SlotReference slot, class_1309 entity, UUID uuid) {
        Multimap modifiers = super.getModifiers(stack, slot, entity, uuid);
        FixedSingleInkStorage inkStorage = this.getEnergyStorage(stack);
        long storedInk = inkStorage.getEnergy(inkStorage.getStoredColor());
        double knockbackResistance = this.getBonus(storedInk) / 10.0;
        if (knockbackResistance != 0.0) {
            modifiers.put((Object)class_5134.field_23718, (Object)new class_1322(uuid, this.getAttributeName(), this.negativeGravity() ? -knockbackResistance : knockbackResistance, class_1322.class_1323.field_6328));
        }
        return modifiers;
    }

    protected abstract String getAttributeName();

    protected abstract boolean negativeGravity();

    public void tick(class_1799 stack, SlotReference slot, class_1309 entity) {
        super.tick(stack, slot, entity);
        this.applyGravity(stack, entity.method_37908(), (class_1297)entity);
    }

    public double getBonus(long storedInk) {
        if (storedInk < 100L) {
            return 0.0;
        }
        return 1 + (int)(Math.log((float)storedInk / 100.0f) / Math.log(8.0));
    }

    @Override
    public float getGravityMod(class_1799 stack) {
        FixedSingleInkStorage inkStorage = this.getEnergyStorage(stack);
        long storedInk = inkStorage.getEnergy(inkStorage.getStoredColor());
        float bonus = (float)this.getBonus(storedInk) / 100.0f;
        return this.negativeGravity() ? bonus : -bonus;
    }
}

