/*
 * Decompiled with CFR 0.152.
 */
package de.dafuqs.spectrum.items.trinkets;

import com.google.common.collect.Multimap;
import de.dafuqs.additionalentityattributes.AdditionalEntityAttributes;
import de.dafuqs.spectrum.SpectrumCommon;
import de.dafuqs.spectrum.api.energy.color.InkColors;
import de.dafuqs.spectrum.api.energy.storage.FixedSingleInkStorage;
import de.dafuqs.spectrum.items.trinkets.InkDrainTrinketItem;
import de.dafuqs.spectrum.registries.SpectrumEntityAttributes;
import dev.emi.trinkets.api.SlotReference;
import java.util.List;
import java.util.UUID;
import net.minecraft.class_124;
import net.minecraft.class_1309;
import net.minecraft.class_1320;
import net.minecraft.class_1322;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_1937;
import net.minecraft.class_2561;
import org.jetbrains.annotations.Nullable;

public class LaurelsOfSerenityItem
extends InkDrainTrinketItem {
    public LaurelsOfSerenityItem(class_1792.class_1793 settings) {
        super(settings, SpectrumCommon.locate("unlocks/trinkets/laurels_of_serenity"), InkColors.PURPLE);
    }

    @Override
    public void method_7851(class_1799 stack, @Nullable class_1937 world, List<class_2561> tooltip, class_1836 context) {
        tooltip.add((class_2561)class_2561.method_43471((String)"item.spectrum.laurels_of_serenity.tooltip").method_27692(class_124.field_1080));
        super.method_7851(stack, world, tooltip, context);
    }

    public Multimap<class_1320, class_1322> getModifiers(class_1799 stack, SlotReference slot, class_1309 entity, UUID uuid) {
        double sleepResistanceMod;
        Multimap modifiers = super.getModifiers(stack, slot, entity, uuid);
        FixedSingleInkStorage inkStorage = this.getEnergyStorage(stack);
        long storedInk = inkStorage.getEnergy(inkStorage.getStoredColor());
        double detectionRangeMod = this.getDetectionRangeMultiplier(storedInk);
        if (detectionRangeMod != 0.0) {
            modifiers.put((Object)AdditionalEntityAttributes.MOB_DETECTION_RANGE, (Object)new class_1322(uuid, "spectrum:laurels_of_serenity_detection_range", -detectionRangeMod, class_1322.class_1323.field_6331));
        }
        if ((sleepResistanceMod = (double)this.getInducedSleepResistanceMod(storedInk)) != 0.0) {
            modifiers.put((Object)SpectrumEntityAttributes.MENTAL_PRESENCE, (Object)new class_1322(uuid, "spectrum:laurels_of_serenity_sleep", sleepResistanceMod, class_1322.class_1323.field_6328));
        }
        return modifiers;
    }

    public float getDetectionRangeMultiplier(long storedInk) {
        if (storedInk < 100L) {
            return 0.0f;
        }
        return 0.15f * (float)((int)(Math.log((float)storedInk / 100.0f) / Math.log(8.0)));
    }

    public float getInducedSleepResistanceMod(long storedInk) {
        if (storedInk < 100L) {
            return 0.0f;
        }
        return 0.15f * (float)((int)(Math.log((float)storedInk / 100.0f) / Math.log(8.0)));
    }
}

