/*
 * Decompiled with CFR 0.152.
 */
package de.dafuqs.spectrum.progression;

import de.dafuqs.spectrum.SpectrumCommon;
import de.dafuqs.spectrum.api.recipe.GatedRecipe;
import de.dafuqs.spectrum.progression.toast.MessageToast;
import de.dafuqs.spectrum.progression.toast.UnlockedRecipeToast;
import de.dafuqs.spectrum.recipe.pedestal.PedestalRecipe;
import de.dafuqs.spectrum.recipe.pedestal.PedestalRecipeTier;
import de.dafuqs.spectrum.registries.SpectrumAdvancements;
import de.dafuqs.spectrum.registries.SpectrumBlocks;
import de.dafuqs.spectrum.registries.SpectrumItems;
import de.dafuqs.spectrum.registries.SpectrumRecipeTypes;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3545;
import net.minecraft.class_3956;
import net.minecraft.class_5455;
import net.minecraft.class_746;
import org.jetbrains.annotations.NotNull;

@Environment(value=EnvType.CLIENT)
public class UnlockToastManager {
    public static final Map<class_2960, Map<class_3956<?>, List<GatedRecipe<?>>>> gatedRecipes = new HashMap();
    public static final Map<class_2960, class_3545<class_1799, String>> messageToasts = new HashMap<class_2960, class_3545<class_1799, String>>(){
        {
            this.put(SpectrumAdvancements.UNLOCK_SHOOTING_STARS, new class_3545((Object)class_1802.field_27070.method_7854(), (Object)"shooting_stars_unlocked"));
            this.put(SpectrumAdvancements.OVERENCHANTING, new class_3545((Object)SpectrumBlocks.ENCHANTER.method_8389().method_7854(), (Object)"overchanting_unlocked"));
            this.put(SpectrumAdvancements.APPLY_CONFLICTING_ENCHANTMENTS, new class_3545((Object)SpectrumBlocks.ENCHANTER.method_8389().method_7854(), (Object)"enchant_conflicting_enchantments_unlocked"));
            this.put(SpectrumAdvancements.FOURTH_BREWING_SLOT, new class_3545((Object)SpectrumBlocks.POTION_WORKSHOP.method_8389().method_7854(), (Object)"fourth_potion_reagent_unlocked"));
            this.put(SpectrumAdvancements.MIDGAME, new class_3545((Object)SpectrumBlocks.PEDESTAL_ONYX.method_8389().method_7854(), (Object)"second_advancement_tree_unlocked"));
            this.put(SpectrumAdvancements.LATEGAME, new class_3545((Object)SpectrumBlocks.PEDESTAL_MOONSTONE.method_8389().method_7854(), (Object)"third_advancement_tree_unlocked"));
            this.put(SpectrumAdvancements.ASCEND_KINDLING, new class_3545((Object)SpectrumBlocks.PEDESTAL_MOONSTONE.method_8389().method_7854(), (Object)"ascend_kindling"));
            this.put(SpectrumAdvancements.VIVISECT_KINDLING, new class_3545((Object)SpectrumItems.DIVINATION_HEART.method_7854(), (Object)"vivisect_kindling"));
            this.put(SpectrumAdvancements.PAINTBRUSH_COLORING, new class_3545((Object)SpectrumItems.PAINTBRUSH.method_7854(), (Object)"block_coloring_unlocked"));
            this.put(SpectrumAdvancements.PAINTBRUSH_INK_SLINGING, new class_3545((Object)SpectrumItems.PAINTBRUSH.method_7854(), (Object)"ink_slinging_unlocked"));
        }
    };

    public static void registerGatedRecipe(class_3956<?> recipeType, GatedRecipe<?> gatedRecipe) {
        class_2960 requiredAdvancementIdentifier = gatedRecipe.getRequiredAdvancementIdentifier();
        if (gatedRecipe.isSecret()) {
            return;
        }
        if (gatedRecipes.containsKey(requiredAdvancementIdentifier)) {
            Map<class_3956<?>, List<GatedRecipe<?>>> recipeTypeListMap = gatedRecipes.get(requiredAdvancementIdentifier);
            if (recipeTypeListMap.containsKey(recipeType)) {
                List<GatedRecipe<?>> existingList = recipeTypeListMap.get(recipeType);
                if (!existingList.contains(gatedRecipe)) {
                    existingList.add(gatedRecipe);
                }
            } else {
                ArrayList newList = new ArrayList();
                newList.add(gatedRecipe);
                recipeTypeListMap.put(recipeType, newList);
            }
        } else {
            HashMap recipeTypeListMap = new HashMap();
            ArrayList newList = new ArrayList();
            newList.add(gatedRecipe);
            recipeTypeListMap.put(recipeType, newList);
            gatedRecipes.put(requiredAdvancementIdentifier, recipeTypeListMap);
        }
    }

    public static void processAdvancements(Set<class_2960> doneAdvancements) {
        class_310 client = class_310.method_1551();
        class_5455 registryManager = client.field_1687.method_30349();
        int unlockedRecipeCount = 0;
        HashMap unlockedRecipesByType = new HashMap();
        ArrayList<class_3545<class_1799, String>> specialToasts = new ArrayList<class_3545<class_1799, String>>();
        for (class_2960 class_29602 : doneAdvancements) {
            Optional<PedestalRecipeTier> newlyUnlockedRecipeTier;
            if (gatedRecipes.containsKey(class_29602)) {
                Map<class_3956<?>, List<GatedRecipe<?>>> recipesGatedByAdvancement = gatedRecipes.get(class_29602);
                for (Map.Entry<class_3956<?>, List<GatedRecipe<?>>> recipesByType : recipesGatedByAdvancement.entrySet()) {
                    List newRecipes = unlockedRecipesByType.containsKey(recipesByType.getKey()) ? (List)unlockedRecipesByType.get(recipesByType.getKey()) : new ArrayList();
                    for (GatedRecipe<?> unlockedRecipe : recipesByType.getValue()) {
                        if (!unlockedRecipe.canPlayerCraft((class_1657)client.field_1724) || newRecipes.contains(unlockedRecipe)) continue;
                        newRecipes.add(unlockedRecipe);
                        ++unlockedRecipeCount;
                    }
                    unlockedRecipesByType.put(recipesByType.getKey(), newRecipes);
                }
            }
            if ((newlyUnlockedRecipeTier = PedestalRecipeTier.hasJustUnlockedANewRecipeTier(class_29602)).isPresent()) {
                List unlockedPedestalRecipes = unlockedRecipesByType.containsKey(SpectrumRecipeTypes.PEDESTAL) ? (List)unlockedRecipesByType.get(SpectrumRecipeTypes.PEDESTAL) : new ArrayList();
                ArrayList pedestalRecipes = new ArrayList();
                for (Map<class_3956<?>, List<GatedRecipe<?>>> recipesByType : gatedRecipes.values()) {
                    if (!recipesByType.containsKey(SpectrumRecipeTypes.PEDESTAL)) continue;
                    pedestalRecipes.addAll((Collection)recipesByType.get(SpectrumRecipeTypes.PEDESTAL));
                }
                for (PedestalRecipe alreadyUnlockedRecipe : UnlockToastManager.getRecipesForTierWithAllConditionsMet(newlyUnlockedRecipeTier.get(), pedestalRecipes)) {
                    if (unlockedPedestalRecipes.contains(alreadyUnlockedRecipe)) continue;
                    unlockedPedestalRecipes.add(alreadyUnlockedRecipe);
                }
            }
            if (!messageToasts.containsKey(class_29602)) continue;
            specialToasts.add(messageToasts.get(class_29602));
        }
        if (unlockedRecipeCount > 50) {
            ArrayList<class_1799> allStacks = new ArrayList<class_1799>();
            for (List recipes : unlockedRecipesByType.values()) {
                for (GatedRecipe recipe : recipes) {
                    allStacks.add(recipe.method_8110(client.field_1687.method_30349()));
                }
            }
            UnlockedRecipeToast.showLotsOfRecipesToast(class_310.method_1551(), allStacks);
        } else {
            for (List list : unlockedRecipesByType.values()) {
                UnlockToastManager.showGroupedRecipeUnlockToasts(registryManager, list);
            }
        }
        for (class_3545 class_35452 : specialToasts) {
            MessageToast.showMessageToast(class_310.method_1551(), (class_1799)class_35452.method_15442(), (String)class_35452.method_15441());
        }
    }

    private static void showGroupedRecipeUnlockToasts(class_5455 registryManager, List<GatedRecipe<?>> unlockedRecipes) {
        if (unlockedRecipes.isEmpty()) {
            return;
        }
        class_2561 singleText = unlockedRecipes.get(0).getSingleUnlockToastString();
        class_2561 multipleText = unlockedRecipes.get(0).getMultipleUnlockToastString();
        ArrayList<class_1799> singleRecipes = new ArrayList<class_1799>();
        HashMap groupedRecipes = new HashMap();
        for (GatedRecipe<?> gatedRecipe : unlockedRecipes) {
            if (gatedRecipe.method_8110(registryManager).method_7960()) continue;
            if (gatedRecipe.method_8112() == null) {
                SpectrumCommon.logWarning("Found a recipe with null group: " + gatedRecipe.method_8114().toString() + " Please report this. If you are Dafuqs and you are reading this: you messed up big time.");
            }
            if (gatedRecipe.method_8112().isEmpty()) {
                singleRecipes.add(gatedRecipe.method_8110(registryManager));
                continue;
            }
            if (groupedRecipes.containsKey(gatedRecipe.method_8112())) {
                ((List)groupedRecipes.get(gatedRecipe.method_8112())).add(gatedRecipe.method_8110(registryManager));
                continue;
            }
            ArrayList<class_1799> newList = new ArrayList<class_1799>();
            newList.add(gatedRecipe.method_8110(registryManager));
            groupedRecipes.put(gatedRecipe.method_8112(), newList);
        }
        if (!groupedRecipes.isEmpty()) {
            for (Map.Entry entry : groupedRecipes.entrySet()) {
                List groupedList = (List)entry.getValue();
                if (groupedList.size() == 1) {
                    UnlockedRecipeToast.showRecipeToast(class_310.method_1551(), (class_1799)groupedList.get(0), singleText);
                    continue;
                }
                UnlockedRecipeToast.showRecipeGroupToast(class_310.method_1551(), (String)entry.getKey(), groupedList, multipleText);
            }
        }
        for (class_1799 class_17992 : singleRecipes) {
            UnlockedRecipeToast.showRecipeToast(class_310.method_1551(), class_17992, singleText);
        }
    }

    @NotNull
    private static List<PedestalRecipe> getRecipesForTierWithAllConditionsMet(PedestalRecipeTier pedestalRecipeTier, List<GatedRecipe<?>> pedestalRecipes) {
        class_310 client = class_310.method_1551();
        class_746 player = client.field_1724;
        ArrayList<PedestalRecipe> alreadyUnlockedRecipesAtNewTier = new ArrayList<PedestalRecipe>();
        for (GatedRecipe<?> recipe : pedestalRecipes) {
            PedestalRecipe pedestalRecipe = (PedestalRecipe)recipe;
            if (pedestalRecipe.getTier() != pedestalRecipeTier || alreadyUnlockedRecipesAtNewTier.contains(recipe) || !recipe.canPlayerCraft((class_1657)player)) continue;
            alreadyUnlockedRecipesAtNewTier.add(pedestalRecipe);
        }
        return alreadyUnlockedRecipesAtNewTier;
    }
}

