/*
 * Decompiled with CFR 0.152.
 */
package de.dafuqs.spectrum;

import de.dafuqs.spectrum.api.color.ColorRegistry;
import de.dafuqs.spectrum.api.energy.color.InkColorMixes;
import de.dafuqs.spectrum.api.energy.color.InkColors;
import de.dafuqs.spectrum.blocks.pastel_network.Pastel;
import de.dafuqs.spectrum.blocks.titration_barrel.TitrationBarrelBlock;
import de.dafuqs.spectrum.compat.SpectrumIntegrationPacks;
import de.dafuqs.spectrum.compat.reverb.DimensionReverb;
import de.dafuqs.spectrum.config.SpectrumConfig;
import de.dafuqs.spectrum.data_loaders.CrystalApothecarySimulationsDataLoader;
import de.dafuqs.spectrum.data_loaders.EntityFishingDataLoader;
import de.dafuqs.spectrum.data_loaders.NaturesStaffConversionDataLoader;
import de.dafuqs.spectrum.entity.SpectrumEntitySubPredicateTypes;
import de.dafuqs.spectrum.entity.SpectrumEntityTypes;
import de.dafuqs.spectrum.entity.SpectrumTrackedDataHandlerRegistry;
import de.dafuqs.spectrum.events.SpectrumGameEvents;
import de.dafuqs.spectrum.events.SpectrumPositionSources;
import de.dafuqs.spectrum.explosion.ExplosionModifierProviders;
import de.dafuqs.spectrum.explosion.ExplosionModifiers;
import de.dafuqs.spectrum.inventories.SpectrumScreenHandlerTypes;
import de.dafuqs.spectrum.loot.SpectrumLootContextTypes;
import de.dafuqs.spectrum.loot.SpectrumLootFunctionTypes;
import de.dafuqs.spectrum.loot.SpectrumLootPoolModifiers;
import de.dafuqs.spectrum.networking.SpectrumC2SPackets;
import de.dafuqs.spectrum.networking.SpectrumS2CPackets;
import de.dafuqs.spectrum.particle.SpectrumParticleTypes;
import de.dafuqs.spectrum.progression.SpectrumAdvancementCriteria;
import de.dafuqs.spectrum.registries.DeferredRegistrar;
import de.dafuqs.spectrum.registries.SpectrumArmorMaterials;
import de.dafuqs.spectrum.registries.SpectrumBlockEntities;
import de.dafuqs.spectrum.registries.SpectrumBlockSoundGroups;
import de.dafuqs.spectrum.registries.SpectrumBlocks;
import de.dafuqs.spectrum.registries.SpectrumCommands;
import de.dafuqs.spectrum.registries.SpectrumCompostableBlocks;
import de.dafuqs.spectrum.registries.SpectrumDataComponentTypes;
import de.dafuqs.spectrum.registries.SpectrumDimensions;
import de.dafuqs.spectrum.registries.SpectrumDispenserBehaviors;
import de.dafuqs.spectrum.registries.SpectrumEntityAttributes;
import de.dafuqs.spectrum.registries.SpectrumEntityColorProcessors;
import de.dafuqs.spectrum.registries.SpectrumEventListeners;
import de.dafuqs.spectrum.registries.SpectrumFeatures;
import de.dafuqs.spectrum.registries.SpectrumFlammableBlocks;
import de.dafuqs.spectrum.registries.SpectrumFluids;
import de.dafuqs.spectrum.registries.SpectrumFusionShrineWorldEffects;
import de.dafuqs.spectrum.registries.SpectrumItemDamageImmunities;
import de.dafuqs.spectrum.registries.SpectrumItemGroups;
import de.dafuqs.spectrum.registries.SpectrumItemProjectileBehaviors;
import de.dafuqs.spectrum.registries.SpectrumItemProviders;
import de.dafuqs.spectrum.registries.SpectrumItemSubPredicateTypes;
import de.dafuqs.spectrum.registries.SpectrumItems;
import de.dafuqs.spectrum.registries.SpectrumLoadConditions;
import de.dafuqs.spectrum.registries.SpectrumOmniAcceleratorProjectiles;
import de.dafuqs.spectrum.registries.SpectrumPastelUpgrades;
import de.dafuqs.spectrum.registries.SpectrumPathNodeTypes;
import de.dafuqs.spectrum.registries.SpectrumPlacedFeatures;
import de.dafuqs.spectrum.registries.SpectrumPotions;
import de.dafuqs.spectrum.registries.SpectrumPresentUnpackBehaviors;
import de.dafuqs.spectrum.registries.SpectrumRecipeScalings;
import de.dafuqs.spectrum.registries.SpectrumRecipeSerializers;
import de.dafuqs.spectrum.registries.SpectrumRecipeTypes;
import de.dafuqs.spectrum.registries.SpectrumRegistries;
import de.dafuqs.spectrum.registries.SpectrumResonanceProcessorTypes;
import de.dafuqs.spectrum.registries.SpectrumResourceConditions;
import de.dafuqs.spectrum.registries.SpectrumSoundEvents;
import de.dafuqs.spectrum.registries.SpectrumStatusEffects;
import de.dafuqs.spectrum.registries.SpectrumStrippableBlocks;
import de.dafuqs.spectrum.registries.SpectrumStructurePoolElementTypes;
import de.dafuqs.spectrum.registries.SpectrumStructureTypes;
import de.dafuqs.spectrum.registries.SpectrumTillableBlocks;
import de.dafuqs.spectrum.registries.SpectrumTreeDecoratorTypes;
import de.dafuqs.spectrum.registries.SpectrumWaxableBlocks;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import me.shedaniel.autoconfig.AutoConfig;
import me.shedaniel.autoconfig.serializer.JanksonConfigSerializer;
import net.fabricmc.api.ModInitializer;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerLifecycleEvents;
import net.fabricmc.fabric.api.resource.IdentifiableResourceReloadListener;
import net.fabricmc.fabric.api.resource.ResourceManagerHelper;
import net.fabricmc.fabric.api.resource.ResourcePackActivationType;
import net.fabricmc.fabric.api.transfer.v1.fluid.FluidStorage;
import net.fabricmc.fabric.api.transfer.v1.item.InventoryStorage;
import net.fabricmc.fabric.api.transfer.v1.item.ItemStorage;
import net.fabricmc.fabric.api.transfer.v1.storage.Storage;
import net.fabricmc.loader.api.FabricLoader;
import net.fabricmc.loader.api.ModContainer;
import net.minecraft.class_1263;
import net.minecraft.class_1792;
import net.minecraft.class_1863;
import net.minecraft.class_1937;
import net.minecraft.class_2350;
import net.minecraft.class_2561;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_3264;
import net.minecraft.class_6862;
import net.minecraft.server.MinecraftServer;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SpectrumCommon
implements ModInitializer {
    public static final String MOD_ID = "spectrum";
    public static final Logger LOGGER = LoggerFactory.getLogger((String)"Spectrum");
    public static final Map<class_2960, class_6862<class_1792>> CACHED_ITEM_TAG_MAP = new HashMap<class_2960, class_6862<class_1792>>();
    public static SpectrumConfig CONFIG;
    @Nullable
    public static MinecraftServer minecraftServer;
    public static final DeferredRegistrar FUEL_REGISTRAR;

    public static void logInfo(String message) {
        LOGGER.info("[Spectrum] {}", (Object)message);
    }

    public static void logWarning(String message) {
        LOGGER.warn("[Spectrum] {}", (Object)message);
    }

    public static void logError(String message) {
        LOGGER.error("[Spectrum] {}", (Object)message);
    }

    public static class_2960 locate(String name) {
        return class_2960.method_60655((String)MOD_ID, (String)name);
    }

    public static class_2960 ofSpectrumDefaulted(String id) {
        int i = id.indexOf(58);
        String path = id.substring(i + 1);
        String namespace = i > 0 ? id.substring(0, i) : MOD_ID;
        return class_2960.method_60655((String)namespace, (String)path);
    }

    public void onInitialize() {
        SpectrumCommon.logInfo("Starting Common Startup");
        SpectrumRegistries.register();
        InkColors.register();
        InkColorMixes.register();
        SpectrumEntityAttributes.register();
        SpectrumLoadConditions.register();
        SpectrumCommon.logInfo("Registering Component Types...");
        SpectrumDataComponentTypes.register();
        SpectrumCommon.logInfo("Registering Block / Item Color Registries...");
        ColorRegistry.registerColorRegistries();
        SpectrumCommon.logInfo("Registering Status Effects...");
        SpectrumStatusEffects.register();
        SpectrumCommon.logInfo("Registering Advancement Criteria...");
        SpectrumAdvancementCriteria.register();
        SpectrumCommon.logInfo("Registering Particle Types...");
        SpectrumParticleTypes.register();
        SpectrumCommon.logInfo("Registering Sound Events...");
        SpectrumSoundEvents.register();
        SpectrumCommon.logInfo("Registering BlockSound Groups...");
        SpectrumBlockSoundGroups.register();
        SpectrumCommon.logInfo("Registering Fluids...");
        SpectrumFluids.register();
        SpectrumCommon.logInfo("Registering Armor Materials...");
        SpectrumArmorMaterials.register();
        SpectrumCommon.logInfo("Registering Blocks...");
        SpectrumBlocks.register();
        SpectrumCommon.logInfo("Registering Items...");
        SpectrumPotions.register();
        SpectrumItems.register();
        SpectrumItemGroups.register();
        SpectrumCommon.logInfo("Registering Block Entities...");
        SpectrumBlockEntities.register();
        SpectrumCommon.logInfo("Registering Pastel Upgrades...");
        SpectrumPastelUpgrades.register();
        SpectrumCommon.logInfo("Registering Features...");
        SpectrumFeatures.register();
        SpectrumCommon.logInfo("Registering Biome Modifications...");
        SpectrumPlacedFeatures.addBiomeModifications();
        SpectrumCommon.logInfo("Registering Structure Types...");
        SpectrumStructureTypes.register();
        SpectrumCommon.logInfo("Registering Dimension...");
        SpectrumDimensions.register();
        SpectrumCommon.logInfo("Registering Dimension Sound Effects...");
        DimensionReverb.setup();
        SpectrumCommon.logInfo("Registering Recipe Types...");
        SpectrumRecipeScalings.init();
        SpectrumFusionShrineWorldEffects.register();
        SpectrumRecipeTypes.register();
        SpectrumRecipeSerializers.register();
        SpectrumCommon.logInfo("Registering Loot Conditions & Functions...");
        SpectrumLootContextTypes.register();
        SpectrumLootFunctionTypes.register();
        SpectrumCommon.logInfo("Setting up server side Mod Compat...");
        SpectrumIntegrationPacks.register();
        SpectrumCommon.logInfo("Registering Screen Handler Types...");
        SpectrumScreenHandlerTypes.register();
        SpectrumCommon.logInfo("Registering Default Item Stack Damage Immunities...");
        SpectrumItemDamageImmunities.registerDefaultItemStackImmunities();
        SpectrumCommon.logInfo("Registering Enchantment Drops...");
        SpectrumLootPoolModifiers.setup();
        SpectrumCommon.logInfo("Registering Variant Specific Predicates...");
        SpectrumItemSubPredicateTypes.register();
        SpectrumEntitySubPredicateTypes.register();
        SpectrumCommon.logInfo("Registering Blocks and Items to Fuel Registry...");
        FUEL_REGISTRAR.flush();
        SpectrumCommon.logInfo("Registering Entities...");
        SpectrumTrackedDataHandlerRegistry.register();
        SpectrumEntityTypes.register();
        SpectrumCommon.logInfo("Registering Omni Accelerator Projectiles & Behaviors...");
        SpectrumOmniAcceleratorProjectiles.register();
        SpectrumItemProjectileBehaviors.register();
        SpectrumEntityColorProcessors.register();
        SpectrumItemProviders.register();
        SpectrumCommon.logInfo("Registering Commands...");
        SpectrumCommands.register();
        SpectrumCommon.logInfo("Registering Networking Packets...");
        SpectrumC2SPackets.register();
        SpectrumS2CPackets.register();
        SpectrumCommon.logInfo("Registering Data Loaders...");
        ResourceManagerHelper.get((class_3264)class_3264.field_14190).registerReloadListener((IdentifiableResourceReloadListener)NaturesStaffConversionDataLoader.INSTANCE);
        ResourceManagerHelper.get((class_3264)class_3264.field_14190).registerReloadListener((IdentifiableResourceReloadListener)EntityFishingDataLoader.INSTANCE);
        ResourceManagerHelper.get((class_3264)class_3264.field_14190).registerReloadListener((IdentifiableResourceReloadListener)CrystalApothecarySimulationsDataLoader.INSTANCE);
        ServerLifecycleEvents.SERVER_STARTING.register(server -> {
            SpectrumCommon.logInfo("Fetching server instance...");
            minecraftServer = server;
        });
        ServerLifecycleEvents.SERVER_STOPPED.register(server -> {
            Pastel.clearServerInstance();
            minecraftServer = null;
        });
        SpectrumCommon.logInfo("Adding to Fabric's Registries...");
        SpectrumFlammableBlocks.register();
        SpectrumStrippableBlocks.register();
        SpectrumWaxableBlocks.register();
        SpectrumTillableBlocks.register();
        SpectrumCompostableBlocks.register();
        SpectrumCommon.logInfo("Registering Game Events...");
        SpectrumGameEvents.register();
        SpectrumPositionSources.register();
        SpectrumCommon.logInfo("Registering Explosion Effects & Providers...");
        ExplosionModifiers.register();
        ExplosionModifierProviders.register();
        SpectrumCommon.logInfo("Registering Dispenser, Resonance & Present Unwrap Behaviors...");
        SpectrumDispenserBehaviors.register();
        SpectrumPresentUnpackBehaviors.register();
        SpectrumResonanceProcessorTypes.register();
        SpectrumCommon.logInfo("Registering Resource Conditions...");
        SpectrumResourceConditions.register();
        SpectrumCommon.logInfo("Registering Structure WeightedPool Element Types...");
        SpectrumStructurePoolElementTypes.register();
        SpectrumCommon.logInfo("Registering Event Listeners...");
        SpectrumEventListeners.register();
        SpectrumCommon.logInfo("Registering Path Node Types...");
        SpectrumPathNodeTypes.register();
        SpectrumCommon.logInfo("Registering Tree Decorator Types...");
        SpectrumTreeDecoratorTypes.register();
        ItemStorage.SIDED.registerForBlockEntity((be, d) -> Storage.empty(), SpectrumBlockEntities.HEARTBOUND_CHEST);
        ItemStorage.SIDED.registerForBlockEntity((titrationBarrelBlockEntity, direction) -> {
            class_2680 state = titrationBarrelBlockEntity.method_11010();
            TitrationBarrelBlock.BarrelState barrelState = (TitrationBarrelBlock.BarrelState)((Object)((Object)state.method_11654(TitrationBarrelBlock.BARREL_STATE)));
            if (barrelState == TitrationBarrelBlock.BarrelState.EMPTY || barrelState == TitrationBarrelBlock.BarrelState.FILLED) {
                return InventoryStorage.of((class_1263)titrationBarrelBlockEntity, (class_2350)direction);
            }
            return null;
        }, SpectrumBlockEntities.TITRATION_BARREL);
        ItemStorage.SIDED.registerForBlockEntity((blockEntity, direction) -> blockEntity.storage, SpectrumBlockEntities.BOTTOMLESS_BUNDLE);
        FluidStorage.SIDED.registerForBlockEntity((blockEntity, direction) -> blockEntity.fluidStorage, SpectrumBlockEntities.FUSION_SHRINE);
        FluidStorage.SIDED.registerForBlockEntity((blockEntity, direction) -> blockEntity.getFluidStorage(), SpectrumBlockEntities.TITRATION_BARREL);
        SpectrumCommon.logInfo("Registering Builtin Resource Packs...");
        Optional modContainer = FabricLoader.getInstance().getModContainer(MOD_ID);
        if (modContainer.isPresent()) {
            ResourceManagerHelper.registerBuiltinResourcePack((class_2960)SpectrumCommon.locate("spectrum_alternate"), (ModContainer)((ModContainer)modContainer.get()), (class_2561)class_2561.method_30163((String)"Alternate Spectrum textures"), (ResourcePackActivationType)ResourcePackActivationType.NORMAL);
            ResourceManagerHelper.registerBuiltinResourcePack((class_2960)SpectrumCommon.locate("spectrum_generation_1"), (ModContainer)((ModContainer)modContainer.get()), (class_2561)class_2561.method_30163((String)"Generation 1 Spectrum textures"), (ResourcePackActivationType)ResourcePackActivationType.NORMAL);
            ResourceManagerHelper.registerBuiltinResourcePack((class_2960)SpectrumCommon.locate("spectrum_programmer_art"), (ModContainer)((ModContainer)modContainer.get()), (class_2561)class_2561.method_30163((String)"Spectrum's Programmer Art"), (ResourcePackActivationType)ResourcePackActivationType.NORMAL);
        }
        SpectrumCommon.logInfo("Common startup completed!");
    }

    public static Optional<class_1863> getRecipeManager(@Nullable class_1937 world) {
        return world == null ? (minecraftServer == null ? Optional.empty() : Optional.of(minecraftServer.method_3772())) : Optional.of(world.method_8433());
    }

    static {
        FUEL_REGISTRAR = new DeferredRegistrar();
        SpectrumCommon.logInfo("Loading config file...");
        AutoConfig.register(SpectrumConfig.class, JanksonConfigSerializer::new);
        CONFIG = (SpectrumConfig)AutoConfig.getConfigHolder(SpectrumConfig.class).getConfig();
        SpectrumCommon.logInfo("Finished loading config file.");
    }
}

