/*
 * Decompiled with CFR 0.152.
 */
package de.dafuqs.spectrum.api.energy;

import de.dafuqs.revelationary.api.advancements.AdvancementHelper;
import de.dafuqs.spectrum.SpectrumCommon;
import de.dafuqs.spectrum.api.energy.InkCost;
import de.dafuqs.spectrum.api.energy.InkStorage;
import de.dafuqs.spectrum.api.energy.InkStorageItem;
import de.dafuqs.spectrum.api.energy.color.InkColor;
import de.dafuqs.spectrum.compat.SpectrumIntegrationPacks;
import de.dafuqs.spectrum.helpers.Support;
import de.dafuqs.spectrum.progression.SpectrumAdvancementCriteria;
import dev.emi.trinkets.api.TrinketComponent;
import dev.emi.trinkets.api.TrinketsApi;
import java.util.List;
import java.util.Optional;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_124;
import net.minecraft.class_1263;
import net.minecraft.class_1291;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3222;
import net.minecraft.class_3545;
import net.minecraft.class_7923;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface InkPowered {
    public static final class_2960 REQUIRED_ADVANCEMENT = SpectrumCommon.locate("milestones/unlock_ink_use");

    @Environment(value=EnvType.CLIENT)
    public static boolean canUseClient() {
        class_310 client = class_310.method_1551();
        return InkPowered.canUse((class_1657)client.field_1724);
    }

    public static boolean canUse(class_1657 playerEntity) {
        return AdvancementHelper.hasAdvancement((class_1657)playerEntity, (class_2960)REQUIRED_ADVANCEMENT);
    }

    public List<InkColor> getUsedColors();

    @Environment(value=EnvType.CLIENT)
    default public void addInkPoweredTooltip(List<class_2561> tooltip) {
        if (InkPowered.canUseClient()) {
            if (this.getUsedColors().size() > 1) {
                tooltip.add((class_2561)class_2561.method_43471((String)"spectrum.tooltip.ink_powered.prefix").method_27692(class_124.field_1080));
                for (InkColor color : this.getUsedColors()) {
                    tooltip.add((class_2561)color.getColoredInkName().method_27692(class_124.field_1080));
                }
            } else {
                tooltip.add((class_2561)class_2561.method_43469((String)"spectrum.tooltip.ink_powered.consume", (Object[])new Object[]{this.getUsedColors().get(0).getColoredInkName()}).method_27692(class_124.field_1080));
            }
        }
    }

    private static long tryDrainEnergy(@NotNull class_1799 stack, InkColor color, long amount, @Nullable class_1657 player) {
        class_1792 class_17922 = stack.method_7909();
        if (class_17922 instanceof InkStorageItem) {
            InkStorageItem inkStorageItem = (InkStorageItem)class_17922;
            if (!inkStorageItem.getDrainability().canDrain(player != null)) {
                return 0L;
            }
            Object inkStorage = inkStorageItem.getEnergyStorage(stack);
            long drained = inkStorage.drainEnergy(color, amount);
            if (drained > 0L) {
                if (player instanceof class_3222) {
                    class_3222 serverPlayerEntity = (class_3222)player;
                    SpectrumAdvancementCriteria.INK_CONTAINER_INTERACTION.trigger(serverPlayerEntity, stack, (InkStorage)inkStorage, color, -amount);
                }
                inkStorageItem.setEnergyStorage(stack, (InkStorage)inkStorage);
            }
            return drained;
        }
        return 0L;
    }

    private static long tryGetEnergy(@NotNull class_1799 stack, InkColor color) {
        class_1792 class_17922 = stack.method_7909();
        if (class_17922 instanceof InkStorageItem) {
            InkStorageItem inkStorageItem = (InkStorageItem)class_17922;
            Object inkStorage = inkStorageItem.getEnergyStorage(stack);
            return inkStorage.getEnergy(color);
        }
        return 0L;
    }

    public static boolean tryDrainEnergy(@NotNull class_1263 inventory, InkColor color, long amount) {
        for (int i = 0; i < inventory.method_5439(); ++i) {
            class_1799 currentStack = inventory.method_5438(i);
            if (currentStack.method_7960() || (amount -= InkPowered.tryDrainEnergy(currentStack, color, amount, null)) > 0L) continue;
            return true;
        }
        return false;
    }

    public static boolean tryDrainEnergy(@NotNull class_1657 player, @NotNull InkCost inkCost) {
        return InkPowered.tryDrainEnergy(player, inkCost.color(), inkCost.cost());
    }

    public static boolean tryDrainEnergy(@NotNull class_1657 player, @NotNull InkCost inkCost, float costModifier) {
        return InkPowered.tryDrainEnergy(player, inkCost.color(), (long)Support.getIntFromDecimalWithChance((float)inkCost.cost() * costModifier, player.method_59922()));
    }

    public static boolean tryDrainEnergy(@NotNull class_1657 player, @NotNull InkColor color, long amount) {
        class_1291 effect;
        if (player.method_7337()) {
            return true;
        }
        if (!InkPowered.canUse(player)) {
            return false;
        }
        if (SpectrumIntegrationPacks.isIntegrationPackActive("malum") && player.method_6059(class_7923.field_41174.method_47983((Object)(effect = (class_1291)class_7923.field_41174.method_10223(class_2960.method_60654((String)"malum:silenced")))))) {
            return false;
        }
        for (class_1799 itemStack2 : player.method_5877()) {
            if ((amount -= InkPowered.tryDrainEnergy(itemStack2, color, amount, player)) > 0L) continue;
            return true;
        }
        Optional optionalTrinketComponent = TrinketsApi.getTrinketComponent((class_1309)player);
        if (optionalTrinketComponent.isPresent()) {
            List trinketInkStorages = ((TrinketComponent)optionalTrinketComponent.get()).getEquipped(itemStack -> itemStack.method_7909() instanceof InkStorageItem);
            for (class_3545 trinketEnergyStorageStack : trinketInkStorages) {
                if ((amount -= InkPowered.tryDrainEnergy((class_1799)trinketEnergyStorageStack.method_15441(), color, amount, player)) > 0L) continue;
                return true;
            }
        }
        for (class_1799 itemStack3 : player.method_31548().field_7547) {
            if ((amount -= InkPowered.tryDrainEnergy(itemStack3, color, amount, player)) > 0L) continue;
            return true;
        }
        return false;
    }

    public static long getAvailableInk(@NotNull class_1657 player, InkColor color) {
        if (player.method_7337()) {
            return Long.MAX_VALUE;
        }
        if (!InkPowered.canUse(player)) {
            return 0L;
        }
        long available = 0L;
        for (class_1799 itemStack2 : player.method_5877()) {
            available += InkPowered.tryGetEnergy(itemStack2, color);
        }
        Optional optionalTrinketComponent = TrinketsApi.getTrinketComponent((class_1309)player);
        if (optionalTrinketComponent.isPresent()) {
            List trinketInkStorages = ((TrinketComponent)optionalTrinketComponent.get()).getEquipped(itemStack -> itemStack.method_7909() instanceof InkStorageItem);
            for (class_3545 trinketEnergyStorageStack : trinketInkStorages) {
                available += InkPowered.tryGetEnergy((class_1799)trinketEnergyStorageStack.method_15441(), color);
            }
        }
        for (class_1799 itemStack3 : player.method_31548().field_7547) {
            available += InkPowered.tryGetEnergy(itemStack3, color);
        }
        return available;
    }

    public static boolean hasAvailableInk(class_1657 player, InkCost inkCost) {
        return InkPowered.hasAvailableInk(player, inkCost.color(), inkCost.cost());
    }

    public static boolean hasAvailableInk(class_1657 player, InkColor color, long amount) {
        Object effect;
        if (!InkPowered.canUse(player)) {
            return false;
        }
        if (SpectrumIntegrationPacks.isIntegrationPackActive("malum") && player.method_6059(class_7923.field_41174.method_47983(effect = (class_1291)class_7923.field_41174.method_10223(class_2960.method_60654((String)"malum:silenced"))))) {
            return false;
        }
        if (player.method_7337()) {
            return true;
        }
        for (class_1799 itemStack2 : player.method_5877()) {
            if ((amount -= InkPowered.tryGetEnergy(itemStack2, color)) > 0L) continue;
            return true;
        }
        Optional optionalTrinketComponent = TrinketsApi.getTrinketComponent((class_1309)player);
        if (optionalTrinketComponent.isPresent()) {
            List trinketInkStorages = ((TrinketComponent)optionalTrinketComponent.get()).getEquipped(itemStack -> itemStack.method_7909() instanceof InkStorageItem);
            for (class_3545 trinketEnergyStorageStack : trinketInkStorages) {
                if ((amount -= InkPowered.tryGetEnergy((class_1799)trinketEnergyStorageStack.method_15441(), color)) > 0L) continue;
                return true;
            }
        }
        for (class_1799 itemStack3 : player.method_31548().field_7547) {
            if ((amount -= InkPowered.tryGetEnergy(itemStack3, color)) > 0L) continue;
            return true;
        }
        return false;
    }
}

