/*
 * Decompiled with CFR 0.152.
 */
package de.dafuqs.spectrum.api.energy;

import de.dafuqs.spectrum.SpectrumCommon;
import de.dafuqs.spectrum.api.energy.color.InkColor;
import de.dafuqs.spectrum.helpers.Support;
import de.dafuqs.spectrum.registries.SpectrumRegistries;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.class_124;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_3532;
import net.minecraft.class_3829;
import net.minecraft.class_5250;
import org.jetbrains.annotations.NotNull;

public interface InkStorage
extends class_3829 {
    public static long transferInk(@NotNull InkStorage source, @NotNull InkStorage destination) {
        long transferred = 0L;
        for (InkColor inkColor : source.getEnergy().keySet()) {
            transferred += InkStorage.transferInk(source, destination, inkColor);
        }
        return transferred;
    }

    public static long transferInk(@NotNull InkStorage source, @NotNull InkStorage destination, @NotNull InkColor color) {
        long destinationAmount;
        long destinationRoom;
        if (!destination.accepts(color)) {
            return 0L;
        }
        long sourceAmount = source.getEnergy(color);
        if (sourceAmount > 0L && (destinationRoom = destination.getRoom(color)) > 0L && sourceAmount > (destinationAmount = destination.getEnergy(color)) + 1L) {
            long transferAmount = Math.max(1L, (sourceAmount - destinationAmount) / 32L);
            transferAmount = Math.min(transferAmount, Math.min(sourceAmount, destinationRoom));
            destination.addEnergy(color, transferAmount);
            source.drainEnergy(color, transferAmount);
            return transferAmount;
        }
        return 0L;
    }

    @Deprecated
    public static long transferInk(@NotNull InkStorage source, @NotNull InkStorage destination, @NotNull InkColor color, long amount) {
        long transferAmount;
        long destinationRoom;
        if (!destination.accepts(color)) {
            return 0L;
        }
        long sourceAmount = source.getEnergy(color);
        if (sourceAmount > 0L && (destinationRoom = destination.getRoom(color)) > 0L && (transferAmount = Math.min(amount, Math.min(sourceAmount, destinationRoom))) > 0L) {
            destination.addEnergy(color, transferAmount);
            source.drainEnergy(color, transferAmount);
            return transferAmount;
        }
        return 0L;
    }

    public boolean accepts(InkColor var1);

    public long addEnergy(InkColor var1, long var2);

    public long drainEnergy(InkColor var1, long var2);

    public boolean requestEnergy(InkColor var1, long var2);

    public long getEnergy(InkColor var1);

    @Deprecated
    public Map<InkColor, Long> getEnergy();

    @Deprecated
    public void setEnergy(Map<InkColor, Long> var1, long var2);

    public long getMaxPerColor();

    public long getMaxTotal();

    public long getCurrentTotal();

    public boolean isEmpty();

    public boolean isFull();

    public void fillCompletely();

    public void method_5448();

    default public float getFillPercent(InkColor color) {
        return class_3532.method_15363((float)((float)this.getEnergy(color) / (float)this.getMaxPerColor()), (float)0.0f, (float)1.0f);
    }

    default public float getTotalFillPercent() {
        return class_3532.method_15363((float)((float)this.getCurrentTotal() / (float)this.getMaxTotal()), (float)0.0f, (float)1.0f);
    }

    public void addTooltip(List<class_2561> var1);

    public long getRoom(InkColor var1);

    @NotNull
    public static Map<InkColor, Long> readEnergy(class_2487 compound) {
        HashMap<InkColor, Long> energy = new HashMap<InkColor, Long>();
        if (compound != null) {
            for (String key : compound.method_10541()) {
                InkColor inkColor = (InkColor)SpectrumRegistries.INK_COLOR.method_10223(SpectrumCommon.locate(key));
                if (inkColor == null) continue;
                long amount = compound.method_10537(key);
                energy.put(inkColor, amount);
            }
        }
        return energy;
    }

    @NotNull
    public static class_2487 writeEnergy(Map<InkColor, Long> storedEnergy) {
        class_2487 energy = new class_2487();
        for (Map.Entry<InkColor, Long> color : storedEnergy.entrySet()) {
            energy.method_10544(color.getKey().getID().toString(), color.getValue().longValue());
        }
        return energy;
    }

    public static void addInkStoreBulletTooltip(List<class_2561> tooltip, InkColor color, long amount) {
        class_5250 inkName = color.getColoredInkName();
        tooltip.add((class_2561)class_2561.method_43469((String)"spectrum.tooltip.ink_powered.bullet_amount", (Object[])new Object[]{class_2561.method_43470((String)Support.getShortenedNumberString(amount)).method_27692(class_124.field_1068), inkName}).method_10862(inkName.method_10866()));
    }
}

