/*
 * Decompiled with CFR 0.152.
 */
package de.dafuqs.spectrum.api.energy.color;

import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import de.dafuqs.spectrum.helpers.CodecHelper;
import de.dafuqs.spectrum.helpers.SpectrumColorHelper;
import de.dafuqs.spectrum.registries.SpectrumRegistries;
import io.netty.buffer.ByteBuf;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import net.minecraft.class_1767;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_2960;
import net.minecraft.class_5250;
import net.minecraft.class_6862;
import net.minecraft.class_9139;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector3f;

public class InkColor {
    public static final Codec<InkColor> CODEC = CodecHelper.SPECTRUM_DEFAULTED_IDENTIFIER.comapFlatMap(id -> InkColor.ofId(id).map(DataResult::success).orElse(DataResult.error(() -> "Not a valid ink color: " + String.valueOf(id))), InkColor::getID);
    public static final class_9139<ByteBuf, InkColor> PACKET_CODEC = class_2960.field_48267.method_56432(id -> InkColor.ofId(id).orElseThrow(), InkColor::getID);
    protected static final Map<class_1767, InkColor> DYE_TO_COLOR = new HashMap<class_1767, InkColor>();
    protected final Optional<class_1767> dyeColor;
    protected final int colorInt;
    protected final Vector3f colorVec;
    protected final int textColor;
    protected final Vector3f textColorVec;
    protected final class_2960 requiredAdvancement;

    public InkColor(class_1767 dyeColor, int color, class_2960 requiredAdvancement) {
        this(Optional.of(dyeColor), color, color, requiredAdvancement);
    }

    public InkColor(class_1767 dyeColor, int color, int textColor, class_2960 requiredAdvancement) {
        this(Optional.of(dyeColor), color, textColor, requiredAdvancement);
    }

    public InkColor(Optional<class_1767> dyeColor, int color, int textColor, class_2960 requiredAdvancement) {
        this.dyeColor = dyeColor;
        this.colorInt = color;
        this.colorVec = SpectrumColorHelper.colorIntToVec(color);
        this.textColor = textColor;
        this.textColorVec = SpectrumColorHelper.colorIntToVec(textColor);
        this.requiredAdvancement = requiredAdvancement;
        dyeColor.ifPresent(value -> DYE_TO_COLOR.put((class_1767)value, this));
    }

    @Nullable
    public static InkColor ofDyeColor(class_1767 dyeColor) {
        return DYE_TO_COLOR.get(dyeColor);
    }

    public static Optional<InkColor> ofId(class_2960 id) {
        return SpectrumRegistries.INK_COLOR.method_17966(id);
    }

    public static Optional<InkColor> ofIdString(String idString) {
        return SpectrumRegistries.INK_COLOR.method_17966(class_2960.method_60654((String)idString));
    }

    public Optional<class_1767> getDyeColor() {
        return this.dyeColor;
    }

    public String toString() {
        return this.getID().toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        InkColor that = (InkColor)o;
        return this.dyeColor.equals(that.dyeColor);
    }

    public int hashCode() {
        return this.colorInt;
    }

    public class_5250 getName() {
        return class_2561.method_43471((String)this.getID().method_48747("ink", "name"));
    }

    public class_5250 getColoredName() {
        return this.getName().method_10862(class_2583.field_24360.method_36139(this.textColor));
    }

    public class_5250 getColoredInkName() {
        return class_2561.method_43469((String)"ink.suffix", (Object[])new Object[]{this.getName()}).method_10862(class_2583.field_24360.method_36139(this.textColor));
    }

    public Vector3f getColorVec() {
        return this.colorVec;
    }

    public int getColorInt() {
        return this.colorInt;
    }

    public int getTextColorInt() {
        return this.textColor;
    }

    public Vector3f getTextColorVec() {
        return this.textColorVec;
    }

    public class_2960 getRequiredAdvancement() {
        return this.requiredAdvancement;
    }

    public class_2960 getID() {
        return SpectrumRegistries.INK_COLOR.method_10221(this);
    }

    public boolean isIn(class_6862<InkColor> tag) {
        return SpectrumRegistries.INK_COLOR.method_47983(this).method_40220(tag);
    }
}

