/*
 * Decompiled with CFR 0.152.
 */
package de.dafuqs.spectrum.api.energy.color;

import de.dafuqs.spectrum.api.energy.color.InkColor;
import de.dafuqs.spectrum.api.energy.color.InkColorTags;
import de.dafuqs.spectrum.api.energy.color.InkColors;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import net.minecraft.class_5819;

public class InkColorMixes {
    private static final Map<InkColor, Map<InkColor, Float>> MIXES = new HashMap<InkColor, Map<InkColor, Float>>();

    public static void registerMix(InkColor color, Map<InkColor, Float> compounds) {
        MIXES.put(color, compounds);
    }

    public static void register() {
        InkColorMixes.registerMix(InkColors.LIGHT_BLUE, Map.of(InkColors.CYAN, Float.valueOf(0.6666667f), InkColors.MAGENTA, Float.valueOf(0.33333334f)));
        InkColorMixes.registerMix(InkColors.BLUE, Map.of(InkColors.CYAN, Float.valueOf(0.5f), InkColors.MAGENTA, Float.valueOf(0.33333334f), InkColors.YELLOW, Float.valueOf(0.16666667f)));
        InkColorMixes.registerMix(InkColors.PURPLE, Map.of(InkColors.CYAN, Float.valueOf(0.33333334f), InkColors.MAGENTA, Float.valueOf(0.5f), InkColors.YELLOW, Float.valueOf(0.16666667f)));
        InkColorMixes.registerMix(InkColors.PINK, Map.of(InkColors.MAGENTA, Float.valueOf(0.6666667f), InkColors.YELLOW, Float.valueOf(0.33333334f)));
        InkColorMixes.registerMix(InkColors.RED, Map.of(InkColors.MAGENTA, Float.valueOf(0.5f), InkColors.YELLOW, Float.valueOf(0.5f)));
        InkColorMixes.registerMix(InkColors.ORANGE, Map.of(InkColors.MAGENTA, Float.valueOf(0.33333334f), InkColors.YELLOW, Float.valueOf(0.6666667f)));
        InkColorMixes.registerMix(InkColors.LIME, Map.of(InkColors.CYAN, Float.valueOf(0.33333334f), InkColors.YELLOW, Float.valueOf(0.6666667f)));
        InkColorMixes.registerMix(InkColors.GREEN, Map.of(InkColors.CYAN, Float.valueOf(0.33333334f), InkColors.MAGENTA, Float.valueOf(0.16666667f), InkColors.YELLOW, Float.valueOf(0.5f)));
        InkColorMixes.registerMix(InkColors.BROWN, Map.of(InkColors.MAGENTA, Float.valueOf(0.16666667f), InkColors.YELLOW, Float.valueOf(0.33333334f), InkColors.BLACK, Float.valueOf(0.5f)));
        InkColorMixes.registerMix(InkColors.GRAY, Map.of(InkColors.BLACK, Float.valueOf(0.6666667f), InkColors.WHITE, Float.valueOf(0.33333334f)));
        InkColorMixes.registerMix(InkColors.LIGHT_GRAY, Map.of(InkColors.BLACK, Float.valueOf(0.33333334f), InkColors.WHITE, Float.valueOf(0.6666667f)));
    }

    public static Optional<Map<InkColor, Float>> getColorsToMix(InkColor color) {
        return Optional.ofNullable(MIXES.get(color));
    }

    public static boolean isMixedUsing(InkColor mixedColor, InkColor ingredientColor1, InkColor ingredientColor2) {
        Map<InkColor, Float> mix = MIXES.get(mixedColor);
        if (mix == null) {
            return false;
        }
        return mix.containsKey(ingredientColor1) && mix.containsKey(ingredientColor2);
    }

    public static InkColor getRandomMixedColor(InkColor color1, InkColor color2, class_5819 random) {
        boolean color1Elemental = color1.isIn(InkColorTags.ELEMENTAL_COLORS);
        boolean color2Elemental = color2.isIn(InkColorTags.ELEMENTAL_COLORS);
        if (color1Elemental && color2Elemental) {
            ArrayList<InkColor> possibleOutcomes = new ArrayList<InkColor>();
            for (Map.Entry<InkColor, Map<InkColor, Float>> entries : MIXES.entrySet()) {
                InkColor color = entries.getKey();
                if (!InkColorMixes.isMixedUsing(color, color1, color2)) continue;
                possibleOutcomes.add(color);
            }
            if (!possibleOutcomes.isEmpty()) {
                Collections.shuffle(possibleOutcomes);
                return (InkColor)possibleOutcomes.getFirst();
            }
            return color1;
        }
        if (color1Elemental) {
            return color1;
        }
        if (color2Elemental) {
            return color2;
        }
        return random.method_43056() ? color1 : color2;
    }
}

