/*
 * Decompiled with CFR 0.152.
 */
package de.dafuqs.spectrum.api.energy.storage;

import de.dafuqs.spectrum.api.energy.InkStorage;
import de.dafuqs.spectrum.api.energy.color.InkColor;
import de.dafuqs.spectrum.api.energy.color.InkColors;
import de.dafuqs.spectrum.helpers.Support;
import java.util.List;
import java.util.Map;
import net.minecraft.class_2561;

public class SingleInkStorage
implements InkStorage {
    protected final long maxEnergy;
    protected InkColor storedColor;
    protected long storedEnergy;

    public SingleInkStorage(long maxEnergy) {
        this.maxEnergy = maxEnergy;
        this.storedColor = InkColors.CYAN;
        this.storedEnergy = 0L;
    }

    public SingleInkStorage(long maxEnergy, InkColor color, long amount) {
        this.maxEnergy = maxEnergy;
        this.storedColor = color;
        this.storedEnergy = amount;
    }

    public InkColor getStoredColor() {
        return this.storedColor;
    }

    @Override
    public boolean accepts(InkColor color) {
        return this.storedEnergy == 0L || this.storedColor == color;
    }

    @Override
    public long addEnergy(InkColor color, long amount) {
        if (color == this.storedColor) {
            long resultingAmount;
            this.storedEnergy = resultingAmount = this.storedEnergy + amount;
            if (resultingAmount > this.maxEnergy) {
                long overflow = this.storedEnergy - this.maxEnergy;
                this.storedEnergy = this.maxEnergy;
                return overflow;
            }
            return 0L;
        }
        if (this.storedEnergy == 0L) {
            this.storedColor = color;
            this.storedEnergy = amount;
        }
        return amount;
    }

    @Override
    public boolean requestEnergy(InkColor color, long amount) {
        if (color == this.storedColor && amount >= this.storedEnergy) {
            this.storedEnergy -= amount;
            return true;
        }
        return false;
    }

    @Override
    public long drainEnergy(InkColor color, long amount) {
        if (color == this.storedColor) {
            long drainedAmount = Math.min(this.storedEnergy, amount);
            this.storedEnergy -= drainedAmount;
            return drainedAmount;
        }
        return 0L;
    }

    @Override
    public long getEnergy(InkColor color) {
        if (color == this.storedColor) {
            return this.storedEnergy;
        }
        return 0L;
    }

    @Override
    @Deprecated
    public Map<InkColor, Long> getEnergy() {
        return Map.of(this.storedColor, this.storedEnergy);
    }

    @Override
    @Deprecated
    public void setEnergy(Map<InkColor, Long> colors, long total) {
        for (Map.Entry<InkColor, Long> color : colors.entrySet()) {
            long value = color.getValue();
            if (value <= 0L) continue;
            this.storedColor = color.getKey();
            this.storedEnergy = color.getValue();
        }
    }

    @Override
    public long getMaxTotal() {
        return this.maxEnergy;
    }

    @Override
    public long getMaxPerColor() {
        return this.maxEnergy;
    }

    @Override
    public long getCurrentTotal() {
        return this.storedEnergy;
    }

    @Override
    public boolean isEmpty() {
        return this.storedEnergy == 0L;
    }

    @Override
    public boolean isFull() {
        return this.storedEnergy >= this.maxEnergy;
    }

    @Override
    public void addTooltip(List<class_2561> tooltip) {
        tooltip.add((class_2561)class_2561.method_43469((String)"item.spectrum.ink_storage.stores_up_to_ink_per_type", (Object[])new Object[]{Support.getShortenedNumberString(this.maxEnergy)}));
        if (this.storedEnergy > 0L) {
            InkStorage.addInkStoreBulletTooltip(tooltip, this.storedColor, this.storedEnergy);
        }
    }

    @Override
    public long getRoom(InkColor color) {
        if (this.storedEnergy == 0L || this.storedColor == color) {
            return this.maxEnergy - this.storedEnergy;
        }
        return 0L;
    }

    @Override
    public void fillCompletely() {
        this.storedEnergy = this.maxEnergy;
    }

    @Override
    public void method_5448() {
        this.storedEnergy = 0L;
    }

    public void convertColor(InkColor color) {
        this.storedColor = color;
    }
}

