/*
 * Decompiled with CFR 0.152.
 */
package de.dafuqs.spectrum.api.energy.storage;

import de.dafuqs.spectrum.api.energy.color.InkColor;
import de.dafuqs.spectrum.api.energy.color.InkColorMixes;
import de.dafuqs.spectrum.api.energy.color.InkColorTags;
import de.dafuqs.spectrum.api.energy.color.InkColors;
import de.dafuqs.spectrum.api.energy.storage.TotalCappedInkStorage;
import de.dafuqs.spectrum.helpers.Support;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_2561;

public class TotalCappedElementalMixingInkStorage
extends TotalCappedInkStorage {
    public TotalCappedElementalMixingInkStorage(long maxEnergyTotal, Map<InkColor, Long> storedEnergy) {
        super(maxEnergyTotal, storedEnergy);
    }

    @Override
    public boolean accepts(InkColor color) {
        return color.isIn(InkColorTags.ELEMENTAL_COLORS);
    }

    @Override
    public boolean requestEnergy(InkColor color, long amount) {
        long requiredAmount;
        long storedAmount;
        if (color.isIn(InkColorTags.ELEMENTAL_COLORS)) {
            long storedAmount2 = (Long)this.storedEnergy.get(color);
            if (storedAmount2 < amount) {
                return false;
            }
            this.currentTotal -= amount;
            this.storedEnergy.put(color, storedAmount2 - amount);
            return true;
        }
        Optional<Map<InkColor, Float>> requiredElementals = InkColorMixes.getColorsToMix(color);
        if (requiredElementals.isEmpty()) {
            return false;
        }
        for (Map.Entry<InkColor, Float> entry : requiredElementals.get().entrySet()) {
            storedAmount = (Long)this.storedEnergy.get(entry.getKey());
            if (storedAmount >= (requiredAmount = (long)((int)Math.ceil(entry.getValue().floatValue() * (float)amount)))) continue;
            return false;
        }
        for (Map.Entry<InkColor, Float> entry : requiredElementals.get().entrySet()) {
            storedAmount = (Long)this.storedEnergy.get(entry.getKey());
            requiredAmount = (int)Math.ceil(entry.getValue().floatValue() * (float)amount);
            this.currentTotal -= requiredAmount;
            this.storedEnergy.put(entry.getKey(), storedAmount - requiredAmount);
        }
        return true;
    }

    @Override
    public long drainEnergy(InkColor color, long amount) {
        long storedAmount;
        if (color.isIn(InkColorTags.ELEMENTAL_COLORS)) {
            long storedAmount2 = (Long)this.storedEnergy.get(color);
            long drainedAmount = Math.min(storedAmount2, amount);
            this.storedEnergy.put(color, storedAmount2 - drainedAmount);
            this.currentTotal -= drainedAmount;
            return drainedAmount;
        }
        Optional<Map<InkColor, Float>> requiredElementals = InkColorMixes.getColorsToMix(color);
        if (requiredElementals.isEmpty()) {
            return 0L;
        }
        float percentageAbleToDrain = 1.0f;
        for (Map.Entry<InkColor, Float> entry : requiredElementals.get().entrySet()) {
            long requiredAmount;
            storedAmount = (Long)this.storedEnergy.get(entry.getKey());
            if (storedAmount >= (requiredAmount = (long)((int)Math.ceil(entry.getValue().floatValue() * (float)amount)))) continue;
            percentageAbleToDrain = Math.min(percentageAbleToDrain, (float)storedAmount / (float)requiredAmount);
        }
        for (Map.Entry<InkColor, Float> entry : requiredElementals.get().entrySet()) {
            storedAmount = (Long)this.storedEnergy.get(entry.getKey());
            long drainedAmount = (int)Math.ceil(entry.getValue().floatValue() * (float)amount * percentageAbleToDrain);
            this.storedEnergy.put(entry.getKey(), storedAmount - drainedAmount);
        }
        long drainedAmount = (int)Math.floor(percentageAbleToDrain * (float)amount);
        this.currentTotal -= drainedAmount;
        return drainedAmount;
    }

    @Override
    public long getEnergy(InkColor color) {
        if (color.isIn(InkColorTags.ELEMENTAL_COLORS)) {
            return (Long)this.storedEnergy.get(color);
        }
        long maxAmount = Long.MAX_VALUE;
        Optional<Map<InkColor, Float>> requiredElementals = InkColorMixes.getColorsToMix(color);
        if (requiredElementals.isEmpty()) {
            return 0L;
        }
        for (Map.Entry<InkColor, Float> entry : requiredElementals.get().entrySet()) {
            long mixedAmount = (long)Math.floor(entry.getValue().floatValue() * (float)((Long)this.storedEnergy.get(entry.getKey())).longValue());
            maxAmount = Math.min(maxAmount, mixedAmount);
        }
        return maxAmount;
    }

    @Override
    public void fillCompletely() {
        this.storedEnergy.clear();
        List<InkColor> elementals = InkColors.elementals();
        if (elementals.isEmpty()) {
            return;
        }
        long energyPerColor = this.maxEnergyTotal / (long)elementals.size();
        for (InkColor color : elementals) {
            this.storedEnergy.put(color, energyPerColor);
        }
        this.currentTotal = energyPerColor * (long)elementals.size();
    }

    @Override
    public void method_5448() {
        this.storedEnergy.clear();
    }

    @Override
    public long getRoom(InkColor color) {
        if (color.isIn(InkColorTags.ELEMENTAL_COLORS)) {
            return this.maxEnergyTotal - this.currentTotal;
        }
        return 0L;
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public void addTooltip(List<class_2561> tooltip) {
        tooltip.add((class_2561)class_2561.method_43469((String)"item.spectrum.artists_palette.tooltip", (Object[])new Object[]{Support.getShortenedNumberString(this.maxEnergyTotal)}));
        tooltip.add((class_2561)class_2561.method_43471((String)"item.spectrum.artists_palette.tooltip.mix_on_demand"));
        this.addInkContentTooltip(tooltip);
    }
}

