/*
 * Decompiled with CFR 0.152.
 */
package de.dafuqs.spectrum.api.recipe;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Either;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.List;
import net.fabricmc.fabric.api.recipe.v1.ingredient.CustomIngredient;
import net.fabricmc.fabric.api.recipe.v1.ingredient.CustomIngredientSerializer;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1856;
import net.minecraft.class_1935;
import net.minecraft.class_2960;
import net.minecraft.class_5321;
import net.minecraft.class_6862;
import net.minecraft.class_7923;
import net.minecraft.class_7924;
import net.minecraft.class_9129;
import net.minecraft.class_9135;
import net.minecraft.class_9139;
import net.minecraft.class_9326;
import net.minecraft.class_9329;
import org.jetbrains.annotations.Nullable;

public class IngredientStack
implements CustomIngredient {
    private final class_1856 ingredient;
    private final class_9329 componentPredicate;
    private final class_9326 previewComponents;
    private final int count;
    private class_1792 item = null;
    private class_6862<class_1792> tag = null;
    public static final IngredientStack EMPTY = new IngredientStack(class_1856.field_9017, class_9329.field_49597, class_9326.field_49588, 0);
    @Nullable
    private List<class_1799> matchingStacks;

    public IngredientStack(class_1856 ingredient, class_9329 componentPredicate, class_9326 previewComponents, int count) {
        this.ingredient = ingredient;
        this.componentPredicate = componentPredicate;
        this.previewComponents = previewComponents;
        this.count = count;
    }

    private IngredientStack(class_1856 ingredient) {
        this(ingredient, class_9329.field_49597, class_9326.field_49588, 1);
    }

    public int getCount() {
        return this.count;
    }

    public class_1856 getIngredient() {
        return this.ingredient;
    }

    public static IngredientStack of(class_1856 ingredient) {
        return new IngredientStack(ingredient);
    }

    public static IngredientStack ofItems(class_1792 item) {
        return new IngredientStack(class_1856.method_8091((class_1935[])new class_1935[]{item}));
    }

    public static IngredientStack ofItems(class_1792 item, int count) {
        IngredientStack ingredientStack = new IngredientStack(class_1856.method_8091((class_1935[])new class_1935[]{item}), class_9329.field_49597, class_9326.field_49588, count);
        ingredientStack.item = item;
        return ingredientStack;
    }

    public static IngredientStack ofTag(class_6862<class_1792> tag) {
        return new IngredientStack(class_1856.method_8106(tag));
    }

    public static IngredientStack ofTag(class_6862<class_1792> tag, int count) {
        IngredientStack ingredientStack = new IngredientStack(class_1856.method_8106(tag), class_9329.field_49597, class_9326.field_49588, count);
        ingredientStack.tag = tag;
        return ingredientStack;
    }

    public boolean test(class_1799 itemStack) {
        return this.ingredient.method_8093(itemStack) && this.count <= itemStack.method_7947() && this.componentPredicate.method_57868(itemStack.method_57353());
    }

    public List<class_1799> getMatchingStacks() {
        if (this.matchingStacks == null) {
            class_1799[] matchingStacks = this.ingredient.method_8105();
            ArrayList<class_1799> stacks = new ArrayList<class_1799>(matchingStacks.length);
            for (class_1799 is : matchingStacks) {
                class_1799 stack = new class_1799((class_1935)is.method_7909(), this.count);
                stack.method_59692(this.previewComponents);
                stacks.add(stack);
            }
            this.matchingStacks = stacks;
        }
        return this.matchingStacks;
    }

    public boolean requiresTesting() {
        return true;
    }

    public boolean isEmpty() {
        return this == EMPTY || this.ingredient.method_8103();
    }

    public CustomIngredientSerializer<?> getSerializer() {
        return Serializer.INSTANCE;
    }

    public static class Serializer
    implements CustomIngredientSerializer<IngredientStack> {
        public static Serializer INSTANCE = new Serializer();
        public static final MapCodec<IngredientStack> MAP_CODEC = RecordCodecBuilder.mapCodec(i -> i.group((App)MapCodec.assumeMapUnsafe((Codec)class_1856.field_46096).forGetter(IngredientStack::getIngredient), (App)class_9329.field_49595.optionalFieldOf("components", (Object)class_9329.field_49597).forGetter(o -> o.componentPredicate), (App)class_9326.field_49589.optionalFieldOf("preview_components", (Object)class_9326.field_49588).forGetter(o -> o.previewComponents), (App)Codec.INT.optionalFieldOf("count", (Object)1).forGetter(o -> o.count)).apply((Applicative)i, IngredientStack::new));
        public static final Codec<IngredientStack> CODEC = Codec.withAlternative((Codec)MAP_CODEC.codec(), (Codec)Codec.xor((Codec)class_7923.field_41178.method_39673(), (Codec)class_6862.method_40093((class_5321)class_7924.field_41197)).xmap(either -> (IngredientStack)either.map(IngredientStack::ofItems, IngredientStack::ofTag), ingredientStack -> ingredientStack.item != null ? Either.left((Object)ingredientStack.item) : Either.right(ingredientStack.tag)));
        public static final class_9139<class_9129, IngredientStack> PACKET_CODEC = class_9139.method_56905((class_9139)class_1856.field_48355, o -> o.ingredient, (class_9139)class_9329.field_49596, o -> o.componentPredicate, (class_9139)class_9326.field_49590, o -> o.previewComponents, (class_9139)class_9135.field_48550, o -> o.count, IngredientStack::new);

        public class_2960 getIdentifier() {
            return class_2960.method_60654((String)"spectrum:ingredient_stack");
        }

        public MapCodec<IngredientStack> getCodec(boolean allowEmpty) {
            return MAP_CODEC;
        }

        public class_9139<class_9129, IngredientStack> getPacketCodec() {
            return PACKET_CODEC;
        }
    }
}

